/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.lucene;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.lucene.Indexed;
import org.hibernate.lucene.Keyword;
import org.hibernate.lucene.Text;
import org.hibernate.lucene.Unstored;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentBuilder<T> {
    private final List<Member> keywordGetters = new ArrayList<Member>();
    private final List<String> keywordNames = new ArrayList<String>();
    private final List<Member> unstoredGetters = new ArrayList<Member>();
    private final List<String> unstoredNames = new ArrayList<String>();
    private final List<Member> textGetters = new ArrayList<Member>();
    private final List<String> textNames = new ArrayList<String>();
    private final File file;
    private String idKeywordName;

    public DocumentBuilder(Class<T> clazz) {
        String fileName = DocumentBuilder.getTypeName(clazz, clazz.getAnnotation(Indexed.class).index());
        this.file = new File(fileName);
        for (Class<T> currClass = clazz; currClass != null; currClass = currClass.getSuperclass()) {
            Method[] methods = currClass.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Text textAnn;
                Unstored unstoredAnn;
                Method method = methods[i];
                Keyword keywordAnn = method.getAnnotation(Keyword.class);
                if (keywordAnn != null) {
                    String name = DocumentBuilder.getAttributeName(method, keywordAnn.name());
                    if (keywordAnn.id()) {
                        this.idKeywordName = name;
                    } else {
                        this.keywordGetters.add(method);
                        this.keywordNames.add(name);
                    }
                }
                if ((unstoredAnn = method.getAnnotation(Unstored.class)) != null) {
                    this.unstoredGetters.add(method);
                    this.unstoredNames.add(DocumentBuilder.getAttributeName(method, unstoredAnn.name()));
                }
                if ((textAnn = method.getAnnotation(Text.class)) == null) continue;
                this.textGetters.add(method);
                this.textNames.add(DocumentBuilder.getAttributeName(method, textAnn.name()));
            }
        }
        if (this.idKeywordName == null) {
            throw new HibernateException("No id Keyword for: " + clazz.getName());
        }
    }

    private Object getValue(Member member, T bean) {
        try {
            if (member instanceof Field) {
                return ((Field)member).get(bean);
            }
            if (member instanceof Method) {
                return ((Method)member).invoke(bean, new Object[0]);
            }
            throw new AssertionFailure("Unexpected member: " + member.getClass().getName());
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not get property value", e);
        }
    }

    public Document getDocument(T instance, Serializable id) {
        Object value;
        int i;
        Document doc = new Document();
        doc.add(org.apache.lucene.document.Field.Keyword((String)this.idKeywordName, (String)id.toString()));
        for (i = 0; i < this.keywordNames.size(); ++i) {
            Member member = this.keywordGetters.get(i);
            Object value2 = this.getValue(member, instance);
            if (value2 == null) continue;
            doc.add(org.apache.lucene.document.Field.Keyword((String)this.keywordNames.get(i), (String)DocumentBuilder.toString(value2)));
        }
        for (i = 0; i < this.textNames.size(); ++i) {
            value = this.getValue(this.textGetters.get(i), instance);
            if (value == null) continue;
            doc.add(org.apache.lucene.document.Field.Text((String)this.textNames.get(i), (String)DocumentBuilder.toString(value)));
        }
        for (i = 0; i < this.unstoredNames.size(); ++i) {
            value = this.getValue(this.unstoredGetters.get(i), instance);
            if (value == null) continue;
            doc.add(org.apache.lucene.document.Field.UnStored((String)this.unstoredNames.get(i), (String)DocumentBuilder.toString(value)));
        }
        return doc;
    }

    private static String toString(Object value) {
        return value.toString();
    }

    public Term getTerm(Serializable id) {
        return new Term(this.idKeywordName, id.toString());
    }

    private static String getAttributeName(Method method, String name) {
        return "".equals(name) ? method.getName().substring(3) : name;
    }

    private static String getTypeName(Class clazz, String name) {
        return "".equals(name) ? clazz.getName() : name;
    }

    public File getFile() {
        return this.file;
    }
}

