/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.lang.reflect.AnnotatedElement;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import org.hibernate.cfg.ClassPropertyHolder;
import org.hibernate.cfg.CollectionPropertyHolder;
import org.hibernate.cfg.ComponentPropertyHolder;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyHolderBuilder {
    private PropertyHolderBuilder() {
    }

    public static PropertyHolder buildPropertyHolder(PersistentClass persistentClass, Map<String, Column[]> columnOverride, Map<String, Join> joins) {
        return new ClassPropertyHolder(persistentClass, columnOverride, joins);
    }

    public static PropertyHolder buildPropertyHolder(Component component, String path, Map<String, Column[]> columnOverride) {
        return new ComponentPropertyHolder(component, path, columnOverride);
    }

    public static PropertyHolder buildPropertyHolder(Collection collection, String path) {
        return new CollectionPropertyHolder(collection, path);
    }

    public static PropertyHolder buildPropertyHolder(PersistentClass persistentClass, Map<String, Join> joins) {
        return PropertyHolderBuilder.buildPropertyHolder(persistentClass, new HashMap<String, Column[]>(), joins);
    }

    public static Map<String, Column[]> buildColumnOverride(AnnotatedElement element, String path) {
        AttributeOverride singleOverride = element.getAnnotation(AttributeOverride.class);
        AttributeOverrides multipleOverrides = element.getAnnotation(AttributeOverrides.class);
        AttributeOverride[] overrides = singleOverride != null ? new AttributeOverride[]{singleOverride} : (multipleOverrides != null ? multipleOverrides.value() : null);
        HashMap<String, Column[]> columnOverride = new HashMap<String, Column[]>();
        if (overrides != null) {
            for (AttributeOverride depAttr : overrides) {
                columnOverride.put(StringHelper.qualify((String)path, (String)depAttr.name()), new Column[]{depAttr.column()});
            }
        }
        return columnOverride;
    }
}

