/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.security.Principal;
import java.security.acl.Group;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.metadata.SecurityRoleMetaData;
import org.jboss.security.SecurityRolesAssociation;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.spi.AbstractServerLoginModule;

public class DeploymentRolesLoginModule
extends AbstractServerLoginModule {
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.useFirstPass = true;
    }

    protected Principal getIdentity() {
        Object username = this.sharedState.get("javax.security.auth.login.name");
        if (username == null) {
            throw new IllegalStateException("Expected to find the username in the shared state");
        }
        if (username instanceof Principal) {
            return (Principal)username;
        }
        return new SimplePrincipal((String)username);
    }

    protected Group[] getRoleSets() throws LoginException {
        SimpleGroup group = new SimpleGroup("Roles");
        Iterator itRoleNames = this.getSecurityRoleNames().iterator();
        while (itRoleNames.hasNext()) {
            String roleName = (String)itRoleNames.next();
            group.addMember(new SimplePrincipal(roleName));
        }
        return new Group[]{group};
    }

    private Set getSecurityRoleNames() {
        HashSet<String> roleNames = new HashSet<String>();
        String userName = this.getIdentity().getName();
        Map securityRoles = SecurityRolesAssociation.getSecurityRoles();
        if (securityRoles != null) {
            Iterator it = securityRoles.values().iterator();
            while (it.hasNext()) {
                SecurityRoleMetaData srMetaData = (SecurityRoleMetaData)it.next();
                if (!srMetaData.getPrincipals().contains(userName)) continue;
                roleNames.add(srMetaData.getRoleName());
            }
        }
        return roleNames;
    }
}

