/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.deployment;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javassist.ClassPool;
import org.jboss.aop.AOPClassPool;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassPoolFactory;
import org.jboss.aop.deployment.JBossClassPool32;
import org.jboss.mx.loading.UnifiedClassLoader;

public class JBossClassPoolFactory32
implements ClassPoolFactory {
    protected File tmpClassesDir;

    public JBossClassPoolFactory32(File tmpClassesDir) throws IOException {
        this.tmpClassesDir = tmpClassesDir;
    }

    public AOPClassPool create(ClassLoader cl, ClassPool src, AspectManager manager) {
        try {
            File tempdir = this.createTempDir(cl);
            return new JBossClassPool32(cl, src, manager, tempdir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public AOPClassPool create(ClassPool src, AspectManager manager) {
        return new JBossClassPool32(src, manager);
    }

    public File createTempDir(ClassLoader cl) throws IOException {
        if (!(cl instanceof UnifiedClassLoader)) {
            return null;
        }
        File tempdir = File.createTempFile("ucl", "", this.tmpClassesDir);
        tempdir.delete();
        tempdir.mkdir();
        tempdir.deleteOnExit();
        UnifiedClassLoader ucl = (UnifiedClassLoader)cl;
        URL tmpURL = tempdir.toURL();
        URL tmpCP = new URL(tmpURL, "?dynamic=true");
        if (ucl.getLoaderRepository() != null) {
            ucl.addURL(tmpCP);
        }
        return tempdir;
    }
}

