/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.tc5.jca;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.resource.ResourceException;
import javax.servlet.ServletException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.valves.ValveBase;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.resource.connectionmanager.CachedConnectionManager;

public class CachedConnectionValve
extends ValveBase
implements Lifecycle {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$web$tomcat$tc5$jca$CachedConnectionValve == null ? (class$org$jboss$web$tomcat$tc5$jca$CachedConnectionValve = CachedConnectionValve.class$("org.jboss.web.tomcat.tc5.jca.CachedConnectionValve")) : class$org$jboss$web$tomcat$tc5$jca$CachedConnectionValve));
    private static final String info = "CachedConnectionValve/1.0";
    protected LifecycleSupport support = new LifecycleSupport((Lifecycle)this);
    protected String ccmName;
    protected CachedConnectionManager ccm;
    protected String tmName;
    protected TransactionManager tm;
    protected Set unsharableResources = new HashSet();
    static /* synthetic */ Class class$org$jboss$web$tomcat$tc5$jca$CachedConnectionValve;

    public String getInfo() {
        return info;
    }

    public String getCachedConnectionManagerObjectName() {
        return this.ccmName;
    }

    public void setCachedConnectionManagerObjectName(String ccmName) {
        this.ccmName = ccmName;
    }

    public String getTransactionManagerObjectName() {
        return this.tmName;
    }

    public void setTransactionManagerObjectName(String tmName) {
        this.tmName = tmName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        try {
            this.ccm.pushMetaAwareObject((Object)this, this.unsharableResources);
            try {
                this.getNext().invoke(request, response);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    this.ccm.popMetaAwareObject(this.unsharableResources);
                }
                finally {
                    this.checkTransactionComplete(request);
                }
                throw throwable;
            }
            try {
                this.ccm.popMetaAwareObject(this.unsharableResources);
            }
            finally {
                this.checkTransactionComplete(request);
            }
        }
        catch (ResourceException e) {
            throw new ServletException("Error invoking cached connection manager", (Throwable)e);
        }
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.support.addLifecycleListener(listener);
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.support.removeLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.support.findLifecycleListeners();
    }

    public void start() throws LifecycleException {
        try {
            MBeanServer server = MBeanServerLocator.locateJBoss();
            this.ccm = (CachedConnectionManager)server.getAttribute(new ObjectName(this.ccmName), "Instance");
            this.tm = (TransactionManager)server.getAttribute(new ObjectName(this.tmName), "TransactionManager");
        }
        catch (Exception e) {
            throw new LifecycleException((Throwable)e);
        }
        this.support.fireLifecycleEvent("start", (Object)this);
    }

    public void stop() throws LifecycleException {
        this.support.fireLifecycleEvent("stop", (Object)this);
        this.unsharableResources.clear();
    }

    protected void checkTransactionComplete(Request request) {
        int status = 6;
        try {
            status = this.tm.getStatus();
        }
        catch (SystemException ex) {
            log.error((Object)"Failed to get status", (Throwable)ex);
        }
        switch (status) {
            case 0: 
            case 1: 
            case 7: 
            case 8: 
            case 9: {
                try {
                    this.tm.rollback();
                }
                catch (Exception ex) {
                    log.error((Object)"Failed to rollback", (Throwable)ex);
                }
            }
            case 2: {
                String servletName = "<Unknown>";
                try {
                    Wrapper servlet = request.getWrapper();
                    if (servlet != null) {
                        servletName = servlet.getName();
                        if (servlet.getJspFile() != null) {
                            servletName = servlet.getJspFile();
                        }
                    }
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
                String msg = "Application error: " + servletName + " did not complete its transaction";
                log.error((Object)msg);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

