/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmppoller.job;

import com.clustercontrol.sharedtable.bean.DataTable;
import com.clustercontrol.snmppoller.FacilityNotFoundExciption;
import com.clustercontrol.snmppoller.SnmpConfig;
import com.clustercontrol.snmppoller.SnmpPoller;
import com.clustercontrol.snmppoller.SnmpSharedTable;
import com.clustercontrol.snmppoller.util.JNDIConnectionManager;
import java.util.HashMap;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PollingThread
implements Runnable {
    protected static Log m_log = LogFactory.getLog(PollingThread.class);
    private SnmpPoller m_poller = new SnmpPoller();
    private SnmpConfig snmpConfig;
    private List oids;
    private String tableJndiName;
    private String facilityId;

    public PollingThread(SnmpConfig snmpConfig, List oids, String tableJndiName, String facilityId) {
        this.snmpConfig = snmpConfig;
        this.oids = oids;
        this.tableJndiName = tableJndiName;
        this.facilityId = facilityId;
    }

    public void run() {
        m_log.debug((Object)("run start : " + this.tableJndiName + "  " + this.facilityId));
        DataTable dataTable = new DataTable();
        this.m_poller.polling(this.snmpConfig.getAddress(), this.snmpConfig.getPort(), this.snmpConfig.getVersion(), this.snmpConfig.getComunity(), this.snmpConfig.getRetries(), this.snmpConfig.getTimeout(), this.oids, dataTable);
        try {
            InitialContext iniCtx = JNDIConnectionManager.getInitialContext();
            Object obj = iniCtx.lookup(this.tableJndiName);
            SnmpSharedTable table = (SnmpSharedTable)PortableRemoteObject.narrow((Object)obj, SnmpSharedTable.class);
            table.setValueAll(this.facilityId, dataTable);
        }
        catch (NamingException e) {
            m_log.error((Object)e);
        }
        catch (FacilityNotFoundExciption e) {
            m_log.error((Object)e);
        }
        m_log.debug((Object)("run end   : " + this.tableJndiName + "  " + this.facilityId));
    }

    public SnmpConfig getSnmpConfig() {
        return this.snmpConfig;
    }

    public void setSnmpConfig(SnmpConfig snmpConfig) {
        this.snmpConfig = snmpConfig;
    }

    public static void main(String[] args) {
        HashMap hm = new HashMap();
        for (String facilityId : hm.keySet()) {
            SnmpConfig config = (SnmpConfig)hm.get(facilityId);
            PollingThread pt = new PollingThread(config, null, "table", facilityId);
            Thread th = new Thread(pt);
            th.start();
        }
    }
}

