/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import java.util.Iterator;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import javax.management.monitor.GaugeMonitorMBean;
import javax.management.monitor.Monitor;
import javax.management.monitor.MonitorNotification;
import org.jboss.mx.util.MonitorCallback;
import org.jboss.mx.util.MonitorRunnable;
import org.jboss.mx.util.ObservedObject;

public class GaugeMonitor
extends Monitor
implements GaugeMonitorMBean {
    int THRESHOLD_HIGH_EXCEEDED_NOTIFIED = 16;
    int THRESHOLD_LOW_EXCEEDED_NOTIFIED = 32;
    int THRESHOLD_ERROR_NOTIFIED = 64;
    boolean differenceMode = false;
    Number highThreshold = new Integer(0);
    Number lowThreshold = new Integer(0);
    boolean notifyHigh = false;
    boolean notifyLow = false;
    private MonitorRunnable monitorRunnable;

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] result = new MBeanNotificationInfo[1];
        String[] types = new String[]{"jmx.monitor.error.runtime", "jmx.monitor.error.mbean", "jmx.monitor.error.attribute", "jmx.monitor.error.type", "jmx.monitor.error.threshold", "jmx.monitor.gauge.high", "jmx.monitor.gauge.low"};
        result[0] = new MBeanNotificationInfo(types, "javax.management.monitor.MonitorNotification", "Notifications sent by the Gauge Monitor Service MBean");
        return result;
    }

    public Number getDerivedGauge() {
        ObservedObject object = this.getFirstObservedObject();
        if (object != null) {
            return (Number)object.getDerivedGauge();
        }
        return null;
    }

    public Number getDerivedGauge(ObjectName name) {
        ObservedObject object = this.retrieveObservedObject(name);
        if (object != null) {
            return (Number)object.getDerivedGauge();
        }
        return null;
    }

    public long getDerivedGaugeTimeStamp() {
        ObservedObject object = this.getFirstObservedObject();
        if (object != null) {
            return object.getDerivedGaugeTimeStamp();
        }
        return 0L;
    }

    public long getDerivedGaugeTimeStamp(ObjectName name) {
        ObservedObject object = this.retrieveObservedObject(name);
        if (object != null) {
            return object.getDerivedGaugeTimeStamp();
        }
        return 0L;
    }

    public boolean getDifferenceMode() {
        return this.differenceMode;
    }

    public void setDifferenceMode(boolean value) {
        this.differenceMode = value;
    }

    public boolean getNotifyHigh() {
        return this.notifyHigh;
    }

    public void setNotifyHigh(boolean value) {
        this.notifyHigh = value;
    }

    public boolean getNotifyLow() {
        return this.notifyLow;
    }

    public void setNotifyLow(boolean value) {
        this.notifyLow = value;
    }

    public Number getHighThreshold() {
        return this.highThreshold;
    }

    public Number getLowThreshold() {
        return this.lowThreshold;
    }

    public void setThresholds(Number highValue, Number lowValue) throws IllegalArgumentException {
        if (highValue == null) {
            throw new IllegalArgumentException("Null high threshold");
        }
        if (lowValue == null) {
            throw new IllegalArgumentException("Null low threshold");
        }
        if (highValue.getClass() != lowValue.getClass()) {
            throw new IllegalArgumentException("High and low different types");
        }
        if (highValue.doubleValue() < lowValue.doubleValue()) {
            throw new IllegalArgumentException("High less than low threshold");
        }
        this.highThreshold = highValue;
        this.lowThreshold = lowValue;
    }

    public synchronized void start() {
        if (this.active) {
            return;
        }
        this.active = true;
        Iterator i = this.retrieveObservedObjects().values().iterator();
        while (i.hasNext()) {
            ObservedObject object = (ObservedObject)i.next();
            this.initObservedObject(object);
        }
        MonitorCallback callback = new MonitorCallback(){

            public void monitorCallback(ObservedObject object, MBeanAttributeInfo attributeInfo, Object value) throws Exception {
                GaugeMonitor.this.monitor(object, attributeInfo, value);
            }

            public MonitorNotification createNotification(String type, Object source, long timeStamp, String message, Object derivedGauge, String observedAttribute, ObjectName observedObject, Object trigger) {
                return new MonitorNotification(type, source, GaugeMonitor.this.nextSeqNo(), timeStamp, message, derivedGauge, observedAttribute, observedObject, trigger);
            }
        };
        this.monitorRunnable = new MonitorRunnable(this, this.objectName, callback, (Map)this.observedObjects, this.server);
    }

    public synchronized void stop() {
        if (!this.active) {
            return;
        }
        this.active = false;
        this.monitorRunnable.setScheduler(null);
        this.monitorRunnable = null;
    }

    void initObservedObject(ObservedObject object) {
        super.initObservedObject(object);
        object.setDerivedGauge(new Integer(0));
        object.setLastValue(null);
    }

    void monitor(ObservedObject object, MBeanAttributeInfo attributeInfo, Object value) throws Exception {
        if (!(value instanceof Number)) {
            this.sendAttributeTypeErrorNotification(object, "Attribute is not a number");
            return;
        }
        if (this.highThreshold.getClass() != value.getClass() || this.lowThreshold.getClass() != value.getClass()) {
            this.sendThresholdErrorNotification(object, value);
            return;
        }
        Number number = (Number)value;
        Number lastValue = (Number)object.getLastValue();
        Number derivedGauge = (Number)object.getDerivedGauge();
        derivedGauge = this.differenceMode ? (Number)(lastValue == null ? (Number)this.getZero(number) : (Number)this.sub(number, lastValue)) : (Number)number;
        object.setDerivedGauge(derivedGauge);
        object.setDerivedGaugeTimeStamp(System.currentTimeMillis());
        if (derivedGauge.doubleValue() <= this.lowThreshold.doubleValue() && object.notAlreadyNotified(this.THRESHOLD_LOW_EXCEEDED_NOTIFIED)) {
            object.setNotAlreadyNotified(this.THRESHOLD_HIGH_EXCEEDED_NOTIFIED);
            this.sendThresholdLowExceededNotification(object, derivedGauge);
        }
        if (derivedGauge.doubleValue() >= this.highThreshold.doubleValue() && object.notAlreadyNotified(this.THRESHOLD_HIGH_EXCEEDED_NOTIFIED)) {
            object.setNotAlreadyNotified(this.THRESHOLD_LOW_EXCEEDED_NOTIFIED);
            this.sendThresholdHighExceededNotification(object, derivedGauge);
        }
        object.setLastValue(number);
    }

    Number getZero(Number value) {
        if (value instanceof Byte) {
            return new Byte(0);
        }
        if (value instanceof Integer) {
            return new Integer(0);
        }
        if (value instanceof Long) {
            return new Long(0L);
        }
        if (value instanceof Short) {
            return new Short(0);
        }
        if (value instanceof Float) {
            return new Float(0.0f);
        }
        return new Double(0.0);
    }

    Number sub(Number value1, Number value2) {
        if (value1 instanceof Byte) {
            return new Byte((byte)(value1.byteValue() - value2.byteValue()));
        }
        if (value1 instanceof Integer) {
            return new Integer(value1.intValue() - value2.intValue());
        }
        if (value1 instanceof Long) {
            return new Long(value1.longValue() - value2.longValue());
        }
        if (value1 instanceof Short) {
            return new Short((short)(value1.shortValue() - value2.shortValue()));
        }
        if (value1 instanceof Float) {
            return new Float(value1.floatValue() - value2.floatValue());
        }
        return new Double(value1.doubleValue() - value2.doubleValue());
    }

    void sendThresholdLowExceededNotification(ObservedObject object, Object value) {
        if (this.notifyLow) {
            this.sendNotification(object, "jmx.monitor.gauge.low", object.getDerivedGaugeTimeStamp(), "low threshold exceeded", this.observedAttribute, value, this.lowThreshold);
        }
    }

    void sendThresholdHighExceededNotification(ObservedObject object, Object value) {
        if (this.notifyHigh) {
            this.sendNotification(object, "jmx.monitor.gauge.high", object.getDerivedGaugeTimeStamp(), "high threshold exceeded", this.observedAttribute, value, this.highThreshold);
        }
    }

    void sendThresholdErrorNotification(ObservedObject object, Object value) {
        if (object.notAlreadyNotified(this.THRESHOLD_ERROR_NOTIFIED)) {
            this.sendNotification(object, "jmx.monitor.error.threshold", object.getDerivedGaugeTimeStamp(), "High or Low Threshold not the correct type", this.observedAttribute, null, null);
        }
    }
}

