/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server;

import javax.jms.JMSException;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.Subscription;
import org.jboss.mq.pm.Tx;
import org.jboss.mq.server.BasicQueue;
import org.jboss.mq.server.BasicQueueParameters;
import org.jboss.mq.server.JMSDestinationManager;
import org.jboss.mq.server.MessageReference;

public class ExclusiveQueue
extends BasicQueue {
    Subscription exclusive;
    boolean removed = false;

    public ExclusiveQueue(JMSDestinationManager server, SpyDestination destination, Subscription exclusive, BasicQueueParameters parameters) throws JMSException {
        super(server, destination.toString() + "." + exclusive.connectionToken.getClientID() + '.' + exclusive.subscriptionId, parameters);
        this.exclusive = exclusive;
    }

    public Subscription getExclusiveSubscription() {
        return this.exclusive;
    }

    public void addMessage(MessageReference mesRef, Tx txId) throws JMSException {
        if (this.removed || !this.exclusive.accepts(mesRef.getHeaders())) {
            this.dropMessage(mesRef);
        } else {
            super.addMessage(mesRef, txId);
        }
    }

    public void restoreMessage(MessageReference mesRef) {
        if (this.removed) {
            this.dropMessage(mesRef);
        } else {
            super.restoreMessage(mesRef);
        }
    }

    protected void nackMessage(MessageReference mesRef) {
        if (this.removed) {
            this.dropMessage(mesRef);
        } else {
            super.nackMessage(mesRef);
        }
    }

    public void removeSubscriber(Subscription sub) {
        this.removed = true;
        super.removeSubscriber(sub);
    }
}

