/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import org.jboss.logging.Logger;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.DestinationFullException;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.Subscription;
import org.jboss.mq.pm.Tx;
import org.jboss.mq.selectors.Selector;
import org.jboss.mq.server.BasicQueueParameters;
import org.jboss.mq.server.ClientConsumer;
import org.jboss.mq.server.JMSDestinationManager;
import org.jboss.mq.server.MessageCache;
import org.jboss.mq.server.MessageCounter;
import org.jboss.mq.server.MessageReference;
import org.jboss.mq.server.Receivers;
import org.jboss.mq.server.ReceiversImpl;
import org.jboss.mq.server.RoutedMessage;
import org.jboss.util.timeout.Timeout;
import org.jboss.util.timeout.TimeoutFactory;
import org.jboss.util.timeout.TimeoutTarget;

public class BasicQueue {
    static final Logger log = Logger.getLogger((Class)BasicQueue.class);
    SortedSet messages = new TreeSet();
    ConcurrentHashMap events = new ConcurrentHashMap();
    SynchronizedInt scheduledMessageCount = new SynchronizedInt(0);
    JMSDestinationManager server;
    Receivers receivers;
    String description;
    MessageCounter counter;
    HashMap unacknowledgedMessages = new HashMap();
    HashMap unackedByMessageRef = new HashMap();
    HashMap unackedBySubscription = new HashMap();
    HashSet subscribers = new HashSet();
    HashSet removedSubscribers = new HashSet();
    BasicQueueParameters parameters;
    boolean stopped = false;

    public BasicQueue(JMSDestinationManager server, String description, BasicQueueParameters parameters) throws JMSException {
        this.server = server;
        this.description = description;
        this.parameters = parameters;
        Class receiversImpl = parameters.receiversImpl;
        if (receiversImpl == null) {
            receiversImpl = ReceiversImpl.class;
        }
        try {
            this.receivers = (Receivers)receiversImpl.newInstance();
        }
        catch (Throwable t) {
            throw new SpyJMSException("Error instantiating receivers implementation: " + receiversImpl, t);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public int getReceiversCount() {
        return this.receivers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getReceivers() {
        Receivers receivers = this.receivers;
        synchronized (receivers) {
            return this.receivers.listReceivers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInUse() {
        Receivers receivers = this.receivers;
        synchronized (receivers) {
            return this.subscribers.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReceiver(Subscription sub) throws JMSException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("addReceiver " + sub + " " + this));
        }
        MessageReference found = null;
        SortedSet sortedSet = this.messages;
        synchronized (sortedSet) {
            if (this.messages.size() != 0) {
                Iterator it = this.messages.iterator();
                while (it.hasNext()) {
                    MessageReference message = (MessageReference)it.next();
                    try {
                        if (message.isExpired()) {
                            it.remove();
                            if (trace) {
                                log.trace((Object)("message expired: " + message));
                            }
                            this.dropMessage(message);
                            continue;
                        }
                        if (!sub.accepts(message.getHeaders())) continue;
                        it.remove();
                        found = message;
                        break;
                    }
                    catch (JMSException ignore) {
                        log.info((Object)"Caught unusual exception in addToReceivers.", (Throwable)ignore);
                    }
                }
            }
        }
        if (found != null) {
            this.queueMessageForSending(sub, found);
        } else {
            this.addToReceivers(sub);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscriber(Subscription sub) throws JMSException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("addSubscriber " + sub + " " + this));
        }
        Receivers receivers = this.receivers;
        synchronized (receivers) {
            if (this.stopped) {
                throw new IllegalStateException("The destination is stopped " + this.getDescription());
            }
            this.subscribers.add(sub);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscriber(Subscription sub) {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("removeSubscriber " + sub + " " + this));
        }
        Receivers receivers = this.receivers;
        synchronized (receivers) {
            this.removeReceiver(sub);
            SortedSet sortedSet = this.messages;
            synchronized (sortedSet) {
                if (this.hasUnackedMessages(sub)) {
                    if (trace) {
                        log.trace((Object)("Delaying removal of subscriber is has unacked messages " + sub));
                    }
                    this.removedSubscribers.add(sub);
                } else {
                    if (trace) {
                        log.trace((Object)("Removing subscriber " + sub));
                    }
                    this.subscribers.remove(sub);
                    ((ClientConsumer)sub.clientConsumer).removeRemovedSubscription(sub.subscriptionId);
                }
            }
        }
    }

    public int getQueueDepth() {
        return this.messages.size();
    }

    public int getScheduledMessageCount() {
        return this.scheduledMessageCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(MessageReference mes, Tx txId) throws JMSException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("addMessage " + mes + " " + txId + " " + this));
        }
        try {
            Object object = this.receivers;
            synchronized (object) {
                if (this.stopped) {
                    throw new IllegalStateException("The destination is stopped " + this.getDescription());
                }
            }
            if (this.parameters.maxDepth > 0) {
                object = this.messages;
                synchronized (object) {
                    if (this.messages.size() >= this.parameters.maxDepth) {
                        this.dropMessage(mes);
                        String message = "Maximum size " + this.parameters.maxDepth + " exceeded for " + this.description;
                        log.warn((Object)message);
                        throw new DestinationFullException(message);
                    }
                }
            }
            Runnable task = new AddMessagePostRollBackTask(mes);
            this.server.getPersistenceManager().getTxManager().addPostRollbackTask(txId, task);
            task = new AddMessagePostCommitTask(mes);
            this.server.getPersistenceManager().getTxManager().addPostCommitTask(txId, task);
        }
        catch (Throwable t) {
            String error = "Error in addMessage " + mes;
            log.trace((Object)error, t);
            this.dropMessage(mes, txId);
            SpyJMSException.rethrowAsJMSException(error, t);
        }
    }

    public void restoreMessage(MessageReference mes) {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("restoreMessage " + mes + " " + this));
        }
        this.internalAddMessage(mes);
    }

    protected void nackMessage(MessageReference message) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Restoring message: " + message));
        }
        try {
            message.redelivered();
            message.invalidate();
            if (message.isPersistent()) {
                this.server.getPersistenceManager().update(message, null);
            }
        }
        catch (JMSException e) {
            log.error((Object)("Caught unusual exception in nackMessage for " + message), (Throwable)e);
        }
        this.internalAddMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpyMessage[] browse(String selector) throws JMSException {
        if (selector == null) {
            SpyMessage[] list;
            SortedSet sortedSet = this.messages;
            synchronized (sortedSet) {
                list = new SpyMessage[this.messages.size()];
                Iterator iter = this.messages.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    list[i] = ((MessageReference)iter.next()).getMessageForDelivery();
                    ++i;
                }
            }
            return list;
        }
        Selector s = new Selector(selector);
        LinkedList<SpyMessage> selection = new LinkedList<SpyMessage>();
        SortedSet iter = this.messages;
        synchronized (iter) {
            Iterator i = this.messages.iterator();
            while (i.hasNext()) {
                MessageReference m = (MessageReference)i.next();
                if (!s.test(m.getHeaders())) continue;
                selection.add(m.getMessageForDelivery());
            }
        }
        SpyMessage[] list = new SpyMessage[selection.size()];
        list = selection.toArray(list);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpyMessage receive(Subscription sub, boolean wait) throws JMSException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("receive " + sub + " wait=" + wait + " " + this));
        }
        MessageReference messageRef = null;
        Receivers receivers = this.receivers;
        synchronized (receivers) {
            if (this.stopped) {
                throw new IllegalStateException("The destination is stopped " + this.getDescription());
            }
            if (sub.getSelector() == null && !sub.noLocal) {
                SortedSet sortedSet = this.messages;
                synchronized (sortedSet) {
                    while (this.messages.size() != 0) {
                        messageRef = (MessageReference)this.messages.first();
                        this.messages.remove(messageRef);
                        if (!messageRef.isExpired()) break;
                        if (trace) {
                            log.trace((Object)("message expired: " + messageRef));
                        }
                        this.dropMessage(messageRef);
                        messageRef = null;
                    }
                }
            }
            SortedSet sortedSet = this.messages;
            synchronized (sortedSet) {
                Iterator i = this.messages.iterator();
                while (i.hasNext()) {
                    MessageReference mr = (MessageReference)i.next();
                    if (mr.isExpired()) {
                        i.remove();
                        if (trace) {
                            log.trace((Object)("message expired: " + mr));
                        }
                        this.dropMessage(mr);
                        continue;
                    }
                    if (!sub.accepts(mr.getHeaders())) continue;
                    messageRef = mr;
                    i.remove();
                    break;
                }
            }
            if (messageRef == null) {
                if (wait) {
                    this.addToReceivers(sub);
                }
            } else {
                this.setupMessageAcknowledgement(sub, messageRef);
            }
        }
        if (messageRef == null) {
            return null;
        }
        return messageRef.getMessageForDelivery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledge(AcknowledgementRequest item, Tx txId) throws JMSException {
        Runnable task;
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("acknowledge " + item + " " + txId + " " + this));
        }
        UnackedMessageInfo unacked = null;
        SortedSet sortedSet = this.messages;
        synchronized (sortedSet) {
            unacked = (UnackedMessageInfo)this.unacknowledgedMessages.remove(item);
            if (unacked == null) {
                return;
            }
            this.unackedByMessageRef.remove(unacked.messageRef);
            HashMap map = (HashMap)this.unackedBySubscription.get(unacked.sub);
            if (map != null) {
                map.remove(unacked.messageRef);
            }
            if (map == null || map.isEmpty()) {
                this.unackedBySubscription.remove(unacked.sub);
            }
        }
        MessageReference m = unacked.messageRef;
        if (!item.isAck) {
            task = new RestoreMessageTask(m);
            this.server.getPersistenceManager().getTxManager().addPostCommitTask(txId, task);
        } else {
            if (m.isPersistent()) {
                this.server.getPersistenceManager().remove(m, txId);
            }
            task = new RestoreMessageTask(m);
            this.server.getPersistenceManager().getTxManager().addPostRollbackTask(txId, task);
            task = new RemoveMessageTask(m);
            this.server.getPersistenceManager().getTxManager().addPostCommitTask(txId, task);
        }
        Receivers receivers = this.receivers;
        synchronized (receivers) {
            SortedSet sortedSet2 = this.messages;
            synchronized (sortedSet2) {
                this.checkRemovedSubscribers(unacked.sub);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nackMessages(Subscription sub) {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("nackMessages " + sub + " " + this));
        }
        Receivers receivers = this.receivers;
        synchronized (receivers) {
            SortedSet sortedSet = this.messages;
            synchronized (sortedSet) {
                int count = 0;
                HashMap map = (HashMap)this.unackedBySubscription.get(sub);
                if (map != null) {
                    Iterator i = ((HashMap)map.clone()).values().iterator();
                    while (i.hasNext()) {
                        AcknowledgementRequest item = (AcknowledgementRequest)i.next();
                        try {
                            this.acknowledge(item, null);
                            ++count;
                        }
                        catch (JMSException ignore) {
                            log.debug((Object)("Unable to nack message: " + item), (Throwable)ignore);
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Nacked " + count + " messages for removed subscription " + sub));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllMessages() throws JMSException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("removeAllMessages " + this));
        }
        Iterator i = this.events.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            MessageReference message = (MessageReference)entry.getKey();
            Timeout timeout = (Timeout)entry.getValue();
            timeout.cancel();
            i.remove();
            this.dropMessage(message);
        }
        this.scheduledMessageCount.set(0);
        Receivers receivers = this.receivers;
        synchronized (receivers) {
            SortedSet sortedSet = this.messages;
            synchronized (sortedSet) {
                Iterator<Object> i2 = ((HashMap)this.unacknowledgedMessages.clone()).keySet().iterator();
                while (i2.hasNext()) {
                    AcknowledgementRequest item = (AcknowledgementRequest)i2.next();
                    try {
                        this.acknowledge(item, null);
                    }
                    catch (JMSException ignore) {}
                }
                i2 = this.messages.iterator();
                while (i2.hasNext()) {
                    MessageReference message = (MessageReference)i2.next();
                    i2.remove();
                    this.dropMessage(message);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        HashSet subs;
        Receivers receivers = this.receivers;
        synchronized (receivers) {
            this.stopped = true;
            subs = new HashSet(this.subscribers);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Stopping " + this + " with subscribers " + subs));
            }
            this.clearEvents();
        }
        Iterator i = subs.iterator();
        while (i.hasNext()) {
            Subscription sub = (Subscription)i.next();
            ClientConsumer consumer = (ClientConsumer)sub.clientConsumer;
            try {
                consumer.removeSubscription(sub.subscriptionId);
            }
            catch (Throwable t) {
                log.warn((Object)("Error during stop - removing subscriber " + sub), t);
            }
            this.nackMessages(sub);
        }
        MessageCache cache = this.server.getMessageCache();
        SortedSet sortedSet = this.messages;
        synchronized (sortedSet) {
            Iterator i2 = this.messages.iterator();
            while (i2.hasNext()) {
                MessageReference message = (MessageReference)i2.next();
                try {
                    cache.remove(message);
                }
                catch (JMSException ignored) {
                    log.trace((Object)"Ignored error removing message from cache", (Throwable)ignored);
                }
            }
        }
        this.messages.clear();
        this.unacknowledgedMessages.clear();
        this.unackedByMessageRef.clear();
        this.unackedBySubscription.clear();
        this.subscribers.clear();
        this.removedSubscribers.clear();
    }

    public void createMessageCounter(String name, String subscription, boolean topic, boolean durable, int daycountmax) {
        this.counter = new MessageCounter(name, subscription, this, topic, durable, daycountmax);
    }

    public MessageCounter getMessageCounter() {
        return this.counter;
    }

    public String toString() {
        return super.toString() + "{id=" + this.description + '}';
    }

    protected void clearEvents() {
        this.scheduledMessageCount.set(0);
        Iterator i = this.events.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            Timeout timeout = (Timeout)entry.getValue();
            timeout.cancel();
            i.remove();
        }
    }

    protected void clearEvent(MessageReference message) {
        Timeout timeout = (Timeout)this.events.remove((Object)message);
        if (timeout != null) {
            timeout.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToReceivers(Subscription sub) throws JMSException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("addReceiver  " + sub + " " + this));
        }
        Receivers receivers = this.receivers;
        synchronized (receivers) {
            if (this.stopped) {
                throw new IllegalStateException("The destination is stopped " + this.getDescription());
            }
            this.receivers.add(sub);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeReceiver(Subscription sub) {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("removeReceiver  " + sub + " " + this));
        }
        Receivers receivers = this.receivers;
        synchronized (receivers) {
            this.receivers.remove(sub);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalAddMessage(MessageReference message) {
        long ts;
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("internalAddMessage  " + message + " " + this));
        }
        if ((ts = message.messageScheduledDelivery) > 0L && ts > System.currentTimeMillis()) {
            EnqueueMessageTask t = new EnqueueMessageTask(message);
            Timeout timeout = TimeoutFactory.createTimeout((long)ts, (TimeoutTarget)t);
            this.events.put((Object)message, (Object)timeout);
            this.scheduledMessageCount.increment();
            if (trace) {
                log.trace((Object)("scheduled message at " + new Date(ts) + ": " + message));
            }
            return;
        }
        if (message.isExpired()) {
            if (trace) {
                log.trace((Object)("message expired: " + message));
            }
            this.dropMessage(message);
            return;
        }
        try {
            Subscription found = null;
            Receivers receivers = this.receivers;
            synchronized (receivers) {
                if (this.receivers.size() != 0) {
                    Iterator it = this.receivers.iterator();
                    while (it.hasNext()) {
                        Subscription sub = (Subscription)it.next();
                        if (!sub.accepts(message.getHeaders())) continue;
                        it.remove();
                        found = sub;
                        break;
                    }
                }
                if (found == null) {
                    SortedSet sortedSet = this.messages;
                    synchronized (sortedSet) {
                        this.messages.add(message);
                        if (message.messageExpiration > 0L) {
                            ExpireMessageTask t = new ExpireMessageTask(message);
                            Timeout timeout = TimeoutFactory.createTimeout((long)message.messageExpiration, (TimeoutTarget)t);
                            this.events.put((Object)message, (Object)timeout);
                        }
                    }
                }
            }
            if (found != null) {
                this.queueMessageForSending(found, message);
            }
        }
        catch (JMSException e) {
            log.error((Object)"Caught unusual exception in internalAddMessage.", (Throwable)e);
            this.dropMessage(message);
        }
    }

    protected void queueMessageForSending(Subscription sub, MessageReference message) {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("queueMessageForSending  " + sub + " " + message + " " + this));
        }
        try {
            this.setupMessageAcknowledgement(sub, message);
            RoutedMessage r = new RoutedMessage();
            r.message = message;
            r.subscriptionId = new Integer(sub.subscriptionId);
            ((ClientConsumer)sub.clientConsumer).queueMessageForSending(r);
        }
        catch (Throwable t) {
            log.warn((Object)"Caught unusual exception sending message to receiver.", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupMessageAcknowledgement(Subscription sub, MessageReference messageRef) throws JMSException {
        SpyMessage message = messageRef.getMessage();
        AcknowledgementRequest ack = new AcknowledgementRequest();
        ack.destination = message.getJMSDestination();
        ack.messageID = message.getJMSMessageID();
        ack.subscriberId = sub.subscriptionId;
        ack.isAck = false;
        SortedSet sortedSet = this.messages;
        synchronized (sortedSet) {
            UnackedMessageInfo unacked = new UnackedMessageInfo(messageRef, sub);
            this.unacknowledgedMessages.put(ack, unacked);
            this.unackedByMessageRef.put(messageRef, ack);
            HashMap<MessageReference, AcknowledgementRequest> map = (HashMap<MessageReference, AcknowledgementRequest>)this.unackedBySubscription.get(sub);
            if (map == null) {
                map = new HashMap<MessageReference, AcknowledgementRequest>();
                this.unackedBySubscription.put(sub, map);
            }
            map.put(messageRef, ack);
        }
    }

    protected void dropMessage(MessageReference message) {
        this.dropMessage(message, null);
    }

    protected void dropMessage(MessageReference message, Tx txid) {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("dropMessage " + this + " txid=" + txid));
        }
        this.clearEvent(message);
        try {
            if (message.isPersistent()) {
                try {
                    this.server.getPersistenceManager().remove(message, txid);
                }
                catch (JMSException e) {
                    try {
                        log.warn((Object)("Message removed from queue, but not from the persistent store: " + message.getMessage()), (Throwable)e);
                    }
                    catch (JMSException x) {
                        log.warn((Object)("Message removed from queue, but not from the persistent store: " + message), (Throwable)e);
                    }
                }
            }
            this.server.getMessageCache().remove(message);
        }
        catch (JMSException e) {
            log.warn((Object)("Error dropping message " + message), (Throwable)e);
        }
    }

    private void checkRemovedSubscribers(Subscription sub) {
        boolean trace = log.isTraceEnabled();
        if (this.removedSubscribers.contains(sub) && !this.hasUnackedMessages(sub)) {
            if (trace) {
                log.trace((Object)("Removing subscriber " + sub));
            }
            this.removedSubscribers.remove(sub);
            this.subscribers.remove(sub);
            ((ClientConsumer)sub.clientConsumer).removeRemovedSubscription(sub.subscriptionId);
        }
    }

    private boolean hasUnackedMessages(Subscription sub) {
        return this.unackedBySubscription.containsKey(sub);
    }

    private static class UnackedMessageInfo {
        public MessageReference messageRef;
        public Subscription sub;

        public UnackedMessageInfo(MessageReference messageRef, Subscription sub) {
            this.messageRef = messageRef;
            this.sub = sub;
        }
    }

    private class ExpireMessageTask
    implements TimeoutTarget {
        private MessageReference messageRef;

        public ExpireMessageTask(MessageReference messageRef) {
            this.messageRef = messageRef;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timedOut(Timeout timout) {
            BasicQueue.this.events.remove((Object)this.messageRef);
            SortedSet sortedSet = BasicQueue.this.messages;
            synchronized (sortedSet) {
                if (!BasicQueue.this.messages.remove(this.messageRef)) {
                    return;
                }
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("message expired: " + this.messageRef));
            }
            BasicQueue.this.dropMessage(this.messageRef);
        }
    }

    private class EnqueueMessageTask
    implements TimeoutTarget {
        private MessageReference messageRef;

        public EnqueueMessageTask(MessageReference messageRef) {
            this.messageRef = messageRef;
        }

        public void timedOut(Timeout timeout) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("scheduled message delivery: " + this.messageRef));
            }
            BasicQueue.this.events.remove((Object)this.messageRef);
            BasicQueue.this.internalAddMessage(this.messageRef);
            BasicQueue.this.scheduledMessageCount.decrement();
        }
    }

    class RemoveMessageTask
    implements Runnable {
        MessageReference message;

        RemoveMessageTask(MessageReference m) {
            this.message = m;
        }

        public void run() {
            try {
                BasicQueue.this.clearEvent(this.message);
                BasicQueue.this.server.getMessageCache().remove(this.message);
            }
            catch (JMSException e) {
                log.error((Object)"Could not remove an acknowleged message from the message cache: ", (Throwable)e);
            }
        }
    }

    class RestoreMessageTask
    implements Runnable {
        MessageReference message;

        RestoreMessageTask(MessageReference m) {
            this.message = m;
        }

        public void run() {
            BasicQueue.this.nackMessage(this.message);
        }
    }

    class AddMessagePostCommitTask
    implements Runnable {
        MessageReference message;

        AddMessagePostCommitTask(MessageReference m) {
            this.message = m;
        }

        public void run() {
            BasicQueue.this.internalAddMessage(this.message);
            if (BasicQueue.this.counter != null) {
                BasicQueue.this.counter.incrementCounter();
            }
        }
    }

    class AddMessagePostRollBackTask
    implements Runnable {
        MessageReference message;

        AddMessagePostRollBackTask(MessageReference m) {
            this.message = m;
        }

        public void run() {
            try {
                BasicQueue.this.server.getMessageCache().remove(this.message);
            }
            catch (JMSException e) {
                log.error((Object)"Could not remove message from the message cache after an add rollback: ", (Throwable)e);
            }
        }
    }
}

