/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.CaseStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.InnerEmulationDependency;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.util.Util;

public final class LocalTypeBinding
extends NestedTypeBinding {
    static final char[] LocalTypePrefix = new char[]{'$', 'L', 'o', 'c', 'a', 'l', '$'};
    private InnerEmulationDependency[] dependents;
    public ArrayBinding[] localArrayBindings;
    public CaseStatement switchCase;

    public LocalTypeBinding(ClassScope scope, SourceTypeBinding enclosingType, CaseStatement switchCase) {
        super((char[][])new char[][]{CharOperation.concat(LocalTypePrefix, scope.referenceContext.name)}, scope, enclosingType);
        this.tagBits = this.sourceName == TypeDeclaration.ANONYMOUS_EMPTY_NAME ? (this.tagBits |= 0x34) : (this.tagBits |= 0x14);
        this.switchCase = switchCase;
    }

    public void addInnerEmulationDependent(BlockScope dependentScope, boolean wasEnclosingInstanceSupplied) {
        int index;
        if (this.dependents == null) {
            index = 0;
            this.dependents = new InnerEmulationDependency[1];
        } else {
            index = this.dependents.length;
            int i = 0;
            while (i < index) {
                if (this.dependents[i].scope == dependentScope) {
                    return;
                }
                ++i;
            }
            this.dependents = new InnerEmulationDependency[index + 1];
            System.arraycopy(this.dependents, 0, this.dependents, 0, index);
        }
        this.dependents[index] = new InnerEmulationDependency(dependentScope, wasEnclosingInstanceSupplied);
    }

    public char[] constantPoolName() {
        return this.constantPoolName;
    }

    ArrayBinding createArrayType(int dimensionCount) {
        if (this.localArrayBindings == null) {
            this.localArrayBindings = new ArrayBinding[]{new ArrayBinding(this, dimensionCount)};
            return this.localArrayBindings[0];
        }
        int length = this.localArrayBindings.length;
        int i = 0;
        while (i < length) {
            if (this.localArrayBindings[i].dimensions == dimensionCount) {
                return this.localArrayBindings[i];
            }
            ++i;
        }
        this.localArrayBindings = new ArrayBinding[length + 1];
        System.arraycopy(this.localArrayBindings, 0, this.localArrayBindings, 0, length);
        this.localArrayBindings[length] = new ArrayBinding(this, dimensionCount);
        return this.localArrayBindings[length];
    }

    public char[] readableName() {
        if (this.isAnonymousType()) {
            if (this.superInterfaces == TypeConstants.NoSuperInterfaces) {
                return ("<" + Util.bind("binding.subclass", new String(this.superclass.readableName())) + ">").toCharArray();
            }
            return ("<" + Util.bind("binding.implementation", new String(this.superInterfaces[0].readableName())) + ">").toCharArray();
        }
        if (this.isMemberType()) {
            return CharOperation.concat(this.enclosingType().readableName(), this.sourceName, '.');
        }
        return this.sourceName;
    }

    public char[] shortReadableName() {
        if (this.isAnonymousType()) {
            if (this.superInterfaces == TypeConstants.NoSuperInterfaces) {
                return ("<" + Util.bind("binding.subclass", new String(this.superclass.shortReadableName())) + ">").toCharArray();
            }
            return ("<" + Util.bind("binding.implementation", new String(this.superInterfaces[0].shortReadableName())) + ">").toCharArray();
        }
        if (this.isMemberType()) {
            return CharOperation.concat(this.enclosingType().shortReadableName(), this.sourceName, '.');
        }
        return this.sourceName;
    }

    public void setAsMemberType() {
        this.tagBits |= 0xC;
    }

    public void setConstantPoolName(char[] computedConstantPoolName) {
        this.constantPoolName = computedConstantPoolName;
    }

    public char[] sourceName() {
        if (this.isAnonymousType()) {
            if (this.superInterfaces == TypeConstants.NoSuperInterfaces) {
                return ("<" + Util.bind("binding.subclass", new String(this.superclass.sourceName())) + ">").toCharArray();
            }
            return ("<" + Util.bind("binding.implementation", new String(this.superInterfaces[0].sourceName())) + ">").toCharArray();
        }
        return this.sourceName;
    }

    public String toString() {
        if (this.isAnonymousType()) {
            return "Anonymous type : " + super.toString();
        }
        if (this.isMemberType()) {
            return "Local member type : " + new String(this.sourceName()) + " " + super.toString();
        }
        return "Local type : " + new String(this.sourceName()) + " " + super.toString();
    }

    public void updateInnerEmulationDependents() {
        if (this.dependents != null) {
            int i = 0;
            while (i < this.dependents.length) {
                InnerEmulationDependency dependency = this.dependents[i];
                dependency.scope.propagateInnerEmulation(this, dependency.wasEnclosingInstanceSupplied);
                ++i;
            }
        }
    }
}

