/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import org.jboss.aop.AOPClassPool;
import org.jboss.aop.AspectManager;
import org.jboss.aop.instrument.ClassicInstrumentor;
import org.jboss.aop.instrument.DynamicTransformationObserver;
import org.jboss.aop.instrument.GeneratedAdvisorInstrumentor;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.JoinpointClassifier;

public class InstrumentorFactory {
    protected static final int CLASSIC = 1;
    protected static final int GENERATED_ADVISOR = 2;
    protected static int instrumentor = 0;

    public static void initialise(String property) {
        if (AspectManager.verbose) {
            System.out.println("[debug] Passed in instrumentor: " + property);
        }
        if (property != null) {
            if (property.equals(ClassicInstrumentor.class.getName())) {
                instrumentor = 1;
            } else if (property.equals(GeneratedAdvisorInstrumentor.class.getName())) {
                instrumentor = 2;
            }
        }
        if (property == null) {
            if (AspectManager.verbose) {
                System.out.println("[debug] Defaulting instrumentor to: " + ClassicInstrumentor.class.getName());
            }
            instrumentor = 1;
        }
    }

    public static Instrumentor getInstrumentor(AOPClassPool pool, AspectManager manager, JoinpointClassifier joinpointClassifier, DynamicTransformationObserver observer) {
        switch (instrumentor) {
            case 1: {
                return new ClassicInstrumentor(pool, manager, joinpointClassifier, observer);
            }
            case 2: {
                return new GeneratedAdvisorInstrumentor(pool, manager, joinpointClassifier, observer);
            }
        }
        throw new RuntimeException("Instrumentor is not set");
    }

    public static Instrumentor getInstrumentor(AspectManager manager, JoinpointClassifier joinpointClassifier) {
        switch (instrumentor) {
            case 1: {
                return new ClassicInstrumentor(manager, joinpointClassifier);
            }
            case 2: {
                return new GeneratedAdvisorInstrumentor(manager, joinpointClassifier);
            }
        }
        throw new RuntimeException("Instrumentor is not set");
    }
}

