/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.instrument.MethodExecutionTransformer;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.joinpoint.MethodJoinpoint;

public class PerVmAdvice {
    private static long counter = 0L;

    public static synchronized Interceptor generateOptimized(Joinpoint joinpoint, AspectManager manager, String adviceName, AspectDefinition a) throws Exception {
        Object aspect = manager.getPerVMAspect(a);
        return PerVmAdvice.generateInterceptor(joinpoint, aspect, adviceName);
    }

    public static Interceptor generateInterceptor(Joinpoint joinpoint, Object aspect, String adviceName) throws Exception {
        Method[] methods = aspect.getClass().getMethods();
        ArrayList<Method> matches = new ArrayList<Method>();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(adviceName)) continue;
            matches.add(methods[i]);
        }
        if (matches.size() == 1) {
            Method method = (Method)matches.get(0);
            if (joinpoint instanceof MethodJoinpoint && (method.getParameterTypes().length == 0 || method.getParameterTypes().length > 1 || !Invocation.class.isAssignableFrom(method.getParameterTypes()[0]))) {
                return PerVmAdvice.generateArgsInterceptor(aspect, method, joinpoint);
            }
        }
        ClassPool pool = AspectManager.instance().findClassPool(aspect.getClass().getClassLoader());
        CtClass clazz = pool.makeClass("org.jboss.aop.advice." + aspect.getClass().getName() + counter++);
        CtClass interceptorInterface = pool.get("org.jboss.aop.advice.Interceptor");
        CtClass abstractAdviceClass = pool.get("org.jboss.aop.advice.AbstractAdvice");
        clazz.setSuperclass(abstractAdviceClass);
        CtClass aspectClass = pool.get(aspect.getClass().getName());
        CtField field = new CtField(aspectClass, "aspectField", clazz);
        field.setModifiers(1);
        clazz.addField(field);
        CtMethod getNameTemplate = interceptorInterface.getDeclaredMethod("getName");
        CtMethod getName = CtNewMethod.make((CtClass)getNameTemplate.getReturnType(), (String)"getName", (CtClass[])getNameTemplate.getParameterTypes(), (CtClass[])getNameTemplate.getExceptionTypes(), null, (CtClass)clazz);
        String getNameBody = "{    return \"" + aspect.getClass().getName() + "." + adviceName + "\"; " + "}";
        getName.setBody(getNameBody);
        getName.setModifiers(1);
        clazz.addMethod(getName);
        String invokeBody = "public Object invoke(org.jboss.aop.joinpoint.Invocation invocation) throws java.lang.Throwable {  ";
        if (matches.size() > 1) {
            for (int i = 0; i < matches.size(); ++i) {
                Method advice = (Method)matches.get(i);
                String param = advice.getParameterTypes()[0].getName();
                invokeBody = invokeBody + "   if (invocation instanceof " + param + ") return aspectField." + adviceName + "((" + param + ")invocation); ";
            }
            invokeBody = invokeBody + "   return (org.jboss.aop.joinpoint.Invocation)null; ";
        } else {
            Method advice = (Method)matches.get(0);
            String param = advice.getParameterTypes()[0].getName();
            invokeBody = invokeBody + "return aspectField." + adviceName + "((" + param + ")invocation); ";
        }
        invokeBody = invokeBody + "}";
        CtMethod invoke = CtNewMethod.make((String)invokeBody, (CtClass)clazz);
        invoke.setModifiers(1);
        clazz.addMethod(invoke);
        Class iclass = clazz.toClass();
        Interceptor rtn = (Interceptor)iclass.newInstance();
        Field f = iclass.getField("aspectField");
        f.set(rtn, aspect);
        return rtn;
    }

    public static Interceptor generateArgsInterceptor(Object aspect, Method advice, Joinpoint joinpoint) throws Exception {
        Method method = ((MethodJoinpoint)joinpoint).getMethod();
        String optimized = MethodExecutionTransformer.getOptimizedInvocationClassName(method);
        ClassPool pool = AspectManager.instance().findClassPool(aspect.getClass().getClassLoader());
        CtClass clazz = pool.makeClass("org.jboss.aop.advice." + aspect.getClass().getName() + counter++);
        CtClass interceptorInterface = pool.get("org.jboss.aop.advice.Interceptor");
        clazz.addInterface(interceptorInterface);
        CtClass aspectClass = pool.get(aspect.getClass().getName());
        CtField field = new CtField(aspectClass, "aspectField", clazz);
        field.setModifiers(1);
        clazz.addField(field);
        CtMethod getNameTemplate = interceptorInterface.getDeclaredMethod("getName");
        CtMethod getName = CtNewMethod.make((CtClass)getNameTemplate.getReturnType(), (String)"getName", (CtClass[])getNameTemplate.getParameterTypes(), (CtClass[])getNameTemplate.getExceptionTypes(), null, (CtClass)clazz);
        String getNameBody = "{    return \"" + aspect.getClass().getName() + "." + advice.getName() + "\"; " + "}";
        getName.setBody(getNameBody);
        getName.setModifiers(1);
        clazz.addMethod(getName);
        String invokeBody = null;
        invokeBody = Invocation.class.isAssignableFrom(advice.getParameterTypes()[0]) ? PerVmAdvice.getInvocationBody(optimized, advice, method) : PerVmAdvice.getThreadStackBody(optimized, advice, method);
        CtMethod invoke = CtNewMethod.make((String)invokeBody, (CtClass)clazz);
        invoke.setModifiers(1);
        clazz.addMethod(invoke);
        Class iclass = clazz.toClass();
        Interceptor rtn = (Interceptor)iclass.newInstance();
        Field f = iclass.getField("aspectField");
        f.set(rtn, aspect);
        return rtn;
    }

    private static String getThreadStackBody(String optimized, Method advice, Method method) {
        String invokeBody = "public Object invoke(org.jboss.aop.joinpoint.Invocation invocation) throws java.lang.Throwable {     " + optimized + " optimized = (" + optimized + ")invocation; " + "   org.jboss.aop.joinpoint.CurrentInvocation.push(invocation); " + "   try {";
        invokeBody = invokeBody + "return ($w)aspectField." + advice.getName() + "(";
        Class<?>[] adviceParams = advice.getParameterTypes();
        Class<?>[] params = method.getParameterTypes();
        boolean first = true;
        if (adviceParams.length > 0) {
            int adviceParam = 0;
            for (int i = 0; i < params.length && adviceParam < adviceParams.length; ++i) {
                if (!adviceParams[adviceParam].equals(params[i])) continue;
                ++adviceParam;
                if (first) {
                    first = false;
                } else {
                    invokeBody = invokeBody + ", ";
                }
                invokeBody = invokeBody + "optimized.arg" + i;
            }
        }
        invokeBody = invokeBody + "); ";
        invokeBody = invokeBody + "   } finally { org.jboss.aop.joinpoint.CurrentInvocation.pop(); }";
        invokeBody = invokeBody + "}";
        return invokeBody;
    }

    private static String getInvocationBody(String optimized, Method advice, Method method) {
        String invokeBody = "public Object invoke(org.jboss.aop.joinpoint.Invocation invocation) throws java.lang.Throwable {     " + optimized + " optimized = (" + optimized + ")invocation; " + "   return ($w)aspectField." + advice.getName() + "(optimized";
        Class<?>[] adviceParams = advice.getParameterTypes();
        Class<?>[] params = method.getParameterTypes();
        if (adviceParams.length > 0) {
            int adviceParam = 1;
            for (int i = 0; i < params.length && adviceParam < adviceParams.length; ++i) {
                if (!adviceParams[adviceParam].equals(params[i])) continue;
                ++adviceParam;
                invokeBody = invokeBody + ", ";
                invokeBody = invokeBody + "optimized.arg" + i;
            }
        }
        invokeBody = invokeBody + "); ";
        invokeBody = invokeBody + "}";
        return invokeBody;
    }
}

