/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.types;

import java.math.BigInteger;
import java.util.Random;
import org.jboss.axis.types.NonNegativeInteger;
import org.jboss.axis.utils.Messages;

public class PositiveInteger
extends NonNegativeInteger {
    private BigInteger iMinInclusive = new BigInteger("1");

    public PositiveInteger(byte[] val) {
        super(val);
        this.checkValidity();
    }

    public PositiveInteger(int signum, byte[] magnitude) {
        super(signum, magnitude);
        this.checkValidity();
    }

    public PositiveInteger(int bitLength, int certainty, Random rnd) {
        super(bitLength, certainty, rnd);
        this.checkValidity();
    }

    public PositiveInteger(int numBits, Random rnd) {
        super(numBits, rnd);
        this.checkValidity();
    }

    public PositiveInteger(String val) {
        super(val);
        this.checkValidity();
    }

    public PositiveInteger(String val, int radix) {
        super(val, radix);
        this.checkValidity();
    }

    private void checkValidity() {
        if (this.compareTo(this.iMinInclusive) < 0) {
            throw new NumberFormatException(Messages.getMessage("badposInt00") + ":  " + this);
        }
    }
}

