/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.collectiverun.composite.action;

import com.clustercontrol.collectiverun.action.ModifyMaster;
import com.clustercontrol.collectiverun.bean.ItemInfo;
import com.clustercontrol.collectiverun.bean.TreeItem;
import com.clustercontrol.collectiverun.composite.TreeComposite;
import com.clustercontrol.collectiverun.composite.action.BaseTreeItemSelectionListener;
import com.clustercontrol.collectiverun.util.TreeItemUtil;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;

public class UpDownTreeItemSelectionListener
extends BaseTreeItemSelectionListener {
    protected boolean up;

    public UpDownTreeItemSelectionListener(TreeComposite composite, boolean up) {
        super(composite);
        this.up = up;
    }

    public void widgetSelected(SelectionEvent e) {
        if (!this.checkCreateItem()) {
            return;
        }
        if (!this.checkUpdateItem()) {
            return;
        }
        TreeItem item = this.composite.getSelectItem();
        TreeItem parent = item.getParent();
        if (!(item instanceof TreeItem) || !(parent instanceof TreeItem)) {
            return;
        }
        TreeItem target = null;
        target = this.up ? TreeItemUtil.getUpDownTargetItem((TreeItem)item, (Boolean)true) : TreeItemUtil.getUpDownTargetItem((TreeItem)item, (Boolean)false);
        if (!(target instanceof TreeItem)) {
            return;
        }
        ItemInfo info = item.getInfo();
        ItemInfo parentInfo = parent.getInfo();
        ModifyMaster modify = new ModifyMaster();
        ItemInfo targetInfo = target.getInfo();
        if (!modify.changeOrder(info, targetInfo, parentInfo)) {
            Object[] args = new Object[]{info.getName(), targetInfo.getName()};
            MessageDialog.openError(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.collective.run.15", (Object[])args));
            return;
        }
        int orderNo = info.getOrderNo();
        info.setOrderNo(targetInfo.getOrderNo());
        targetInfo.setOrderNo(orderNo);
        this.composite.setCreateItem(null);
        this.composite.setUpdateItem(null);
        this.composite.getTreeViewer().refresh((Object)parent);
        this.composite.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)item), true);
    }
}

