/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.hinemosagent.factory;

import com.clustercontrol.hinemosagent.ejb.entity.MonitorAgentInfoLocal;
import com.clustercontrol.hinemosagent.ejb.entity.MonitorAgentInfoPK;
import com.clustercontrol.hinemosagent.ejb.entity.MonitorAgentInfoUtil;
import com.clustercontrol.monitor.run.bean.MonitorJudgementInfo;
import com.clustercontrol.monitor.run.factory.RunMonitorTruthValueType;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.apllog.AplLogger;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;
import org.jboss.mq.Subscription;
import org.jboss.mq.selectors.Selector;

public class RunMonitorAgent
extends RunMonitorTruthValueType {
    protected static Log m_log = LogFactory.getLog(RunMonitorAgent.class);
    public static final String LOOKUP_NAME = "jmx/invoker/RMIAdaptor";
    public static final String JOB_AGENT_OBJECT_NAME = "jboss.mq.destination:name=clustercontrol/JobManagement/execute,service=Topic";
    public static final String LOG_AGENT_OBJECT_NAME = "jboss.mq.destination:name=clustercontrol/Logtransfer/update,service=Topic";
    public static final String OPERATION_NAME = "listAllSubscriptions";
    public static final String MESSAGE_ID_INFO = "001";
    public static final String MESSAGE_ID_WARNING = "002";
    public static final String MESSAGE_ID_CRITICAL = "003";
    public static final String MESSAGE_ID_UNKNOWN = "004";
    protected MonitorAgentInfoLocal m_agent = null;
    protected int m_checkJobAgent = 1;
    protected int m_checkLogAgent = 1;
    protected String m_message = null;
    protected String m_messageJobAgent = "";
    protected boolean m_valueJobAgent = false;
    protected String m_messageLogAgent = "";
    protected boolean m_valueLogAgent = false;

    public boolean collect(String facilityId) {
        boolean result = false;
        boolean resultJobAgent = false;
        boolean resultLogAgent = false;
        this.m_value = false;
        this.m_nodeDate = this.m_now.getTime();
        if (this.m_checkJobAgent == 1) {
            resultJobAgent = this.checkJobAgent(facilityId);
        }
        if (this.m_checkLogAgent == 1) {
            resultLogAgent = this.checkLogAgent(facilityId);
        }
        if (resultJobAgent || resultLogAgent) {
            result = true;
        }
        if (this.m_checkJobAgent == 1 && this.m_checkLogAgent == 1) {
            if (this.m_valueJobAgent && this.m_valueLogAgent) {
                this.m_value = true;
            }
            this.m_message = this.m_messageJobAgent + "\n" + this.m_messageLogAgent;
        } else if (this.m_checkJobAgent == 1) {
            this.m_value = this.m_valueJobAgent;
            this.m_message = this.m_messageJobAgent;
        } else if (this.m_checkLogAgent == 1) {
            this.m_value = this.m_valueLogAgent;
            this.m_message = this.m_messageLogAgent;
        }
        return result;
    }

    public boolean checkJobAgent(String facilityId) {
        boolean result = false;
        boolean duplication = false;
        this.m_valueJobAgent = false;
        this.m_messageJobAgent = "";
        try {
            InitialContext ic = new InitialContext();
            RMIAdaptor server = (RMIAdaptor)ic.lookup(LOOKUP_NAME);
            ObjectName name = new ObjectName(JOB_AGENT_OBJECT_NAME);
            Object returnObject = server.invoke(name, OPERATION_NAME, null, null);
            if (returnObject instanceof List) {
                String checkString = "FacilityId='" + facilityId + "'";
                HashMap<String, String> map = new HashMap<String, String>();
                for (int i = 0; i < ((List)returnObject).size(); ++i) {
                    Subscription subscription = (Subscription)((List)returnObject).get(i);
                    try {
                        Selector selecter = subscription.getSelector();
                        if (selecter == null || selecter.selector.indexOf(checkString) == -1) continue;
                        if (map.get(facilityId) == null) {
                            this.m_valueJobAgent = true;
                            map.put(facilityId, facilityId);
                            continue;
                        }
                        this.m_valueJobAgent = false;
                        duplication = true;
                        AplLogger apllog = new AplLogger("AGT", "agt");
                        Object[] args = new String[]{facilityId};
                        apllog.put("SYS", MESSAGE_ID_INFO, args);
                        break;
                    }
                    catch (InvalidSelectorException e) {
                        m_log.debug((Object)("collect() : " + e.getMessage()));
                    }
                }
                if (!duplication) {
                    this.m_messageJobAgent = this.m_valueJobAgent ? Messages.getString((String)"message.agent.1") : Messages.getString((String)"message.agent.2");
                } else {
                    Object[] args = new String[]{facilityId};
                    this.m_messageJobAgent = Messages.getString((String)"message.agent.3", (Object[])args);
                }
                result = true;
            } else {
                this.m_messageJobAgent = Messages.getString((String)"message.agent.4");
            }
        }
        catch (NamingException e) {
            m_log.debug((Object)("collect() : " + e.getMessage()));
            this.m_messageJobAgent = Messages.getString((String)"message.agent.4") + " (" + e.getMessage() + ")";
        }
        catch (MalformedObjectNameException e) {
            m_log.debug((Object)("collect() : " + e.getMessage()));
            this.m_messageJobAgent = Messages.getString((String)"message.agent.4") + " (" + e.getMessage() + ")";
        }
        catch (NullPointerException e) {
            m_log.debug((Object)("collect() : " + e.getMessage()));
            this.m_messageJobAgent = Messages.getString((String)"message.agent.4") + " (" + e.getMessage() + ")";
        }
        catch (InstanceNotFoundException e) {
            m_log.debug((Object)("collect() : " + e.getMessage()));
            this.m_messageJobAgent = Messages.getString((String)"message.agent.4") + " (" + e.getMessage() + ")";
        }
        catch (MBeanException e) {
            m_log.debug((Object)("collect() : " + e.getMessage()));
            this.m_messageJobAgent = Messages.getString((String)"message.agent.4") + " (" + e.getMessage() + ")";
        }
        catch (ReflectionException e) {
            m_log.debug((Object)("collect() : " + e.getMessage()));
            this.m_messageJobAgent = Messages.getString((String)"message.agent.4") + " (" + e.getMessage() + ")";
        }
        catch (IOException e) {
            m_log.debug((Object)("collect() : " + e.getMessage()));
            this.m_messageJobAgent = Messages.getString((String)"message.agent.4") + " (" + e.getMessage() + ")";
        }
        return result;
    }

    public boolean checkLogAgent(String facilityId) {
        boolean result = false;
        boolean duplication = false;
        this.m_valueLogAgent = false;
        this.m_messageLogAgent = "";
        try {
            InitialContext ic = new InitialContext();
            RMIAdaptor server = (RMIAdaptor)ic.lookup(LOOKUP_NAME);
            ObjectName name = new ObjectName(LOG_AGENT_OBJECT_NAME);
            Object returnObject = server.invoke(name, OPERATION_NAME, null, null);
            if (returnObject instanceof List) {
                String checkString = "FacilityId='" + facilityId + "'";
                HashMap<String, String> map = new HashMap<String, String>();
                for (int i = 0; i < ((List)returnObject).size(); ++i) {
                    Subscription subscription = (Subscription)((List)returnObject).get(i);
                    try {
                        Selector selecter = subscription.getSelector();
                        if (selecter == null || selecter.selector.indexOf(checkString) == -1) continue;
                        if (map.get(facilityId) == null) {
                            this.m_valueLogAgent = true;
                            map.put(facilityId, facilityId);
                            continue;
                        }
                        this.m_valueLogAgent = false;
                        duplication = true;
                        AplLogger apllog = new AplLogger("AGT", "agt");
                        Object[] args = new String[]{facilityId};
                        apllog.put("SYS", MESSAGE_ID_WARNING, args);
                        break;
                    }
                    catch (InvalidSelectorException e) {
                        m_log.debug((Object)("collect() : " + e.getMessage()));
                    }
                }
                if (!duplication) {
                    this.m_messageLogAgent = this.m_valueLogAgent ? Messages.getString((String)"message.agent.5") : Messages.getString((String)"message.agent.6");
                } else {
                    Object[] args = new String[]{facilityId};
                    this.m_messageLogAgent = Messages.getString((String)"message.agent.7", (Object[])args);
                }
                result = true;
            } else {
                this.m_messageLogAgent = Messages.getString((String)"message.agent.4");
            }
        }
        catch (NamingException e) {
            m_log.debug((Object)("collect() : " + e.getMessage()));
            this.m_messageLogAgent = Messages.getString((String)"message.agent.4") + " (" + e.getMessage() + ")";
        }
        catch (MalformedObjectNameException e) {
            m_log.debug((Object)("collect() : " + e.getMessage()));
            this.m_messageLogAgent = Messages.getString((String)"message.agent.4") + " (" + e.getMessage() + ")";
        }
        catch (NullPointerException e) {
            m_log.debug((Object)("collect() : " + e.getMessage()));
            this.m_messageLogAgent = Messages.getString((String)"message.agent.4") + " (" + e.getMessage() + ")";
        }
        catch (InstanceNotFoundException e) {
            m_log.debug((Object)("collect() : " + e.getMessage()));
            this.m_messageLogAgent = Messages.getString((String)"message.agent.4") + " (" + e.getMessage() + ")";
        }
        catch (MBeanException e) {
            m_log.debug((Object)("collect() : " + e.getMessage()));
            this.m_messageLogAgent = Messages.getString((String)"message.agent.4") + " (" + e.getMessage() + ")";
        }
        catch (ReflectionException e) {
            m_log.debug((Object)("collect() : " + e.getMessage()));
            this.m_messageLogAgent = Messages.getString((String)"message.agent.4") + " (" + e.getMessage() + ")";
        }
        catch (IOException e) {
            m_log.debug((Object)("collect() : " + e.getMessage()));
            this.m_messageLogAgent = Messages.getString((String)"message.agent.4") + " (" + e.getMessage() + ")";
        }
        return result;
    }

    public void setCheckInfo() throws FinderException, NamingException {
        MonitorAgentInfoPK pk = new MonitorAgentInfoPK(this.m_monitorId, this.m_monitorTypeId);
        this.m_agent = MonitorAgentInfoUtil.getLocalHome().findByPrimaryKey(pk);
        if (this.m_agent.getCheckJobAgent() != null) {
            this.m_checkJobAgent = this.m_agent.getCheckJobAgent();
        }
        if (this.m_agent.getCheckLogAgent() != null) {
            this.m_checkLogAgent = this.m_agent.getCheckLogAgent();
        }
    }

    public String getMessageId(int id) {
        MonitorJudgementInfo info = (MonitorJudgementInfo)this.m_judgementInfoList.get(id);
        if (info != null) {
            int priority = info.getPriority();
            if (priority == 3) {
                return MESSAGE_ID_INFO;
            }
            if (priority == 2) {
                return MESSAGE_ID_WARNING;
            }
            if (priority == 0) {
                return MESSAGE_ID_CRITICAL;
            }
        }
        return MESSAGE_ID_UNKNOWN;
    }

    public String getMessage(int id) {
        return this.m_message;
    }

    public String getMessageOrg(int id) {
        return null;
    }

    public String getMessageIdForScope(int priority) {
        if (priority == 3) {
            return MESSAGE_ID_INFO;
        }
        if (priority == 2) {
            return MESSAGE_ID_WARNING;
        }
        if (priority == 0) {
            return MESSAGE_ID_CRITICAL;
        }
        return MESSAGE_ID_UNKNOWN;
    }
}

