/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.factory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.notify.bean.NotifyEventInfo;
import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.notify.bean.NotifyInfoContext;
import com.clustercontrol.notify.ejb.entity.NotifyEventInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyEventInfoUtil;
import com.clustercontrol.notify.ejb.entity.NotifyInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyInfoUtil;
import com.clustercontrol.notify.factory.DeleteNotify;
import com.clustercontrol.notify.util.SendQueue;
import com.clustercontrol.util.apllog.AplLogger;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ModifyNotify {
    protected static Log m_log = LogFactory.getLog(ModifyNotify.class);

    public boolean modify(NotifyInfo info) throws CreateException, FinderException, RemoveException, NamingException, JMSException {
        AccessLock.lock((String)"NOTIFY");
        SendQueue queue = null;
        try {
            NotifyInfoLocal notify = NotifyInfoUtil.getLocalHome().findByPrimaryKey(info.getNotifyId());
            if (notify != null) {
                notify.setDescription(info.getDescription());
                notify.setStatusFlg(info.getStatusFlg());
                notify.setStatusValidPeriod(info.getStatusValidPeriod());
                notify.setStatusInvalidFlg(info.getStatusInvalidFlg());
                notify.setStatusUpdatePriority(info.getStatusUpdatePriority());
                notify.setEventFlg(info.getEventFlg());
                notify.setInhibitionFlg(info.getInhibitionFlg());
                notify.setInhibitionFrequency(info.getInhibitionFrequency());
                notify.setInhibitionPeriod(info.getInhibitionPeriod());
                notify.setUpdateDate(new Timestamp(new Date().getTime()));
            }
            Collection ct = notify.getNotifyEventInfo();
            DeleteNotify delete = new DeleteNotify();
            delete.deleteEvents(ct);
            ArrayList eventList = info.getNotifyEventInfo();
            ArrayList<NotifyEventInfoLocal> eventLocalList = new ArrayList<NotifyEventInfoLocal>();
            NotifyEventInfo event = null;
            for (int index = 0; index < eventList.size(); ++index) {
                event = (NotifyEventInfo)eventList.get(index);
                if (event == null) continue;
                NotifyEventInfoLocal local = NotifyEventInfoUtil.getLocalHome().create(info.getNotifyId(), event.getPriority(), event.getEventNormalFlg(), event.getEventNormalState(), event.getEventInhibitionFlg(), event.getEventInhibitionState(), event.getMailFlg(), event.getMailAddress());
                eventLocalList.add(local);
            }
            if (eventLocalList != null) {
                ct.addAll(eventLocalList);
                notify.setNotifyEventInfo(ct);
            }
            NotifyInfoContext context = new NotifyInfoContext(1, info.getNotifyId(), info);
            queue = new SendQueue("queue/clustercontrol/Moniter/EventLog");
            queue.put((Serializable)context);
            queue.terminate();
        }
        catch (CreateException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            Object[] args = new String[]{info.getNotifyId()};
            apllog.put("SYS", "002", args);
            m_log.debug((Object)("modify():" + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            Object[] args = new String[]{info.getNotifyId()};
            apllog.put("SYS", "002", args);
            m_log.debug((Object)("modify():" + e.getMessage()));
            throw e;
        }
        catch (RemoveException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            Object[] args = new String[]{info.getNotifyId()};
            apllog.put("SYS", "002", args);
            m_log.debug((Object)("modify():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            Object[] args = new String[]{info.getNotifyId()};
            apllog.put("SYS", "002", args);
            m_log.debug((Object)("modify():" + e.getMessage()));
            throw e;
        }
        catch (JMSException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            Object[] args = new String[]{info.getNotifyId()};
            apllog.put("SYS", "002", args);
            m_log.debug((Object)("modify():" + e.getMessage()));
            throw e;
        }
        finally {
            if (queue != null) {
                queue.terminate();
            }
        }
        return true;
    }
}

