/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.ejb.session;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.notify.factory.AddNotify;
import com.clustercontrol.notify.factory.DeleteNotify;
import com.clustercontrol.notify.factory.ModifyNotify;
import com.clustercontrol.notify.factory.SelectNotify;
import com.clustercontrol.util.Messages;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.jms.JMSException;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NotifyControllerBean
implements SessionBean {
    private SessionContext m_context;

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
        this.m_context = ctx;
    }

    public boolean addNotify(NotifyInfo info) throws CreateException, NamingException, JMSException {
        AddNotify notify = new AddNotify();
        return notify.add(info);
    }

    public boolean modifyNotify(NotifyInfo info) throws CreateException, FinderException, RemoveException, NamingException, JMSException {
        ModifyNotify notify = new ModifyNotify();
        return notify.modify(info);
    }

    public boolean deleteNotify(String notifyId) throws FinderException, RemoveException, NamingException, JMSException {
        DeleteNotify notify = new DeleteNotify();
        return notify.delete(notifyId);
    }

    public NotifyInfo getNotify(String notifyId) throws FinderException, NamingException {
        SelectNotify notify = new SelectNotify();
        NotifyInfo info = notify.getNotify(notifyId);
        return info;
    }

    public ArrayList getNotifyIdList() throws CreateException, FinderException, NamingException {
        SelectNotify notify = new SelectNotify();
        ArrayList list = notify.getNotifyIdList();
        return list;
    }

    public ArrayList getNotifyList() throws CreateException, FinderException, NamingException {
        SelectNotify notify = new SelectNotify();
        ArrayList list = notify.getNotifyList();
        return list;
    }

    public HashMap<String, NotifyInfo> getNotifyMap() throws FinderException, NamingException {
        SelectNotify notify = new SelectNotify();
        HashMap<String, NotifyInfo> map = notify.getNotifyMap();
        return map;
    }

    public ArrayList getNotifyListTableDefine(Locale local) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo(Messages.getString((String)"notify.id", (Locale)local), -1, 80, 16384));
        tableDefine.add(1, new TableColumnInfo(Messages.getString((String)"description", (Locale)local), -1, 300, 16384));
        tableDefine.add(2, new TableColumnInfo(Messages.getString((String)"status.katakana", (Locale)local), 15, 60, 16384));
        tableDefine.add(3, new TableColumnInfo(Messages.getString((String)"event.katakana", (Locale)local), 15, 60, 16384));
        tableDefine.add(4, new TableColumnInfo(Messages.getString((String)"update.time", (Locale)local), -1, 150, 16384));
        return tableDefine;
    }
}

