/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.factory;

import com.clustercontrol.monitor.ejb.entity.StatusInfoLocal;
import com.clustercontrol.monitor.ejb.entity.StatusInfoPK;
import com.clustercontrol.monitor.ejb.entity.StatusInfoUtil;
import com.clustercontrol.monitor.message.LogOutputInfo;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OutputStatusInfo {
    protected static Log m_log = LogFactory.getLog(OutputStatusInfo.class);

    public boolean outputStatusInfo(LogOutputInfo logOutput, Timestamp outputDate) {
        boolean result = false;
        if (logOutput.isStatusInfoFlg()) {
            StatusInfoLocal statusInfo = null;
            boolean insertFlg = false;
            try {
                StatusInfoPK pk = new StatusInfoPK(logOutput.getMonitorId(), logOutput.getPluginId(), logOutput.getFacilityId());
                statusInfo = StatusInfoUtil.getLocalHome().findByPrimaryKey(pk);
            }
            catch (NamingException e) {
                m_log.error((Object)("outputStatusInfo():" + e.getMessage()));
            }
            catch (FinderException e) {
                insertFlg = true;
            }
            try {
                if (insertFlg) {
                    this.insertStatusInfo(logOutput, outputDate);
                    result = true;
                } else {
                    this.updateStatusInfo(statusInfo, logOutput, outputDate);
                    result = true;
                }
            }
            catch (NamingException e) {
                m_log.error((Object)("outputStatusInfo():" + e.getMessage()));
            }
            catch (CreateException e) {
                m_log.error((Object)("outputStatusInfo():" + e.getMessage()));
            }
            catch (EJBException e) {
                m_log.error((Object)("outputStatusInfo():" + e.getMessage()));
            }
        }
        return result;
    }

    public void insertStatusInfo(LogOutputInfo logOutput, Timestamp outputDate) throws NamingException, CreateException {
        try {
            Integer expirationFlg = this.getExpirationFlg(logOutput);
            Timestamp expirationDate = null;
            if (expirationFlg != null) {
                expirationDate = this.getExpirationDate(logOutput, outputDate);
            }
            StatusInfoLocal statusInfo = StatusInfoUtil.getLocalHome().create(logOutput.getFacilityId(), logOutput.getMonitorId(), logOutput.getPluginId(), logOutput.getApplication(), logOutput.getMessageId(), logOutput.getMessage(), new Integer(logOutput.getPriority()), new Timestamp(logOutput.getGenerationDate().getTime()), outputDate, expirationFlg, expirationDate);
        }
        catch (NamingException e) {
            throw e;
        }
        catch (CreateException e) {
            throw e;
        }
    }

    public void updateStatusInfo(StatusInfoLocal statusInfo, LogOutputInfo logOutput, Timestamp outputDate) throws EJBException {
        if (statusInfo != null) {
            Integer expirationFlg = this.getExpirationFlg(logOutput);
            Timestamp expirationDate = null;
            if (expirationFlg != null) {
                expirationDate = this.getExpirationDate(logOutput, outputDate);
            }
            statusInfo.setApplication(logOutput.getApplication());
            statusInfo.setMessageId(logOutput.getMessageId());
            statusInfo.setMessage(logOutput.getMessage());
            statusInfo.setPriority(new Integer(logOutput.getPriority()));
            statusInfo.setOutputDate(outputDate);
            statusInfo.setExpirationFlg(expirationFlg);
            statusInfo.setExpirationDate(expirationDate);
        }
    }

    private Integer getExpirationFlg(LogOutputInfo logOutput) {
        Integer expirationFlg = null;
        if (logOutput != null) {
            if (11 == logOutput.getStatusInvalidFlg()) {
                expirationFlg = new Integer(logOutput.getStatusInvalidFlg());
            }
            if (12 == logOutput.getStatusInvalidFlg()) {
                expirationFlg = new Integer(logOutput.getStatusUpdatePriority());
            }
        }
        return expirationFlg;
    }

    private Timestamp getExpirationDate(LogOutputInfo logOutput, Timestamp outputDate) {
        Timestamp expirationDate = null;
        if (logOutput != null && logOutput.getStatusValidPeriod() > 0) {
            Calendar cal = null;
            cal = Calendar.getInstance();
            cal.setTime(outputDate);
            cal.add(12, logOutput.getStatusValidPeriod());
            expirationDate = new Timestamp(cal.getTimeInMillis());
        }
        return expirationDate;
    }
}

