/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.composite;

import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.performance.action.RecordController;
import java.util.ArrayList;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class CollectionListComposite
extends Composite {
    private CommonTableViewer tableViewer = null;

    public CollectionListComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(5, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Table table = new Table((Composite)this, 66308);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 5;
        table.setLayoutData((Object)gridData);
        RecordController collector = RecordController.getInstance();
        ArrayList list = collector.getCollectionListTableDefine();
        this.tableViewer = new CommonTableViewer(table);
        this.tableViewer.createTableColumn(list, 5, -1);
    }

    public CommonTableViewer getTableViewer() {
        return this.tableViewer;
    }

    public void update() {
        super.update();
        RecordController collector = RecordController.getInstance();
        if (collector != null) {
            this.tableViewer.setInput((Object)collector.getCollectionList());
        }
    }

    public String getSelectedID() {
        Table table = this.tableViewer.getTable();
        int selectionIndex = table.getSelectionIndex();
        if (selectionIndex < 0) {
            return null;
        }
        return table.getItem(selectionIndex).getText(2);
    }

    public int getRunStatus() {
        Table table = this.tableViewer.getTable();
        String statusStr = table.getItem(table.getSelectionIndex()).getText(0);
        return StatusConstant.stringToType((String)statusStr);
    }
}

