/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.action;

import com.clustercontrol.bean.FacilityInfo;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.performance.action.RecordController;
import com.clustercontrol.performance.bean.GraphDisplayRange;
import com.clustercontrol.performance.composite.RecordGraphComposite;
import com.clustercontrol.performance.util.CollectorItemCodeFactory;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.performanceMGR.bean.CollectedDataInfo;
import com.clustercontrol.performanceMGR.bean.CollectedDataSet;
import com.clustercontrol.performanceMGR.bean.CollectorItemInfo;
import com.clustercontrol.performanceMGR.ejb.bmp.RecordCollectorData;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Shell;

public class DrawRecordGraphAction
extends SelectionAdapter {
    RecordGraphComposite m_composite;
    private int m_graphType;
    private RecordCollectorData m_collectorData;
    private List m_itemInfoList;
    private CollectorItemInfo m_currentItem;
    private FacilityTreeItem m_facilityTree;
    private ArrayList m_gotTimeArea;

    public DrawRecordGraphAction() {
        this.m_gotTimeArea = new ArrayList();
    }

    public DrawRecordGraphAction(RecordCollectorData collectorData, List itemInfoList) {
        this.m_collectorData = collectorData;
        this.m_itemInfoList = itemInfoList;
    }

    public void setComposite(RecordGraphComposite composite) {
        this.m_composite = composite;
    }

    public void setData(RecordCollectorData collectorData, List itemInfoList, FacilityTreeItem facilityTree) {
        this.m_collectorData = collectorData;
        this.m_itemInfoList = itemInfoList;
        this.m_facilityTree = facilityTree;
    }

    public void drawGraph(FacilityTreeItem facilityTree, int itemID, int graphType) {
        this.setTargetFacility(facilityTree);
        this.setTargetItemID(itemID);
        this.m_graphType = graphType;
        this.createGraph();
        double lowerBound = (double)this.m_composite.getHorizontalBar().getSelection() * 1000.0;
        double upperBound = (double)(this.m_composite.getHorizontalBar().getThumb() + this.m_composite.getHorizontalBar().getSelection()) * 1000.0;
        this.drawGraph((long)lowerBound, (long)upperBound);
    }

    private void drawGraph(long lowerBound, long upperBound) {
        long endTime;
        if (this.m_collectorData == null || this.m_itemInfoList == null || this.m_currentItem == null || this.m_facilityTree == null) {
            return;
        }
        long startTime = this.m_collectorData.getStartDate().getTime() + lowerBound;
        GraphDisplayRange dr = this.getDisplayRange(new GraphDisplayRange(startTime, endTime = this.m_collectorData.getStartDate().getTime() + upperBound));
        if (dr == null) {
            return;
        }
        startTime = dr.getStartTime();
        endTime = dr.getEndTime();
        Date startDate = new Date(startTime - (long)(this.m_collectorData.getInterval() * 2 * 1000));
        Date endDate = new Date(endTime + (long)(this.m_collectorData.getInterval() * 2 * 1000));
        switch (this.m_graphType) {
            case 1: {
                this.drawGraph1(this.m_currentItem, this.m_facilityTree, startDate, endDate);
                break;
            }
            case 2: {
                this.drawGraph2(this.m_currentItem, this.m_facilityTree, startDate, endDate);
                break;
            }
            case 3: {
                this.drawGraph3(this.m_currentItem, this.m_facilityTree, startDate, endDate);
                break;
            }
        }
        this.addGotTimeArea(dr);
    }

    public void setGraphType(int graphType) {
        this.m_graphType = graphType;
    }

    public int getGraphType() {
        return this.m_graphType;
    }

    public void setTargetItemID(int itemID) {
        for (CollectorItemInfo itemInfo : this.m_itemInfoList) {
            if (itemInfo.getCollectorItemID() != itemID) continue;
            this.m_currentItem = itemInfo;
        }
    }

    public CollectorItemInfo getTargetItem() {
        return this.m_currentItem;
    }

    public void setTargetFacility(FacilityTreeItem facilityTree) {
        this.m_facilityTree = facilityTree;
        this.createGraph();
    }

    public FacilityTreeItem getTargetFacility() {
        return this.m_facilityTree;
    }

    public void createGraph() {
        Date stopDate;
        if (this.m_collectorData == null || this.m_itemInfoList == null || this.m_currentItem == null) {
            return;
        }
        String itemCode = this.m_currentItem.getCollectorItemCode();
        String deviceName = this.m_currentItem.getDeviceName();
        String title = CollectorItemCodeFactory.getCategoryName(itemCode);
        if (CollectorItemCodeFactory.isDeviceSupport(itemCode)) {
            title = String.valueOf(title) + "(" + this.m_currentItem.getDeviceName() + ")";
        }
        if (this.m_graphType == 1) {
            title = String.valueOf(title) + " " + Messages.getString("SCOPE_REPRESENTING_VALUE");
        } else if (this.m_graphType == 2) {
            title = String.valueOf(title) + " " + Messages.getString("DETAIL_SCOPE_REPRESENTING_VALUE");
        } else if (this.m_graphType == 3) {
            title = String.valueOf(title) + " " + Messages.getString("SUB_SCOPE_REP_VAL");
        }
        if (this.m_collectorData.getStatus() == 100) {
            long stopTime = this.m_collectorData.getStartDate().getTime() + this.m_collectorData.getRealCollectPeriod();
            stopDate = new Date(stopTime);
        } else {
            stopDate = this.m_collectorData.getStopDate();
        }
        this.m_composite.createGraph(title, Messages.getString("TIME"), String.valueOf(CollectorItemCodeFactory.getFullItemName(itemCode, deviceName)) + "(" + CollectorItemCodeFactory.getMeasure(itemCode) + ")", this.m_graphType, CollectorItemCodeFactory.isRangeFixed(itemCode), this.m_collectorData.getInterval(), this.m_collectorData.getStartDate(), stopDate);
    }

    public synchronized void widgetSelected(SelectionEvent e) {
        double lowerBound = (double)this.m_composite.getHorizontalBar().getSelection() * 1000.0;
        double upperBound = (double)(this.m_composite.getHorizontalBar().getThumb() + this.m_composite.getHorizontalBar().getSelection()) * 1000.0;
        this.drawGraph((long)lowerBound, (long)upperBound);
        this.m_composite.setRange(lowerBound, upperBound);
    }

    public synchronized void drawGraph1(CollectorItemInfo itemInfo, FacilityTreeItem treeItem, Date startDate, Date endDate) {
        String[] facilityIDs = new String[]{treeItem.getData().getFacilityId()};
        int[] itemIDs = new int[]{itemInfo.getCollectorItemID()};
        RecordController controller = RecordController.getInstance();
        if (controller == null) {
            MessageDialog.openError((Shell)this.m_composite.getShell(), (String)Messages.getString("MESSAGE_0020"), (String)Messages.getString("CONNECTION_ERROR_MESSAGE"));
            return;
        }
        CollectedDataSet dataSet = controller.getRecordCollectedData(itemInfo.getCollectorID(), facilityIDs, itemIDs, startDate, endDate);
        if (dataSet == null) {
            MessageDialog.openError((Shell)this.m_composite.getShell(), (String)Messages.getString("MESSAGE_0020"), (String)Messages.getString("GET_COLLECTEDDATA_ERROR_MESSAGE"));
            return;
        }
        List dataList = dataSet.getCollectedDataList(facilityIDs[0], itemIDs[0]);
        if (dataList.size() != 0) {
            this.setItemData(itemInfo.getCollectorItemCode(), itemInfo.getDeviceName(), dataList);
        }
    }

    public synchronized void drawGraph1Test1(String collectorID, String itemCode, CollectorItemInfo itemInfo, String facilityId, Date startDate, Date endDate) {
        String[] facilityIDs = new String[]{facilityId};
        int[] itemIDs = new int[]{itemInfo.getCollectorItemID()};
        RecordController controller = RecordController.getInstance();
        if (controller == null) {
            MessageDialog.openError((Shell)this.m_composite.getShell(), (String)Messages.getString("MESSAGE_0020"), (String)Messages.getString("CONNECTION_ERROR_MESSAGE"));
            return;
        }
        CollectedDataSet dataSet = controller.getRecordCollectedData(collectorID, facilityIDs, itemIDs, startDate, endDate);
        if (dataSet == null) {
            MessageDialog.openError((Shell)this.m_composite.getShell(), (String)Messages.getString("MESSAGE_0020"), (String)Messages.getString("GET_COLLECTEDDATA_ERROR_MESSAGE"));
            return;
        }
        List dataList = dataSet.getCollectedDataList(facilityIDs[0], itemIDs[0]);
        if (dataList.size() != 0) {
            this.setItemData(itemCode, "itemInfo.getDeviceName()", dataList);
        }
    }

    public synchronized void drawGraph2(CollectorItemInfo itemInfo, FacilityTreeItem treeItem, Date startDate, Date endDate) {
        List itemInfoList = this.selectItemInfo(itemInfo, this.m_itemInfoList);
        if (itemInfoList == null) {
            MessageDialog.openError((Shell)this.m_composite.getShell(), (String)Messages.getString("MESSAGE_0020"), (String)Messages.getString("DRAW_RECORD_GRAPH_ERROR_MESSAGE02"));
            return;
        }
        String[] facilityID = new String[]{treeItem.getData().getFacilityId()};
        int[] itemIDs = new int[itemInfoList.size()];
        int i = 0;
        while (i < itemIDs.length) {
            itemIDs[i] = ((CollectorItemInfo)itemInfoList.get(i)).getCollectorItemID();
            ++i;
        }
        RecordController controller = RecordController.getInstance();
        if (controller == null) {
            MessageDialog.openError((Shell)this.m_composite.getShell(), (String)Messages.getString("MESSAGE_0020"), (String)Messages.getString("CONNECTION_ERROR_MESSAGE"));
            return;
        }
        CollectedDataSet dataSet = controller.getRecordCollectedData(itemInfo.getCollectorID(), facilityID, itemIDs, startDate, endDate);
        if (dataSet == null) {
            MessageDialog.openError((Shell)this.m_composite.getShell(), (String)Messages.getString("MESSAGE_0020"), (String)Messages.getString("GET_COLLECTEDDATA_ERROR_MESSAGE"));
            return;
        }
        ArrayList<List> addedDataList = new ArrayList<List>();
        for (CollectorItemInfo buffer : itemInfoList) {
            List collectedDataList = dataSet.getCollectedDataList(treeItem.getData().getFacilityId(), buffer.getCollectorItemID());
            int size = addedDataList.size();
            int i2 = 0;
            while (i2 < size) {
                List dataBuffer = (List)addedDataList.get(i2);
                addedDataList.set(i2, this.getSumData(dataBuffer, collectedDataList));
                ++i2;
            }
            addedDataList.add(collectedDataList);
        }
        List bufferList = (List)addedDataList.get(0);
        if (bufferList.size() != 0) {
            int itemSize = itemInfoList.size();
            int i3 = 0;
            while (i3 < itemSize) {
                CollectorItemInfo buffer = (CollectorItemInfo)itemInfoList.get(i3);
                List collectedDataList = (List)addedDataList.get(i3);
                this.setItemData(buffer.getCollectorItemCode(), buffer.getDeviceName(), collectedDataList);
                ++i3;
            }
        }
    }

    public synchronized void drawGraph3(CollectorItemInfo itemInfo, FacilityTreeItem treeItem, Date startDate, Date endDate) {
        FacilityTreeItem[] children = treeItem.getChildren();
        ArrayList<FacilityInfo> targetFacilitys = new ArrayList<FacilityInfo>();
        int i = 0;
        while (i < children.length) {
            targetFacilitys.add(children[i].getData());
            ++i;
        }
        String[] facilityIDs = new String[targetFacilitys.size()];
        int i2 = 0;
        while (i2 < facilityIDs.length) {
            facilityIDs[i2] = ((FacilityInfo)targetFacilitys.get(i2)).getFacilityId();
            ++i2;
        }
        int[] itemID = new int[]{itemInfo.getCollectorItemID()};
        RecordController controller = RecordController.getInstance();
        if (controller == null) {
            MessageDialog.openError((Shell)this.m_composite.getShell(), (String)Messages.getString("MESSAGE_0020"), (String)Messages.getString("CONNECTION_ERROR_MESSAGE"));
            return;
        }
        CollectedDataSet dataSet = controller.getRecordCollectedData(itemInfo.getCollectorID(), facilityIDs, itemID, startDate, endDate);
        if (dataSet == null) {
            MessageDialog.openError((Shell)this.m_composite.getShell(), (String)Messages.getString("MESSAGE_0020"), (String)Messages.getString("GET_COLLECTEDDATA_ERROR_MESSAGE"));
            return;
        }
        String facilityID = ((FacilityInfo)targetFacilitys.get(0)).getFacilityId();
        List bufferList = dataSet.getCollectedDataList(facilityID, itemInfo.getCollectorItemID());
        if (bufferList.size() != 0) {
            Iterator itr = targetFacilitys.iterator();
            int i3 = 0;
            while (itr.hasNext()) {
                FacilityInfo facilityInfo = (FacilityInfo)itr.next();
                List collectedDataList = dataSet.getCollectedDataList(facilityInfo.getFacilityId(), itemInfo.getCollectorItemID());
                this.setFacilityData(i3, collectedDataList);
                ++i3;
            }
        }
    }

    private void setItemData(String itemCode, String deviceName, List data) {
        this.m_composite.setGraphData(CollectorItemCodeFactory.getFullItemName(itemCode, deviceName), data);
    }

    private void setFacilityData(int index, List data) {
        this.m_composite.setSubscopeGraphData(index, data);
    }

    private List selectItemInfo(CollectorItemInfo target, List itemList) {
        ArrayList<CollectorItemInfo> returnList = new ArrayList<CollectorItemInfo>();
        List itemCodeList = CollectorItemCodeFactory.getSubItemCode(target.getCollectorItemCode());
        int deviceIndex = target.getDeviceIndex();
        for (String itemCode : itemCodeList) {
            CollectorItemInfo buffer = null;
            for (CollectorItemInfo itemInfo : itemList) {
                if (!itemInfo.getCollectorItemCode().equals(itemCode) || itemInfo.getDeviceIndex() != deviceIndex) continue;
                buffer = itemInfo;
            }
            if (buffer == null) {
                return null;
            }
            returnList.add(buffer);
        }
        return returnList;
    }

    private List getSumData(List dataSet1, List dataSet2) {
        ArrayList<CollectedDataInfo> dataList = new ArrayList<CollectedDataInfo>();
        dataSet1.size();
        dataSet2.size();
        Iterator itr1 = dataSet1.iterator();
        Iterator itr2 = dataSet2.iterator();
        while (itr1.hasNext()) {
            CollectedDataInfo data1 = (CollectedDataInfo)itr1.next();
            CollectedDataInfo data2 = (CollectedDataInfo)itr2.next();
            CollectedDataInfo returnData = new CollectedDataInfo(data1.getFacilityID(), data1.getCollectorItemID(), data1.getDate(), data1.getValue() + data2.getValue());
            dataList.add(returnData);
        }
        return dataList;
    }

    private void addGotTimeArea(GraphDisplayRange dr) {
        if (this.m_gotTimeArea.size() == 0) {
            this.m_gotTimeArea.add(dr);
            return;
        }
        Iterator itr = this.m_gotTimeArea.iterator();
        while (itr.hasNext()) {
            GraphDisplayRange nextDrBuffer;
            GraphDisplayRange drBuffer = (GraphDisplayRange)itr.next();
            if (dr.getEndTime() < drBuffer.getStartTime()) {
                int index = this.m_gotTimeArea.indexOf(drBuffer);
                this.m_gotTimeArea.add(index, dr);
                return;
            }
            if (drBuffer.getStartTime() <= dr.getEndTime() && dr.getEndTime() <= drBuffer.getEndTime()) {
                drBuffer.setStartTime(dr.getStartTime());
                return;
            }
            if (drBuffer.getStartTime() > dr.getStartTime() || dr.getStartTime() > drBuffer.getEndTime()) continue;
            drBuffer.setEndTime(dr.getEndTime());
            if (itr.hasNext() && (nextDrBuffer = (GraphDisplayRange)itr.next()).getStartTime() <= drBuffer.getEndTime()) {
                drBuffer.setEndTime(Math.max(nextDrBuffer.getEndTime(), nextDrBuffer.getEndTime()));
                this.m_gotTimeArea.remove(nextDrBuffer);
            }
            return;
        }
        this.m_gotTimeArea.add(dr);
    }

    private GraphDisplayRange getDisplayRange(GraphDisplayRange dr) {
        if (this.m_gotTimeArea.size() == 0) {
            return dr;
        }
        GraphDisplayRange returnDr = new GraphDisplayRange();
        returnDr.setStartTime(dr.getStartTime());
        returnDr.setEndTime(dr.getEndTime());
        for (GraphDisplayRange drBuffer : this.m_gotTimeArea) {
            if (drBuffer.getStartTime() <= dr.getStartTime() && dr.getStartTime() <= drBuffer.getEndTime()) {
                returnDr.setStartTime(drBuffer.getEndTime());
            }
            if (drBuffer.getStartTime() > dr.getEndTime() || dr.getEndTime() > drBuffer.getEndTime()) continue;
            returnDr.setEndTime(drBuffer.getStartTime());
        }
        if (returnDr.getStartTime() >= returnDr.getEndTime()) {
            returnDr = null;
        }
        return returnDr;
    }
}

