/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.process.factory;

import com.clustercontrol.monitor.run.factory.RunMonitorNumericValueType;
import com.clustercontrol.process.ejb.entity.MonitorProcessInfoLocal;
import com.clustercontrol.process.ejb.entity.MonitorProcessInfoPK;
import com.clustercontrol.process.ejb.entity.MonitorProcessInfoUtil;
import com.clustercontrol.process.util.ProcessProperties;
import com.clustercontrol.process.util.SnmpProcConnectionManager;
import com.clustercontrol.sharedtable.bean.ValueObject;
import com.clustercontrol.snmppoller.SnmpSharedTable;
import com.clustercontrol.util.Messages;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RunMonitorProcess
extends RunMonitorNumericValueType {
    protected static Log m_log = LogFactory.getLog(RunMonitorProcess.class);
    public static final String MESSAGE_ID_INFO = "001";
    public static final String MESSAGE_ID_WARNING = "002";
    public static final String MESSAGE_ID_CRITICAL = "003";
    public static final String MESSAGE_ID_UNKNOWN = "004";
    protected MonitorProcessInfoLocal m_process = null;
    protected String m_command = "";
    protected String m_param = "";
    protected SnmpSharedTable m_sst = null;
    protected String m_message = null;
    protected String m_messageOrg = null;
    protected NumberFormat m_numberFormat = NumberFormat.getNumberInstance();

    public RunMonitorProcess() throws NamingException, JMSException, CreateException {
        this.setSnmpSharedTable();
    }

    public boolean collect(String facilityId) {
        int count = 0;
        this.m_nodeDate = this.m_now.getTime();
        this.m_message = "";
        this.m_messageOrg = Messages.getString((String)"command") + " : " + this.m_command + ", " + Messages.getString((String)"param") + " : " + this.m_param;
        Pattern pCommand = null;
        Pattern pParam = null;
        Matcher m = null;
        try {
            pCommand = Pattern.compile(this.m_command);
            pParam = Pattern.compile(this.m_param);
        }
        catch (PatternSyntaxException e) {
            m_log.error((Object)("collect(): \u30b3\u30de\u30f3\u30c9,\u30d1\u30e9\u30e1\u30fc\u30bf\u6b63\u898f\u8868\u73fe\u30d1\u30bf\u30fc\u30f3\u69cb\u6587\u30a8\u30e9\u30fc\u3002" + e.getMessage()));
            this.m_message = Messages.getString((String)"message.process.13");
            return false;
        }
        int runInterval = this.m_monitor.getRunInterval();
        Set valueSetPath = this.m_sst.getValueSet(facilityId, runInterval, ".1.3.6.1.2.1.25.4.2.1.4");
        if (valueSetPath == null) {
            m_log.debug((Object)"collect(): SNMP\u30dd\u30fc\u30e9\u30fc\u5024\u672a\u53ce\u96c6");
            this.m_message = Messages.getString((String)"message.process.15");
            return false;
        }
        ValueObject valueObjCommand2 = null;
        ValueObject valueObjParam = null;
        String valueCommand = null;
        String valueParam = null;
        for (ValueObject valueObjCommand2 : valueSetPath) {
            valueCommand = (String)valueObjCommand2.getValue();
            m = pCommand.matcher(valueCommand);
            if (!m.matches()) continue;
            m_log.debug((Object)("collect(): SNMP\u30dd\u30fc\u30e9\u53ce\u96c6\u8d77\u52d5\u30d1\u30b9: " + valueObjCommand2));
            String key = valueObjCommand2.getKey();
            String index = key.substring(key.lastIndexOf("."));
            valueObjParam = this.m_sst.getValue(facilityId, runInterval, ".1.3.6.1.2.1.25.4.2.1.5" + index);
            valueParam = (String)valueObjParam.getValue();
            m = pParam.matcher(valueParam);
            if (!m.matches()) continue;
            m_log.debug((Object)("collect(): SNMP\u30dd\u30fc\u30e9\u53ce\u96c6\u8d77\u52d5\u30d1\u30e9\u30e1\u30fc\u30bf : " + valueObjParam));
            Date pollingDate = new Date(valueObjCommand2.getDate());
            int tolerance = ProcessProperties.getProperties().getStartSecond() + ProcessProperties.getProperties().getValidSecond();
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.m_now);
            cal.add(13, -tolerance);
            if (cal.getTime().compareTo(pollingDate) > 0) {
                this.m_nodeDate = this.m_now.getTime();
                Object[] args = new String[]{DateFormat.getDateTimeInstance().format(pollingDate)};
                this.m_message = Messages.getString((String)"message.process.16", (Object[])args);
                return false;
            }
            this.m_nodeDate = valueObjCommand2.getDate();
            ++count;
        }
        this.m_value = count;
        this.m_message = Messages.getString((String)"process.number") + " : " + this.m_numberFormat.format(this.m_value);
        return true;
    }

    public void setCheckInfo() throws FinderException, NamingException {
        MonitorProcessInfoPK pk = new MonitorProcessInfoPK(this.m_monitorId, this.m_monitorTypeId);
        this.m_process = MonitorProcessInfoUtil.getLocalHome().findByPrimaryKey(pk);
        this.m_command = this.m_process.getCommand().trim();
        if (this.m_process.getParam() != null) {
            this.m_param = this.m_process.getParam().trim();
        }
    }

    public String getMessageId(int result) {
        if (result == 3) {
            return MESSAGE_ID_INFO;
        }
        if (result == 2) {
            return MESSAGE_ID_WARNING;
        }
        if (result == 0) {
            return MESSAGE_ID_CRITICAL;
        }
        return MESSAGE_ID_UNKNOWN;
    }

    public String getMessage(int result) {
        return this.m_message;
    }

    public String getMessageOrg(int result) {
        return this.m_messageOrg;
    }

    private void setSnmpSharedTable() throws NamingException {
        this.m_sst = SnmpProcConnectionManager.getConnectionManager().getSnmpSharedTable();
    }
}

