/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performanceMGR.monitor.factory;

import com.clustercontrol.monitor.run.factory.RunMonitorNumericValueType;
import com.clustercontrol.performanceMGR.bean.CollectedDataInfo;
import com.clustercontrol.performanceMGR.monitor.ejb.entity.MonitorPerfInfoLocal;
import com.clustercontrol.performanceMGR.monitor.ejb.entity.MonitorPerfInfoPK;
import com.clustercontrol.performanceMGR.monitor.ejb.entity.MonitorPerfInfoUtil;
import com.clustercontrol.performanceMGR.util.code.CollectorItemCodeTable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RunMonitorPerformance2
extends RunMonitorNumericValueType {
    protected static Log m_log = LogFactory.getLog(RunMonitorPerformance2.class);
    public static final String MESSAGE_ID_INFO = "001";
    public static final String MESSAGE_ID_WARNING = "002";
    public static final String MESSAGE_ID_CRITICAL = "003";
    public static final String MESSAGE_ID_UNKNOWN = "004";
    protected MonitorPerfInfoLocal m_perf = null;
    private String m_itemName = null;
    protected NumberFormat m_numberFormat = NumberFormat.getNumberInstance();
    static /* synthetic */ Class class$0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(String monitorTypeId, String monitorId, CollectedDataInfo data) throws FinderException, RemoveException, JMSException, NamingException {
        String facilityId = data.getFacilityID();
        if (facilityId == null) return;
        if ("".equals(facilityId)) {
            return;
        }
        this.m_value = (float)data.getValue();
        this.m_monitorTypeId = monitorTypeId;
        this.m_monitorId = monitorId;
        this.m_priorityMap = new HashMap();
        this.m_priorityMap.put(3, new ArrayList());
        this.m_priorityMap.put(2, new ArrayList());
        this.m_priorityMap.put(0, new ArrayList());
        this.m_priorityMap.put(1, new ArrayList());
        try {
            try {
                boolean notify = this.setMonitorInfo(this.m_monitorTypeId, this.m_monitorId);
                if (!notify) {
                    return;
                }
                this.setJudgementInfo();
                this.setCheckInfo();
                if (this.m_monitorBlock == 0 || 2 == this.m_monitorBlock) {
                    this.m_repository.isNode(facilityId);
                }
                if (!(2 == this.m_monitorBlock || this.m_monitorBlock == 0 && this.m_repository.isNode(facilityId))) {
                    if (1 != this.m_monitorBlock) return;
                    if (this.m_repository.isNode(facilityId)) return;
                }
                boolean result = this.collect(facilityId);
                int priority = this.getPriority(result);
                boolean isNode = this.m_monitorBlock == 0;
                if (data.getDate().getTime() == 0L) {
                    this.notify(isNode, facilityId, priority, new Date());
                    return;
                }
                this.notify(isNode, facilityId, priority, data.getDate());
                return;
            }
            finally {
                this.terminate();
            }
        }
        catch (FinderException e) {
            m_log.error((Object)("run():" + e.getMessage()));
            e.printStackTrace();
            throw e;
        }
        catch (JMSException e) {
            e.printStackTrace();
            throw e;
        }
        catch (NamingException e) {
            m_log.error((Object)("run():" + e.getMessage()));
            e.printStackTrace();
            throw e;
        }
    }

    public void setCheckInfo() throws FinderException, NamingException {
        MonitorPerfInfoPK pk = new MonitorPerfInfoPK(this.m_monitorId, this.m_monitorTypeId);
        this.m_perf = MonitorPerfInfoUtil.getLocalHome().findByPrimaryKey(pk);
        this.m_itemName = CollectorItemCodeTable.getFullItemName(this.m_perf.getItemCode(), this.m_perf.getDeviceName());
    }

    public String getMessageId(int result) {
        if (result == 3) {
            return MESSAGE_ID_INFO;
        }
        if (result == 2) {
            return MESSAGE_ID_WARNING;
        }
        if (result == 0) {
            return MESSAGE_ID_CRITICAL;
        }
        return MESSAGE_ID_UNKNOWN;
    }

    public String getMessage(int result) {
        return String.valueOf(this.m_itemName) + " : " + this.m_numberFormat.format(this.m_value);
    }

    public String getMessageForScope(int result) {
        return String.valueOf(this.m_itemName) + " : " + this.m_numberFormat.format(this.m_value);
    }

    public String getMessageOrg(int result) {
        return String.valueOf(this.m_itemName) + " : " + this.m_numberFormat.format(this.m_value);
    }

    public String getMessageOrgForScope(int result) {
        return String.valueOf(this.m_itemName) + " : " + this.m_numberFormat.format(this.m_value);
    }

    public boolean collect(String facilityId) {
        return !Float.isNaN(this.m_value);
    }
}

