/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.collectiverun.util;

import com.clustercontrol.collectiverun.message.CollectiveRunInstructionInfo;
import com.clustercontrol.jobmanagement.message.RunResultInfo;
import java.io.Serializable;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class SendQueue {
    protected String m_queueName;
    protected InitialContext m_context;
    protected QueueConnectionFactory m_connectionFactory;
    protected QueueConnection m_connection;
    protected Queue m_queue;
    protected QueueSession m_session;
    protected QueueSender m_sender;

    public SendQueue(String queueName) throws NamingException, JMSException {
        this.m_queueName = queueName;
        this.initial();
    }

    public void initial() throws NamingException, JMSException {
        this.m_context = null;
        String serverName = System.getProperty("jboss.server.name");
        if (serverName.equals("all")) {
            Properties properties = new Properties();
            properties.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
            properties.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
            properties.put("java.naming.provider.url", "jnp://localhost:1100");
            this.m_context = new InitialContext(properties);
        } else {
            this.m_context = new InitialContext();
        }
        this.m_connectionFactory = (QueueConnectionFactory)this.m_context.lookup("ConnectionFactory");
        this.m_connection = this.m_connectionFactory.createQueueConnection();
        this.m_session = this.m_connection.createQueueSession(false, 1);
        this.m_queue = (Queue)this.m_context.lookup(this.m_queueName);
        this.m_sender = this.m_session.createSender(this.m_queue);
    }

    public void close() throws NamingException, JMSException {
        this.m_sender.close();
        this.m_session.close();
        this.m_connection.close();
        this.m_context.close();
    }

    public void put(CollectiveRunInstructionInfo info) throws JMSException, NamingException {
        while (true) {
            try {
                ObjectMessage message = this.m_session.createObjectMessage((Serializable)((Object)info));
                this.m_sender.send((Message)message);
            }
            catch (JMSException e) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.close();
                this.initial();
                continue;
            }
            break;
        }
    }

    public void put(RunResultInfo info) throws JMSException, NamingException {
        while (true) {
            try {
                ObjectMessage message = this.m_session.createObjectMessage((Serializable)info);
                this.m_sender.send((Message)message);
            }
            catch (JMSException e) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.close();
                this.initial();
                continue;
            }
            break;
        }
    }
}

