/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite;

import com.clustercontrol.bean.CommonTableTreeItem;
import com.clustercontrol.composite.CommonTableTreeViewer;
import com.clustercontrol.jobmanagement.action.GetRunScheduleDetail;
import com.clustercontrol.jobmanagement.action.GetRunScheduleDetailTableDefine;
import com.clustercontrol.jobmanagement.composite.action.VerticalBarSelectionListener;
import com.clustercontrol.util.Messages;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class RunScheduleDetailComposite
extends Composite {
    protected CommonTableTreeViewer m_viewer = null;
    protected Label m_labelCount = null;
    protected String m_scheduleId = null;
    protected Date m_base = null;

    public RunScheduleDetailComposite(Composite parent, int style, Date base) {
        super(parent, style);
        this.m_base = base;
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Label dummy = new Label((Composite)this, 16384);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        dummy.setLayoutData((Object)gridData);
        dummy.setText("    ");
        TableTree tree = new TableTree((Composite)this, 68356);
        Table table = tree.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.getHorizontalBar().setVisible(true);
        table.getHorizontalBar().setEnabled(true);
        table.getVerticalBar().setVisible(true);
        table.getVerticalBar().setEnabled(true);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        tree.setLayoutData((Object)gridData);
        this.m_labelCount = new Label((Composite)this, 131072);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.m_labelCount.setLayoutData((Object)gridData);
        this.m_viewer = new CommonTableTreeViewer(tree);
        this.m_viewer.createTableColumn(GetRunScheduleDetailTableDefine.get((Date)this.m_base), 1, 1);
        this.m_viewer.getTableTree().getTable().getVerticalBar().addSelectionListener((SelectionListener)new VerticalBarSelectionListener(this));
    }

    public void update(String scheduleId) {
        GetRunScheduleDetail getList = new GetRunScheduleDetail();
        CommonTableTreeItem item = null;
        if (scheduleId != null && scheduleId.length() > 0) {
            item = getList.get(scheduleId, this.m_base);
        }
        this.m_viewer.setInput(item);
        this.m_viewer.expandAll();
        this.m_scheduleId = scheduleId;
        Object[] args = new Object[]{DateFormat.getDateInstance().format(this.m_base)};
        this.m_labelCount.setText(Messages.getString((String)"specified.period", (Object[])args));
    }

    public TableTreeViewer getTableTreeViewer() {
        return this.m_viewer;
    }

    public Table getTable() {
        return this.m_viewer.getTableTree().getTable();
    }

    public TableTree getTableTree() {
        return this.m_viewer.getTableTree();
    }

    public String getScheduleId() {
        return this.m_scheduleId;
    }

    public void setScheduleId(String scheduleId) {
        this.m_scheduleId = scheduleId;
    }

    public Date getBaseDate() {
        return this.m_base;
    }

    public void setCalendarId(Date base) {
        this.m_base = base;
    }
}

