/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GtkFileSelection;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DirectoryDialog
extends Dialog {
    String message = "";
    String filterPath = "";
    static final String SEPARATOR = System.getProperty("file.separator");

    public DirectoryDialog(Shell parent) {
        this(parent, 32768);
    }

    public DirectoryDialog(Shell parent, int style) {
        super(parent, style);
        this.checkSubclass();
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public String getMessage() {
        return this.message;
    }

    public String open() {
        boolean useChooserDialog;
        boolean bl = useChooserDialog = OS.GTK_VERSION >= OS.VERSION(2, 4, 10);
        if (useChooserDialog) {
            return this.openChooserDialog();
        }
        return this.openClassicDialog();
    }

    String openChooserDialog() {
        int folder;
        byte[] titleBytes = Converter.wcsToMbcs(null, this.title, true);
        Display display = this.parent.getDisplay();
        boolean oldWarnings = display.getWarnings();
        display.setWarnings(false);
        int shellHandle = this.parent.topHandle();
        int handle = OS.gtk_file_chooser_dialog_new(titleBytes, shellHandle, 2, OS.GTK_STOCK_CANCEL(), -6, OS.GTK_STOCK_OK(), -5, 0);
        int pixbufs = OS.gtk_window_get_icon_list(shellHandle);
        if (pixbufs != 0) {
            OS.gtk_window_set_icon_list(handle, pixbufs);
            OS.g_list_free(pixbufs);
        }
        display.setWarnings(oldWarnings);
        if (this.filterPath != null && this.filterPath.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            if (!this.filterPath.startsWith(SEPARATOR)) {
                stringBuffer.append(SEPARATOR);
            }
            stringBuffer.append(this.filterPath);
            byte[] buffer = Converter.wcsToMbcs(null, stringBuffer.toString(), true);
            OS.gtk_file_chooser_set_current_folder(handle, buffer);
        }
        if (this.message.length() > 0) {
            int label;
            byte[] buffer = Converter.wcsToMbcs(null, this.message, true);
            int box = OS.gtk_hbox_new(false, 0);
            if (box == 0) {
                this.error(2);
            }
            if ((label = OS.gtk_label_new(buffer)) == 0) {
                this.error(2);
            }
            OS.gtk_container_add(box, label);
            OS.gtk_widget_show(label);
            OS.gtk_label_set_line_wrap(label, true);
            OS.gtk_label_set_justify(label, 2);
            OS.gtk_file_chooser_set_extra_widget(handle, box);
        }
        String answer = null;
        int response = OS.gtk_dialog_run(handle);
        if (response == -5 && (folder = OS.gtk_file_chooser_get_current_folder(handle)) != 0) {
            int utf8Ptr = OS.g_filename_to_utf8(folder, -1, null, null, null);
            if (utf8Ptr != 0) {
                int[] items_written = new int[1];
                int utf16Ptr = OS.g_utf8_to_utf16(utf8Ptr, -1, null, items_written, null);
                if (utf16Ptr != 0) {
                    int clength = items_written[0];
                    char[] chars = new char[clength];
                    OS.memmove(chars, utf16Ptr, clength * 2);
                    this.filterPath = answer = new String(chars);
                    OS.g_free(utf16Ptr);
                }
                OS.g_free(utf8Ptr);
            }
            OS.g_free(folder);
        }
        OS.gtk_widget_destroy(handle);
        return answer;
    }

    String openClassicDialog() {
        int fileNamePtr;
        int utf8Ptr;
        int response;
        Object[] buffer;
        byte[] titleBytes = Converter.wcsToMbcs(null, this.title, true);
        int handle = OS.gtk_file_selection_new(titleBytes);
        if (this.parent != null) {
            int shellHandle = this.parent.topHandle();
            OS.gtk_window_set_transient_for(handle, shellHandle);
            int pixbufs = OS.gtk_window_get_icon_list(shellHandle);
            if (pixbufs != 0) {
                OS.gtk_window_set_icon_list(handle, pixbufs);
                OS.g_list_free(pixbufs);
            }
        }
        String answer = null;
        if (this.filterPath != null) {
            String path = this.filterPath;
            if (path.length() > 0 && !path.endsWith(SEPARATOR)) {
                path = String.valueOf(path) + SEPARATOR;
            }
            int length = path.length();
            buffer = new char[length + 1];
            path.getChars(0, length, (char[])buffer, 0);
            int utf8Ptr2 = OS.g_utf16_to_utf8(buffer, -1, null, null, null);
            int fileNamePtr2 = OS.g_filename_from_utf8(utf8Ptr2, -1, null, null, null);
            OS.gtk_file_selection_set_filename(handle, fileNamePtr2);
            OS.g_free(utf8Ptr2);
            OS.g_free(fileNamePtr2);
        }
        GtkFileSelection selection = new GtkFileSelection();
        OS.memmove(selection, handle);
        OS.gtk_file_selection_hide_fileop_buttons(handle);
        int fileListParent = OS.gtk_widget_get_parent(selection.file_list);
        OS.gtk_widget_hide(selection.file_list);
        OS.gtk_widget_hide(fileListParent);
        if (this.message.length() > 0) {
            buffer = Converter.wcsToMbcs(null, this.message, true);
            int labelHandle = OS.gtk_label_new((byte[])buffer);
            OS.gtk_label_set_line_wrap(labelHandle, true);
            OS.gtk_misc_set_alignment(labelHandle, 0.0f, 0.0f);
            OS.gtk_container_add(selection.main_vbox, labelHandle);
            OS.gtk_box_set_child_packing(selection.main_vbox, labelHandle, false, false, 0, 0);
            OS.gtk_widget_show(labelHandle);
        }
        if ((response = OS.gtk_dialog_run(handle)) == -5 && (utf8Ptr = OS.g_filename_to_utf8(fileNamePtr = OS.gtk_file_selection_get_filename(handle), -1, null, null, null)) != 0) {
            int[] items_written = new int[1];
            int utf16Ptr = OS.g_utf8_to_utf16(utf8Ptr, -1, null, items_written, null);
            if (utf16Ptr != 0) {
                int length = items_written[0];
                char[] buffer2 = new char[length];
                OS.memmove(buffer2, utf16Ptr, length * 2);
                String osAnswer = new String(buffer2);
                if (osAnswer != null) {
                    if (!osAnswer.equals(SEPARATOR) && osAnswer.endsWith(SEPARATOR)) {
                        osAnswer = osAnswer.substring(0, osAnswer.length() - 1);
                    }
                    answer = this.filterPath = osAnswer;
                }
                OS.g_free(utf16Ptr);
            }
            OS.g_free(utf8Ptr);
        }
        OS.gtk_widget_destroy(handle);
        return answer;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }
}

