/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.launcher;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Manifest;
import org.eclipse.core.launcher.Main;

public class WebStartMain
extends Main {
    private static final String PROP_WEBSTART_AUTOMATIC_INSTALLATION = "eclipse.webstart.automaticInstallation";
    private static final String DEFAULT_OSGI_BUNDLES = "org.eclipse.core.runtime@2:start";
    private static final String PROP_OSGI_BUNDLES = "osgi.bundles";
    private static final String PROP_WEBSTART_PRECISE_BUNDLEID = "eclipse.webstart.preciseBundleId";
    private String[] allJars = null;
    private Map bundleList = null;
    private Map bundleStartInfo = null;
    private boolean preciseIdExtraction = false;
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        System.setSecurityManager(null);
        int result = new WebStartMain().run(args);
        System.exit(result);
    }

    private void setDefaultBundles() {
        if (System.getProperty(PROP_OSGI_BUNDLES) != null) {
            return;
        }
        System.getProperties().put(PROP_OSGI_BUNDLES, DEFAULT_OSGI_BUNDLES);
    }

    protected void basicRun(String[] args) throws Exception {
        this.preciseIdExtraction = Boolean.getBoolean(PROP_WEBSTART_PRECISE_BUNDLEID);
        this.setDefaultBundles();
        this.addOSGiBundle();
        this.initializeBundleListStructure();
        this.mapURLsToBundleList();
        String fwkURL = this.searchFor(this.framework, null);
        System.getProperties().put("osgi.framework", fwkURL);
        super.basicRun(args);
    }

    private void addOSGiBundle() {
        System.getProperties().put(PROP_OSGI_BUNDLES, String.valueOf(System.getProperty(PROP_OSGI_BUNDLES)) + ',' + this.framework);
    }

    protected URL[] getBootPath(String base) throws IOException {
        URL[] result = super.getBootPath(base);
        this.buildOSGiBundleList();
        this.cleanup();
        return result;
    }

    private void cleanup() {
        this.allJars = null;
        this.bundleList = null;
        this.bundleStartInfo = null;
    }

    protected String searchFor(String target, String start) {
        ArrayList matches = (ArrayList)this.bundleList.get(target);
        int numberOfURLs = matches.size();
        if (numberOfURLs == 1) {
            return this.extractInnerURL((String)matches.get(0));
        }
        if (numberOfURLs == 0) {
            return null;
        }
        String[] urls = new String[numberOfURLs];
        return this.extractInnerURL(urls[this.findMax(matches.toArray(urls))]);
    }

    private String[] getAllJars() {
        if (this.allJars != null) {
            return this.allJars;
        }
        ArrayList<String> collector = new ArrayList<String>();
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.launcher.WebStartMain");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Enumeration<URL> resources = clazz.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                collector.add(resources.nextElement().toExternalForm());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.allJars = new String[collector.size()];
        collector.toArray(this.allJars);
        if (this.debug) {
            this.printArray("Jars found on the webstart path:\n", this.allJars);
        }
        return this.allJars;
    }

    private String extractInnerURL(String url) {
        int lastBang;
        if (url.startsWith("jar:")) {
            url = url.substring(url.indexOf("jar:") + 4);
        }
        if ((lastBang = url.lastIndexOf(33)) != -1) {
            url = url.substring(0, lastBang);
        }
        return this.decode(url);
    }

    private void printArray(String header, String[] values) {
        System.err.println(header);
        int i = 0;
        while (i < values.length) {
            System.err.println("\t" + values[i]);
            ++i;
        }
    }

    private void initializeBundleListStructure() {
        String prop = System.getProperty(PROP_OSGI_BUNDLES);
        if (prop == null || prop.trim().equals("")) {
            this.bundleList = new HashMap(0);
            return;
        }
        this.bundleList = new HashMap(10);
        this.bundleStartInfo = new HashMap(10);
        StringTokenizer tokens = new StringTokenizer(prop, ",");
        while (tokens.hasMoreTokens()) {
            String token;
            String bundleId = token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            int startLevelSeparator = token.lastIndexOf(64);
            if (startLevelSeparator != -1) {
                bundleId = token.substring(0, startLevelSeparator);
                this.bundleStartInfo.put(bundleId, token.substring(startLevelSeparator));
            }
            this.bundleList.put(bundleId, new ArrayList(1));
        }
    }

    private void mapURLsToBundleList() {
        String[] allJars = this.getAllJars();
        int i = 0;
        while (i < allJars.length) {
            int versionIdPosition;
            ArrayList bundleURLs;
            String bundleId = this.extractBundleId(allJars[i]);
            if (bundleId != null && ((bundleURLs = (ArrayList)this.bundleList.get(bundleId)) != null || (versionIdPosition = bundleId.lastIndexOf(95)) != -1 && (bundleURLs = (ArrayList)this.bundleList.get(bundleId.subSequence(0, versionIdPosition))) != null)) {
                bundleURLs.add(allJars[i]);
                allJars[i] = null;
            }
            ++i;
        }
    }

    private String extractBundleId(String url) {
        if (this.preciseIdExtraction) {
            return this.extractBundleIdFromManifest(url);
        }
        return this.extractBundleIdFromBundleURL(url);
    }

    private String extractBundleIdFromManifest(String url) {
        try {
            Manifest mf = new Manifest(new URL(url).openStream());
            String symbolicNameString = mf.getMainAttributes().getValue("Bundle-SymbolicName");
            if (symbolicNameString == null) {
                return null;
            }
            String bundleVersion = mf.getMainAttributes().getValue("Bundle-Version");
            bundleVersion = bundleVersion == null ? "" : String.valueOf('_') + bundleVersion;
            int pos = symbolicNameString.lastIndexOf(59);
            if (pos != -1) {
                return String.valueOf(symbolicNameString.substring(0, pos)) + bundleVersion;
            }
            return String.valueOf(symbolicNameString) + bundleVersion;
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {}
        return null;
    }

    private String extractBundleIdFromBundleURL(String url) {
        int lastBang = url.lastIndexOf(33);
        if (lastBang == -1) {
            return null;
        }
        boolean jarSuffix = url.regionMatches(true, lastBang - 4, ".jar", 0, 4);
        int bundleIdStart = url.lastIndexOf(47, lastBang);
        return url.substring(bundleIdStart + 3, lastBang - (jarSuffix ? 4 : 0));
    }

    private void buildOSGiBundleList() {
        this.bundleList.remove(this.framework);
        String[] jarsOnClasspath = this.getAllJars();
        StringBuffer finalBundleList = new StringBuffer(jarsOnClasspath.length * 25);
        Set allSelectedBundles = this.bundleList.entrySet();
        Iterator iter = allSelectedBundles.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            ArrayList matches = (ArrayList)entry.getValue();
            int numberOfURLs = matches.size();
            String startInfo = (String)this.bundleStartInfo.get(entry.getKey());
            if (startInfo == null) {
                startInfo = "";
            }
            if (numberOfURLs == 1) {
                finalBundleList.append("reference:").append(this.extractInnerURL((String)matches.get(0))).append(startInfo).append(',');
                continue;
            }
            if (numberOfURLs == 0) continue;
            String[] urls = new String[numberOfURLs];
            int found = this.findMax(matches.toArray(urls));
            int i = 0;
            while (i < urls.length) {
                if (i == found) {
                    finalBundleList.append("reference:").append(this.extractInnerURL(urls[found])).append(startInfo).append(',');
                }
                ++i;
            }
        }
        if (!Boolean.FALSE.toString().equalsIgnoreCase(System.getProperties().getProperty(PROP_WEBSTART_AUTOMATIC_INSTALLATION))) {
            int i = 0;
            while (i < jarsOnClasspath.length) {
                if (jarsOnClasspath[i] != null) {
                    finalBundleList.append("reference:").append(this.extractInnerURL(jarsOnClasspath[i])).append(',');
                }
                ++i;
            }
        }
        System.getProperties().put(PROP_OSGI_BUNDLES, finalBundleList.toString());
        if (this.debug) {
            this.log(finalBundleList.toString());
        }
    }
}

