/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Random;
import java.util.StringTokenizer;
import sun.net.www.HeaderParser;
import sun.net.www.protocol.http.AuthenticationInfo;
import sun.net.www.protocol.http.HttpURLConnection;

class DigestAuthentication
extends AuthenticationInfo {
    private static final long serialVersionUID = 100L;
    static final char DIGEST_AUTH = 'D';
    private String authMethod;
    Parameters params;
    private static final char[] charArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String[] zeroPad = new String[]{"00000000", "0000000", "000000", "00000", "0000", "000", "00", "0"};

    public DigestAuthentication(boolean bl2, URL uRL, String string, String string2, PasswordAuthentication passwordAuthentication, Parameters parameters) {
        super(bl2 ? (char)'p' : 's', 'D', uRL, string);
        this.authMethod = string2;
        this.pw = passwordAuthentication;
        this.params = parameters;
    }

    public DigestAuthentication(boolean bl2, String string, int n2, String string2, String string3, PasswordAuthentication passwordAuthentication, Parameters parameters) {
        super(bl2 ? (char)'p' : 's', 'D', string, n2, string2);
        this.authMethod = string3;
        this.pw = passwordAuthentication;
        this.params = parameters;
    }

    boolean supportsPreemptiveAuthorization() {
        return true;
    }

    String getHeaderName() {
        if (this.type == 's') {
            return "Authorization";
        }
        return "Proxy-Authorization";
    }

    String getHeaderValue(URL uRL, String string) {
        return this.getHeaderValueImpl(uRL.getFile(), string);
    }

    boolean isAuthorizationStale(String string) {
        HeaderParser headerParser = new HeaderParser(string);
        String string2 = headerParser.findValue("stale");
        if (string2 == null || !string2.equals("true")) {
            return false;
        }
        String string3 = headerParser.findValue("nonce");
        if (string3 == null || "".equals(string3)) {
            return false;
        }
        this.params.setNonce(string3);
        return true;
    }

    boolean setHeaders(HttpURLConnection httpURLConnection, HeaderParser headerParser, String string) {
        String string2;
        String string3;
        this.params.setNonce(headerParser.findValue("nonce"));
        this.params.setOpaque(headerParser.findValue("opaque"));
        this.params.setQop(headerParser.findValue("qop"));
        String string4 = httpURLConnection.getURL().getFile();
        if (this.params.nonce == null || this.authMethod == null || this.pw == null || this.realm == null) {
            return false;
        }
        if (this.authMethod.length() >= 1) {
            this.authMethod = Character.toUpperCase(this.authMethod.charAt(0)) + this.authMethod.substring(1).toLowerCase();
        }
        if ((string3 = headerParser.findValue("algorithm")) == null || "".equals(string3)) {
            string3 = "MD5";
        }
        this.params.setAlgorithm(string3);
        if (this.params.authQop()) {
            this.params.setNewCnonce();
        }
        if ((string2 = this.getHeaderValueImpl(string4, httpURLConnection.getMethod())) != null) {
            httpURLConnection.setAuthenticationProperty(this.getHeaderName(), string2);
            return true;
        }
        return false;
    }

    private String getHeaderValueImpl(String string, String string2) {
        String string3;
        int n2;
        char[] cArray = this.pw.getPassword();
        boolean bl2 = this.params.authQop();
        String string4 = this.params.getOpaque();
        String string5 = this.params.getCnonce();
        String string6 = this.params.getNonce();
        String string7 = this.params.getAlgorithm();
        this.params.incrementNC();
        int n3 = this.params.getNCCount();
        String string8 = null;
        if (n3 != -1 && (n2 = (string8 = Integer.toHexString(n3).toLowerCase()).length()) < 8) {
            string8 = zeroPad[n2] + string8;
        }
        try {
            string3 = this.computeDigest(true, this.pw.getUserName(), cArray, this.realm, string2, string, string6, string5, string8);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
        String string9 = "\"";
        if (bl2) {
            string9 = "\", nc=" + string8;
        }
        String string10 = this.authMethod + " username=\"" + this.pw.getUserName() + "\", realm=\"" + this.realm + "\", nonce=\"" + string6 + string9 + ", uri=\"" + string + "\", response=\"" + string3 + "\", algorithm=\"" + string7;
        if (string4 != null) {
            string10 = string10 + "\", opaque=\"" + string4;
        }
        if (string5 != null) {
            string10 = string10 + "\", cnonce=\"" + string5;
        }
        if (bl2) {
            string10 = string10 + "\", qop=\"auth";
        }
        string10 = string10 + "\"";
        return string10;
    }

    public void checkResponse(String string, String string2, URL uRL) throws IOException {
        int n2;
        String string3 = uRL.getFile();
        char[] cArray = this.pw.getPassword();
        String string4 = this.pw.getUserName();
        boolean bl2 = this.params.authQop();
        String string5 = this.params.getOpaque();
        String string6 = this.params.cnonce;
        String string7 = this.params.getNonce();
        String string8 = this.params.getAlgorithm();
        int n3 = this.params.getNCCount();
        String string9 = null;
        if (string == null) {
            throw new ProtocolException("No authentication information in response");
        }
        if (n3 != -1 && (n2 = (string9 = Integer.toHexString(n3).toUpperCase()).length()) < 8) {
            string9 = zeroPad[n2] + string9;
        }
        try {
            String string10 = this.computeDigest(false, string4, cArray, this.realm, string2, string3, string7, string6, string9);
            HeaderParser headerParser = new HeaderParser(string);
            String string11 = headerParser.findValue("rspauth");
            if (string11 == null) {
                throw new ProtocolException("No digest in response");
            }
            if (!string11.equals(string10)) {
                throw new ProtocolException("Response digest invalid");
            }
            String string12 = headerParser.findValue("nextnonce");
            if (string12 != null && !"".equals(string12)) {
                this.params.setNonce(string12);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ProtocolException("Unsupported algorithm in response");
        }
    }

    private String computeDigest(boolean bl2, String string, char[] cArray, String string2, String string3, String string4, String string5, String string6, String string7) throws NoSuchAlgorithmException {
        String string8;
        String string9;
        String string10;
        String string11 = this.params.getAlgorithm();
        boolean bl3 = string11.equalsIgnoreCase("MD5-sess");
        MessageDigest messageDigest = MessageDigest.getInstance(bl3 ? "MD5" : string11);
        if (bl3) {
            string10 = this.params.getCachedHA1();
            if (string10 == null) {
                string9 = string + ":" + string2 + ":";
                string8 = this.encode(string9, cArray, messageDigest);
                String string12 = string8 + ":" + string5 + ":" + string6;
                string10 = this.encode(string12, null, messageDigest);
                this.params.setCachedHA1(string10);
            }
        } else {
            String string13 = string + ":" + string2 + ":";
            string10 = this.encode(string13, cArray, messageDigest);
        }
        string9 = bl2 ? string3 + ":" + string4 : ":" + string4;
        string8 = this.encode(string9, null, messageDigest);
        String string14 = this.params.authQop() ? string10 + ":" + string5 + ":" + string7 + ":" + string6 + ":auth:" + string8 : string10 + ":" + string5 + ":" + string8;
        String string15 = this.encode(string14, null, messageDigest);
        return string15;
    }

    private String encode(String string, char[] cArray, MessageDigest messageDigest) {
        byte[] byArray;
        block5: {
            try {
                messageDigest.update(string.getBytes("ISO-8859-1"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError();
            }
        }
        if (cArray != null) {
            byArray = new byte[cArray.length];
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                byArray[i2] = (byte)cArray[i2];
            }
            messageDigest.update(byArray);
            Arrays.fill(byArray, (byte)0);
        }
        byArray = messageDigest.digest();
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i3 = 0; i3 < byArray.length; ++i3) {
            int n2 = byArray[i3] >>> 4 & 0xF;
            stringBuffer.append(charArray[n2]);
            n2 = byArray[i3] & 0xF;
            stringBuffer.append(charArray[n2]);
        }
        return stringBuffer.toString();
    }

    static class Parameters
    implements Serializable {
        private boolean serverQop = false;
        private String opaque = null;
        private String cnonce;
        private String nonce = null;
        private String algorithm = null;
        private int NCcount = 0;
        private String cachedHA1 = null;
        private boolean redoCachedHA1 = true;
        private static final int cnonceRepeat = 5;
        private static final int cnoncelen = 40;
        private static Random random = new Random();
        int cnonce_count = 0;

        Parameters() {
            this.setNewCnonce();
        }

        boolean authQop() {
            return this.serverQop;
        }

        synchronized void incrementNC() {
            ++this.NCcount;
        }

        synchronized int getNCCount() {
            return this.NCcount;
        }

        synchronized String getCnonce() {
            if (this.cnonce_count >= 5) {
                this.setNewCnonce();
            }
            ++this.cnonce_count;
            return this.cnonce;
        }

        synchronized void setNewCnonce() {
            byte[] byArray = new byte[20];
            char[] cArray = new char[40];
            random.nextBytes(byArray);
            for (int i2 = 0; i2 < 20; ++i2) {
                int n2 = byArray[i2] + 128;
                cArray[i2 * 2] = (char)(65 + n2 / 16);
                cArray[i2 * 2 + 1] = (char)(65 + n2 % 16);
            }
            this.cnonce = new String(cArray, 0, 40);
            this.cnonce_count = 0;
            this.redoCachedHA1 = true;
        }

        synchronized void setQop(String string) {
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                while (stringTokenizer.hasMoreTokens()) {
                    if (!stringTokenizer.nextToken().equalsIgnoreCase("auth")) continue;
                    this.serverQop = true;
                    return;
                }
            }
            this.serverQop = false;
        }

        synchronized String getOpaque() {
            return this.opaque;
        }

        synchronized void setOpaque(String string) {
            this.opaque = string;
        }

        synchronized String getNonce() {
            return this.nonce;
        }

        synchronized void setNonce(String string) {
            if (!string.equals(this.nonce)) {
                this.nonce = string;
                this.NCcount = 0;
                this.redoCachedHA1 = true;
            }
        }

        synchronized String getCachedHA1() {
            if (this.redoCachedHA1) {
                return null;
            }
            return this.cachedHA1;
        }

        synchronized void setCachedHA1(String string) {
            this.cachedHA1 = string;
            this.redoCachedHA1 = false;
        }

        synchronized String getAlgorithm() {
            return this.algorithm;
        }

        synchronized void setAlgorithm(String string) {
            this.algorithm = string;
        }
    }
}

