/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvminstr;

import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.agent.SnmpMib;
import com.sun.jmx.snmp.agent.SnmpStandardObjectServer;
import java.io.Serializable;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import sun.management.snmp.jvminstr.JVM_MANAGEMENT_MIB_IMPL;
import sun.management.snmp.jvminstr.JvmMemManagerTableMetaImpl;
import sun.management.snmp.jvminstr.JvmMemMgrPoolRelEntryImpl;
import sun.management.snmp.jvminstr.JvmMemPoolTableMetaImpl;
import sun.management.snmp.jvmmib.JvmMemMgrPoolRelTableMeta;
import sun.management.snmp.util.JvmContextFactory;
import sun.management.snmp.util.MibLogger;
import sun.management.snmp.util.SnmpCachedData;
import sun.management.snmp.util.SnmpTableCache;
import sun.management.snmp.util.SnmpTableHandler;

public class JvmMemMgrPoolRelTableMetaImpl
extends JvmMemMgrPoolRelTableMeta
implements Serializable {
    protected SnmpTableCache cache;
    private transient JvmMemManagerTableMetaImpl managers = null;
    private transient JvmMemPoolTableMetaImpl pools = null;
    static final MibLogger log = new MibLogger(JvmMemMgrPoolRelTableMetaImpl.class);

    public JvmMemMgrPoolRelTableMetaImpl(SnmpMib snmpMib, SnmpStandardObjectServer snmpStandardObjectServer) {
        super(snmpMib, snmpStandardObjectServer);
        this.cache = new JvmMemMgrPoolRelTableCache(this, ((JVM_MANAGEMENT_MIB_IMPL)snmpMib).validity());
    }

    private final JvmMemManagerTableMetaImpl getManagers(SnmpMib snmpMib) {
        if (this.managers == null) {
            this.managers = (JvmMemManagerTableMetaImpl)snmpMib.getRegisteredTableMeta("JvmMemManagerTable");
        }
        return this.managers;
    }

    private final JvmMemPoolTableMetaImpl getPools(SnmpMib snmpMib) {
        if (this.pools == null) {
            this.pools = (JvmMemPoolTableMetaImpl)snmpMib.getRegisteredTableMeta("JvmMemPoolTable");
        }
        return this.pools;
    }

    protected SnmpTableHandler getManagerHandler(Object object) {
        JvmMemManagerTableMetaImpl jvmMemManagerTableMetaImpl = this.getManagers(this.theMib);
        return jvmMemManagerTableMetaImpl.getHandler(object);
    }

    protected SnmpTableHandler getPoolHandler(Object object) {
        JvmMemPoolTableMetaImpl jvmMemPoolTableMetaImpl = this.getPools(this.theMib);
        return jvmMemPoolTableMetaImpl.getHandler(object);
    }

    protected SnmpOid getNextOid(Object object) throws SnmpStatusException {
        return this.getNextOid(null, object);
    }

    protected SnmpOid getNextOid(SnmpOid snmpOid, Object object) throws SnmpStatusException {
        SnmpTableHandler snmpTableHandler;
        boolean bl2 = log.isDebugOn();
        if (bl2) {
            log.debug("getNextOid", "previous=" + snmpOid);
        }
        if ((snmpTableHandler = this.getHandler(object)) == null) {
            if (bl2) {
                log.debug("getNextOid", "handler is null!");
            }
            throw new SnmpStatusException(224);
        }
        SnmpOid snmpOid2 = snmpTableHandler.getNext(snmpOid);
        if (bl2) {
            log.debug("getNextOid", "next=" + snmpOid2);
        }
        if (snmpOid2 == null) {
            throw new SnmpStatusException(224);
        }
        return snmpOid2;
    }

    protected boolean contains(SnmpOid snmpOid, Object object) {
        SnmpTableHandler snmpTableHandler = this.getHandler(object);
        if (snmpTableHandler == null) {
            return false;
        }
        return snmpTableHandler.contains(snmpOid);
    }

    public Object getEntry(SnmpOid snmpOid) throws SnmpStatusException {
        Object object;
        String string;
        if (snmpOid == null || snmpOid.getLength() < 2) {
            throw new SnmpStatusException(224);
        }
        Map map = JvmContextFactory.getUserData();
        long l2 = snmpOid.getOidArc(0);
        long l3 = snmpOid.getOidArc(1);
        String string2 = string = map == null ? null : "JvmMemMgrPoolRelTable.entry." + l2 + "." + l3;
        if (map != null && (object = map.get(string)) != null) {
            return object;
        }
        object = this.getHandler(map);
        if (object == null) {
            throw new SnmpStatusException(224);
        }
        Object object2 = object.getData(snmpOid);
        if (!(object2 instanceof JvmMemMgrPoolRelEntryImpl)) {
            throw new SnmpStatusException(224);
        }
        JvmMemMgrPoolRelEntryImpl jvmMemMgrPoolRelEntryImpl = (JvmMemMgrPoolRelEntryImpl)object2;
        if (map != null && jvmMemMgrPoolRelEntryImpl != null) {
            map.put(string, jvmMemMgrPoolRelEntryImpl);
        }
        return jvmMemMgrPoolRelEntryImpl;
    }

    protected SnmpTableHandler getHandler(Object object) {
        SnmpTableHandler snmpTableHandler;
        Map map = object instanceof Map ? (Map)object : null;
        if (map != null && (snmpTableHandler = (SnmpTableHandler)map.get("JvmMemMgrPoolRelTable.handler")) != null) {
            return snmpTableHandler;
        }
        snmpTableHandler = this.cache.getTableHandler();
        if (map != null && snmpTableHandler != null) {
            map.put("JvmMemMgrPoolRelTable.handler", snmpTableHandler);
        }
        return snmpTableHandler;
    }

    private static class JvmMemMgrPoolRelTableCache
    extends SnmpTableCache {
        private final JvmMemMgrPoolRelTableMetaImpl meta;

        JvmMemMgrPoolRelTableCache(JvmMemMgrPoolRelTableMetaImpl jvmMemMgrPoolRelTableMetaImpl, long l2) {
            this.validity = l2;
            this.meta = jvmMemMgrPoolRelTableMetaImpl;
        }

        public SnmpTableHandler getTableHandler() {
            Map map = JvmContextFactory.getUserData();
            return this.getTableDatas(map);
        }

        private static Map buildPoolIndexMap(SnmpTableHandler snmpTableHandler) {
            if (snmpTableHandler instanceof SnmpCachedData) {
                return JvmMemMgrPoolRelTableCache.buildPoolIndexMap((SnmpCachedData)snmpTableHandler);
            }
            HashMap<String, SnmpOid> hashMap = new HashMap<String, SnmpOid>();
            SnmpOid snmpOid = null;
            while ((snmpOid = snmpTableHandler.getNext(snmpOid)) != null) {
                String string;
                MemoryPoolMXBean memoryPoolMXBean = (MemoryPoolMXBean)snmpTableHandler.getData(snmpOid);
                if (memoryPoolMXBean == null || (string = memoryPoolMXBean.getName()) == null) continue;
                hashMap.put(string, snmpOid);
            }
            return hashMap;
        }

        private static Map buildPoolIndexMap(SnmpCachedData snmpCachedData) {
            if (snmpCachedData == null) {
                return Collections.EMPTY_MAP;
            }
            SnmpOid[] snmpOidArray = snmpCachedData.indexes;
            Object[] objectArray = snmpCachedData.datas;
            int n2 = snmpOidArray.length;
            HashMap<String, SnmpOid> hashMap = new HashMap<String, SnmpOid>(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                String string;
                MemoryPoolMXBean memoryPoolMXBean;
                SnmpOid snmpOid = snmpOidArray[i2];
                if (snmpOid == null || (memoryPoolMXBean = (MemoryPoolMXBean)objectArray[i2]) == null || (string = memoryPoolMXBean.getName()) == null) continue;
                hashMap.put(string, snmpOid);
            }
            return hashMap;
        }

        protected SnmpCachedData updateCachedDatas(Object object) {
            SnmpTableHandler snmpTableHandler = this.meta.getManagerHandler(object);
            SnmpTableHandler snmpTableHandler2 = this.meta.getPoolHandler(object);
            long l2 = System.currentTimeMillis();
            Map map = JvmMemMgrPoolRelTableCache.buildPoolIndexMap(snmpTableHandler2);
            TreeMap treeMap = new TreeMap(SnmpCachedData.oidComparator);
            this.updateTreeMap(treeMap, object, snmpTableHandler, snmpTableHandler2, map);
            return new SnmpCachedData(l2, treeMap);
        }

        protected String[] getMemoryPools(Object object, MemoryManagerMXBean memoryManagerMXBean, long l2) {
            String string = "JvmMemManager." + l2 + ".getMemoryPools";
            String[] stringArray = null;
            if (object instanceof Map && (stringArray = (String[])((Map)object).get(string)) != null) {
                return stringArray;
            }
            if (memoryManagerMXBean != null) {
                stringArray = memoryManagerMXBean.getMemoryPoolNames();
            }
            if (stringArray != null && object instanceof Map) {
                ((Map)object).put(string, stringArray);
            }
            return stringArray;
        }

        protected void updateTreeMap(TreeMap treeMap, Object object, MemoryManagerMXBean memoryManagerMXBean, SnmpOid snmpOid, Map map) {
            long l2;
            try {
                l2 = snmpOid.getOidArc(0);
            }
            catch (SnmpStatusException snmpStatusException) {
                log.debug("updateTreeMap", "Bad MemoryManager OID index: " + snmpOid);
                log.debug("updateTreeMap", snmpStatusException);
                return;
            }
            String[] stringArray = this.getMemoryPools(object, memoryManagerMXBean, l2);
            if (stringArray == null || stringArray.length < 1) {
                return;
            }
            String string = memoryManagerMXBean.getName();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                long l3;
                SnmpOid snmpOid2;
                String string2 = stringArray[i2];
                if (string2 == null || (snmpOid2 = (SnmpOid)map.get(string2)) == null) continue;
                try {
                    l3 = snmpOid2.getOidArc(0);
                }
                catch (SnmpStatusException snmpStatusException) {
                    log.debug("updateTreeMap", "Bad MemoryPool OID index: " + snmpOid2);
                    log.debug("updateTreeMap", snmpStatusException);
                    continue;
                }
                long[] lArray = new long[]{l2, l3};
                SnmpOid snmpOid3 = new SnmpOid(lArray);
                treeMap.put(snmpOid3, new JvmMemMgrPoolRelEntryImpl(string, string2, (int)l2, (int)l3));
            }
        }

        protected void updateTreeMap(TreeMap treeMap, Object object, SnmpTableHandler snmpTableHandler, SnmpTableHandler snmpTableHandler2, Map map) {
            if (snmpTableHandler instanceof SnmpCachedData) {
                this.updateTreeMap(treeMap, object, (SnmpCachedData)snmpTableHandler, snmpTableHandler2, map);
                return;
            }
            SnmpOid snmpOid = null;
            while ((snmpOid = snmpTableHandler.getNext(snmpOid)) != null) {
                MemoryManagerMXBean memoryManagerMXBean = (MemoryManagerMXBean)snmpTableHandler.getData(snmpOid);
                if (memoryManagerMXBean == null) continue;
                this.updateTreeMap(treeMap, object, memoryManagerMXBean, snmpOid, map);
            }
        }

        protected void updateTreeMap(TreeMap treeMap, Object object, SnmpCachedData snmpCachedData, SnmpTableHandler snmpTableHandler, Map map) {
            SnmpOid[] snmpOidArray = snmpCachedData.indexes;
            Object[] objectArray = snmpCachedData.datas;
            int n2 = snmpOidArray.length;
            for (int i2 = n2 - 1; i2 > -1; --i2) {
                MemoryManagerMXBean memoryManagerMXBean = (MemoryManagerMXBean)objectArray[i2];
                if (memoryManagerMXBean == null) continue;
                this.updateTreeMap(treeMap, object, memoryManagerMXBean, snmpOidArray[i2], map);
            }
        }
    }
}

