/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.rtf;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabStop;
import javax.swing.text.rtf.MockAttributeSet;
import javax.swing.text.rtf.RTFAttribute;
import javax.swing.text.rtf.RTFAttributes;
import javax.swing.text.rtf.RTFParser;

class RTFReader
extends RTFParser {
    StyledDocument target;
    Dictionary parserState;
    Destination rtfDestination;
    MutableAttributeSet documentAttributes;
    Dictionary fontTable;
    Color[] colorTable;
    Style[] characterStyles;
    Style[] paragraphStyles;
    Style[] sectionStyles;
    int rtfversion;
    boolean ignoreGroupIfUnknownKeyword;
    int skippingCharacters;
    private static Dictionary straightforwardAttributes = RTFAttributes.attributesByKeyword();
    private MockAttributeSet mockery;
    static Dictionary textKeywords = null;
    static final String TabAlignmentKey = "tab_alignment";
    static final String TabLeaderKey = "tab_leader";
    static Dictionary characterSets;
    static boolean useNeXTForAnsi;

    public RTFReader(StyledDocument styledDocument) {
        this.target = styledDocument;
        this.parserState = new Hashtable();
        this.fontTable = new Hashtable();
        this.rtfversion = -1;
        this.mockery = new MockAttributeSet();
        this.documentAttributes = new SimpleAttributeSet();
    }

    public void handleBinaryBlob(byte[] byArray) {
        if (this.skippingCharacters > 0) {
            --this.skippingCharacters;
            return;
        }
    }

    public void handleText(String string) {
        if (this.skippingCharacters > 0) {
            if (this.skippingCharacters >= string.length()) {
                this.skippingCharacters -= string.length();
                return;
            }
            string = string.substring(this.skippingCharacters);
            this.skippingCharacters = 0;
        }
        if (this.rtfDestination != null) {
            this.rtfDestination.handleText(string);
            return;
        }
        this.warning("Text with no destination. oops.");
    }

    Color defaultColor() {
        return Color.black;
    }

    public void begingroup() {
        Object v2;
        if (this.skippingCharacters > 0) {
            this.skippingCharacters = 0;
        }
        if ((v2 = this.parserState.get("_savedState")) != null) {
            this.parserState.remove("_savedState");
        }
        Dictionary dictionary = (Dictionary)((Hashtable)this.parserState).clone();
        if (v2 != null) {
            dictionary.put("_savedState", v2);
        }
        this.parserState.put("_savedState", dictionary);
        if (this.rtfDestination != null) {
            this.rtfDestination.begingroup();
        }
    }

    public void endgroup() {
        Dictionary dictionary;
        Destination destination;
        if (this.skippingCharacters > 0) {
            this.skippingCharacters = 0;
        }
        if ((destination = (Destination)(dictionary = (Dictionary)this.parserState.get("_savedState")).get("dst")) != this.rtfDestination) {
            this.rtfDestination.close();
            this.rtfDestination = destination;
        }
        Dictionary dictionary2 = this.parserState;
        this.parserState = dictionary;
        if (this.rtfDestination != null) {
            this.rtfDestination.endgroup(dictionary2);
        }
    }

    protected void setRTFDestination(Destination destination) {
        Dictionary dictionary = (Dictionary)this.parserState.get("_savedState");
        if (dictionary != null && this.rtfDestination != dictionary.get("dst")) {
            this.warning("Warning, RTF destination overridden, invalid RTF.");
            this.rtfDestination.close();
        }
        this.rtfDestination = destination;
        this.parserState.put("dst", this.rtfDestination);
    }

    public void close() throws IOException {
        Enumeration<?> enumeration = this.documentAttributes.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            this.target.putProperty(obj, this.documentAttributes.getAttribute((String)obj));
        }
        this.warning("RTF filter done.");
        super.close();
    }

    public boolean handleKeyword(String string) {
        boolean bl2 = this.ignoreGroupIfUnknownKeyword;
        if (this.skippingCharacters > 0) {
            --this.skippingCharacters;
            return true;
        }
        this.ignoreGroupIfUnknownKeyword = false;
        Object v2 = textKeywords.get(string);
        if (v2 != null) {
            this.handleText((String)v2);
            return true;
        }
        if (string.equals("fonttbl")) {
            this.setRTFDestination(new FonttblDestination());
            return true;
        }
        if (string.equals("colortbl")) {
            this.setRTFDestination(new ColortblDestination());
            return true;
        }
        if (string.equals("stylesheet")) {
            this.setRTFDestination(new StylesheetDestination());
            return true;
        }
        if (string.equals("info")) {
            this.setRTFDestination(new InfoDestination());
            return false;
        }
        if (string.equals("mac")) {
            this.setCharacterSet("mac");
            return true;
        }
        if (string.equals("ansi")) {
            if (useNeXTForAnsi) {
                this.setCharacterSet("NeXT");
            } else {
                this.setCharacterSet("ansi");
            }
            return true;
        }
        if (string.equals("next")) {
            this.setCharacterSet("NeXT");
            return true;
        }
        if (string.equals("pc")) {
            this.setCharacterSet("cpg437");
            return true;
        }
        if (string.equals("pca")) {
            this.setCharacterSet("cpg850");
            return true;
        }
        if (string.equals("*")) {
            this.ignoreGroupIfUnknownKeyword = true;
            return true;
        }
        if (this.rtfDestination != null && this.rtfDestination.handleKeyword(string)) {
            return true;
        }
        if (string.equals("aftncn") || string.equals("aftnsep") || string.equals("aftnsepc") || string.equals("annotation") || string.equals("atnauthor") || string.equals("atnicn") || string.equals("atnid") || string.equals("atnref") || string.equals("atntime") || string.equals("atrfend") || string.equals("atrfstart") || string.equals("bkmkend") || string.equals("bkmkstart") || string.equals("datafield") || string.equals("do") || string.equals("dptxbxtext") || string.equals("falt") || string.equals("field") || string.equals("file") || string.equals("filetbl") || string.equals("fname") || string.equals("fontemb") || string.equals("fontfile") || string.equals("footer") || string.equals("footerf") || string.equals("footerl") || string.equals("footerr") || string.equals("footnote") || string.equals("ftncn") || string.equals("ftnsep") || string.equals("ftnsepc") || string.equals("header") || string.equals("headerf") || string.equals("headerl") || string.equals("headerr") || string.equals("keycode") || string.equals("nextfile") || string.equals("object") || string.equals("pict") || string.equals("pn") || string.equals("pnseclvl") || string.equals("pntxtb") || string.equals("pntxta") || string.equals("revtbl") || string.equals("rxe") || string.equals("tc") || string.equals("template") || string.equals("txe") || string.equals("xe")) {
            bl2 = true;
        }
        if (bl2) {
            this.setRTFDestination(new DiscardingDestination());
        }
        return false;
    }

    public boolean handleKeyword(String string, int n2) {
        boolean bl2 = this.ignoreGroupIfUnknownKeyword;
        if (this.skippingCharacters > 0) {
            --this.skippingCharacters;
            return true;
        }
        this.ignoreGroupIfUnknownKeyword = false;
        if (string.equals("uc")) {
            this.parserState.put("UnicodeSkip", n2);
            return true;
        }
        if (string.equals("u")) {
            if (n2 < 0) {
                n2 += 65536;
            }
            this.handleText((char)n2);
            Number number = (Number)this.parserState.get("UnicodeSkip");
            this.skippingCharacters = number != null ? number.intValue() : 1;
            return true;
        }
        if (string.equals("rtf")) {
            this.rtfversion = n2;
            this.setRTFDestination(new DocumentDestination());
            return true;
        }
        if (string.startsWith("NeXT") || string.equals("private")) {
            bl2 = true;
        }
        if (this.rtfDestination != null && this.rtfDestination.handleKeyword(string, n2)) {
            return true;
        }
        if (bl2) {
            this.setRTFDestination(new DiscardingDestination());
        }
        return false;
    }

    private void setTargetAttribute(String string, Object object) {
    }

    public void setCharacterSet(String string) {
        Object object;
        try {
            object = RTFReader.getCharacterSet(string);
        }
        catch (Exception exception) {
            this.warning("Exception loading RTF character set \"" + string + "\": " + exception);
            object = null;
        }
        if (object != null) {
            this.translationTable = (char[])object;
        } else {
            this.warning("Unknown RTF character set \"" + string + "\"");
            if (!string.equals("ansi")) {
                try {
                    this.translationTable = (char[])RTFReader.getCharacterSet("ansi");
                }
                catch (IOException iOException) {
                    throw new InternalError("RTFReader: Unable to find character set resources (" + iOException + ")");
                }
            }
        }
        this.setTargetAttribute("rtfCharacterSet", string);
    }

    public static void defineCharacterSet(String string, char[] cArray) {
        if (cArray.length < 256) {
            throw new IllegalArgumentException("Translation table must have 256 entries.");
        }
        characterSets.put(string, cArray);
    }

    public static Object getCharacterSet(final String string) throws IOException {
        char[] cArray = (char[])characterSets.get(string);
        if (cArray == null) {
            InputStream inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return RTFReader.class.getResourceAsStream("charsets/" + string + ".txt");
                }
            });
            cArray = RTFReader.readCharset(inputStream);
            RTFReader.defineCharacterSet(string, cArray);
        }
        return cArray;
    }

    static char[] readCharset(InputStream inputStream) throws IOException {
        char[] cArray = new char[256];
        StreamTokenizer streamTokenizer = new StreamTokenizer(new BufferedReader(new InputStreamReader(inputStream, "ISO-8859-1")));
        streamTokenizer.eolIsSignificant(false);
        streamTokenizer.commentChar(35);
        streamTokenizer.slashSlashComments(true);
        streamTokenizer.slashStarComments(true);
        for (int i2 = 0; i2 < 256; ++i2) {
            int n2;
            try {
                n2 = streamTokenizer.nextToken();
            }
            catch (Exception exception) {
                throw new IOException("Unable to read from character set file (" + exception + ")");
            }
            if (n2 != -2) {
                throw new IOException("Unexpected token in character set file");
            }
            cArray[i2] = (char)streamTokenizer.nval;
        }
        return cArray;
    }

    static char[] readCharset(URL uRL) throws IOException {
        return RTFReader.readCharset(uRL.openStream());
    }

    static {
        textKeywords = new Hashtable();
        textKeywords.put("\\", "\\");
        textKeywords.put("{", "{");
        textKeywords.put("}", "}");
        textKeywords.put(" ", "\u00a0");
        textKeywords.put("~", "\u00a0");
        textKeywords.put("_", "\u2011");
        textKeywords.put("bullet", "\u2022");
        textKeywords.put("emdash", "\u2014");
        textKeywords.put("emspace", "\u2003");
        textKeywords.put("endash", "\u2013");
        textKeywords.put("enspace", "\u2002");
        textKeywords.put("ldblquote", "\u201c");
        textKeywords.put("lquote", "\u2018");
        textKeywords.put("ltrmark", "\u200e");
        textKeywords.put("rdblquote", "\u201d");
        textKeywords.put("rquote", "\u2019");
        textKeywords.put("rtlmark", "\u200f");
        textKeywords.put("tab", "\t");
        textKeywords.put("zwj", "\u200d");
        textKeywords.put("zwnj", "\u200c");
        textKeywords.put("-", "\u2027");
        useNeXTForAnsi = false;
        characterSets = new Hashtable();
    }

    abstract class AttributeTrackingDestination
    implements Destination {
        MutableAttributeSet characterAttributes = this.rootCharacterAttributes();
        MutableAttributeSet paragraphAttributes;
        MutableAttributeSet sectionAttributes;

        public AttributeTrackingDestination() {
            RTFReader.this.parserState.put("chr", this.characterAttributes);
            this.paragraphAttributes = this.rootParagraphAttributes();
            RTFReader.this.parserState.put("pgf", this.paragraphAttributes);
            this.sectionAttributes = this.rootSectionAttributes();
            RTFReader.this.parserState.put("sec", this.sectionAttributes);
        }

        public abstract void handleText(String var1);

        public void handleBinaryBlob(byte[] byArray) {
            RTFReader.this.warning("Unexpected binary data in RTF file.");
        }

        public void begingroup() {
            MutableAttributeSet mutableAttributeSet = this.currentTextAttributes();
            MutableAttributeSet mutableAttributeSet2 = this.currentParagraphAttributes();
            AttributeSet attributeSet = this.currentSectionAttributes();
            this.characterAttributes = new SimpleAttributeSet();
            this.characterAttributes.addAttributes(mutableAttributeSet);
            RTFReader.this.parserState.put("chr", this.characterAttributes);
            this.paragraphAttributes = new SimpleAttributeSet();
            this.paragraphAttributes.addAttributes(mutableAttributeSet2);
            RTFReader.this.parserState.put("pgf", this.paragraphAttributes);
            this.sectionAttributes = new SimpleAttributeSet();
            this.sectionAttributes.addAttributes(attributeSet);
            RTFReader.this.parserState.put("sec", this.sectionAttributes);
        }

        public void endgroup(Dictionary dictionary) {
            this.characterAttributes = (MutableAttributeSet)RTFReader.this.parserState.get("chr");
            this.paragraphAttributes = (MutableAttributeSet)RTFReader.this.parserState.get("pgf");
            this.sectionAttributes = (MutableAttributeSet)RTFReader.this.parserState.get("sec");
        }

        public void close() {
        }

        public boolean handleKeyword(String string) {
            if (string.equals("ulnone")) {
                return this.handleKeyword("ul", 0);
            }
            Object v2 = straightforwardAttributes.get(string);
            if (v2 != null) {
                boolean bl2;
                RTFAttribute rTFAttribute = (RTFAttribute)v2;
                switch (rTFAttribute.domain()) {
                    case 0: {
                        bl2 = rTFAttribute.set(this.characterAttributes);
                        break;
                    }
                    case 1: {
                        bl2 = rTFAttribute.set(this.paragraphAttributes);
                        break;
                    }
                    case 2: {
                        bl2 = rTFAttribute.set(this.sectionAttributes);
                        break;
                    }
                    case 4: {
                        ((RTFReader)RTFReader.this).mockery.backing = RTFReader.this.parserState;
                        bl2 = rTFAttribute.set(RTFReader.this.mockery);
                        ((RTFReader)RTFReader.this).mockery.backing = null;
                        break;
                    }
                    case 3: {
                        bl2 = rTFAttribute.set(RTFReader.this.documentAttributes);
                        break;
                    }
                    default: {
                        bl2 = false;
                    }
                }
                if (bl2) {
                    return true;
                }
            }
            if (string.equals("plain")) {
                this.resetCharacterAttributes();
                return true;
            }
            if (string.equals("pard")) {
                this.resetParagraphAttributes();
                return true;
            }
            if (string.equals("sectd")) {
                this.resetSectionAttributes();
                return true;
            }
            return false;
        }

        public boolean handleKeyword(String string, int n2) {
            int n3;
            boolean bl2;
            boolean bl3 = bl2 = n2 != 0;
            if (string.equals("fc")) {
                string = "cf";
            }
            if (string.equals("f")) {
                RTFReader.this.parserState.put(string, n2);
                return true;
            }
            if (string.equals("cf")) {
                RTFReader.this.parserState.put(string, n2);
                return true;
            }
            Object v2 = straightforwardAttributes.get(string);
            if (v2 != null) {
                RTFAttribute rTFAttribute = (RTFAttribute)v2;
                switch (rTFAttribute.domain()) {
                    case 0: {
                        n3 = rTFAttribute.set(this.characterAttributes, n2);
                        break;
                    }
                    case 1: {
                        n3 = rTFAttribute.set(this.paragraphAttributes, n2);
                        break;
                    }
                    case 2: {
                        n3 = rTFAttribute.set(this.sectionAttributes, n2);
                        break;
                    }
                    case 4: {
                        ((RTFReader)RTFReader.this).mockery.backing = RTFReader.this.parserState;
                        n3 = rTFAttribute.set(RTFReader.this.mockery, n2);
                        ((RTFReader)RTFReader.this).mockery.backing = null;
                        break;
                    }
                    case 3: {
                        n3 = rTFAttribute.set(RTFReader.this.documentAttributes, n2);
                        break;
                    }
                    default: {
                        n3 = 0;
                    }
                }
                if (n3 != 0) {
                    return true;
                }
            }
            if (string.equals("fs")) {
                StyleConstants.setFontSize(this.characterAttributes, n2 / 2);
                return true;
            }
            if (string.equals("sl")) {
                if (n2 == 1000) {
                    this.characterAttributes.removeAttribute(StyleConstants.LineSpacing);
                } else {
                    StyleConstants.setLineSpacing(this.characterAttributes, (float)n2 / 20.0f);
                }
                return true;
            }
            if (string.equals("tx") || string.equals("tb")) {
                Integer n4;
                float f2 = (float)n2 / 20.0f;
                int n5 = 0;
                Number number = (Number)RTFReader.this.parserState.get(RTFReader.TabAlignmentKey);
                if (number != null) {
                    n5 = number.intValue();
                }
                n3 = 0;
                number = (Number)RTFReader.this.parserState.get(RTFReader.TabLeaderKey);
                if (number != null) {
                    n3 = number.intValue();
                }
                if (string.equals("tb")) {
                    n5 = 5;
                }
                RTFReader.this.parserState.remove(RTFReader.TabAlignmentKey);
                RTFReader.this.parserState.remove(RTFReader.TabLeaderKey);
                TabStop tabStop = new TabStop(f2, n5, n3);
                Hashtable<Object, Serializable> hashtable = (Hashtable<Object, Serializable>)RTFReader.this.parserState.get("_tabs");
                if (hashtable == null) {
                    hashtable = new Hashtable<Object, Serializable>();
                    RTFReader.this.parserState.put("_tabs", hashtable);
                    n4 = 1;
                } else {
                    n4 = (Integer)((Dictionary)hashtable).get("stop count");
                    n4 = 1 + n4;
                }
                ((Dictionary)hashtable).put(n4, tabStop);
                ((Dictionary)hashtable).put("stop count", n4);
                RTFReader.this.parserState.remove("_tabs_immutable");
                return true;
            }
            if (string.equals("s") && RTFReader.this.paragraphStyles != null) {
                RTFReader.this.parserState.put("paragraphStyle", RTFReader.this.paragraphStyles[n2]);
                return true;
            }
            if (string.equals("cs") && RTFReader.this.characterStyles != null) {
                RTFReader.this.parserState.put("characterStyle", RTFReader.this.characterStyles[n2]);
                return true;
            }
            if (string.equals("ds") && RTFReader.this.sectionStyles != null) {
                RTFReader.this.parserState.put("sectionStyle", RTFReader.this.sectionStyles[n2]);
                return true;
            }
            return false;
        }

        protected MutableAttributeSet rootCharacterAttributes() {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setItalic(simpleAttributeSet, false);
            StyleConstants.setBold(simpleAttributeSet, false);
            StyleConstants.setUnderline(simpleAttributeSet, false);
            StyleConstants.setForeground(simpleAttributeSet, RTFReader.this.defaultColor());
            return simpleAttributeSet;
        }

        protected MutableAttributeSet rootParagraphAttributes() {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setLeftIndent(simpleAttributeSet, 0.0f);
            StyleConstants.setRightIndent(simpleAttributeSet, 0.0f);
            StyleConstants.setFirstLineIndent(simpleAttributeSet, 0.0f);
            simpleAttributeSet.setResolveParent(RTFReader.this.target.getStyle("default"));
            return simpleAttributeSet;
        }

        protected MutableAttributeSet rootSectionAttributes() {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            return simpleAttributeSet;
        }

        MutableAttributeSet currentTextAttributes() {
            Object object;
            Integer n2;
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(this.characterAttributes);
            Integer n3 = (Integer)RTFReader.this.parserState.get("f");
            String string = n3 != null ? (String)RTFReader.this.fontTable.get(n3) : null;
            if (string != null) {
                StyleConstants.setFontFamily(simpleAttributeSet, string);
            } else {
                simpleAttributeSet.removeAttribute(StyleConstants.FontFamily);
            }
            if (RTFReader.this.colorTable != null) {
                n2 = (Integer)RTFReader.this.parserState.get("cf");
                if (n2 != null) {
                    object = RTFReader.this.colorTable[n2];
                    StyleConstants.setForeground(simpleAttributeSet, (Color)object);
                } else {
                    simpleAttributeSet.removeAttribute(StyleConstants.Foreground);
                }
            }
            if (RTFReader.this.colorTable != null) {
                n2 = (Integer)RTFReader.this.parserState.get("cb");
                if (n2 != null) {
                    object = RTFReader.this.colorTable[n2];
                    simpleAttributeSet.addAttribute(StyleConstants.Background, object);
                } else {
                    simpleAttributeSet.removeAttribute(StyleConstants.Background);
                }
            }
            if ((object = (Style)RTFReader.this.parserState.get("characterStyle")) != null) {
                simpleAttributeSet.setResolveParent((AttributeSet)object);
            }
            return simpleAttributeSet;
        }

        MutableAttributeSet currentParagraphAttributes() {
            Object object;
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(this.paragraphAttributes);
            TabStop[] tabStopArray = (TabStop[])RTFReader.this.parserState.get("_tabs_immutable");
            if (tabStopArray == null && (object = (Dictionary)RTFReader.this.parserState.get("_tabs")) != null) {
                int n2 = (Integer)((Dictionary)object).get("stop count");
                tabStopArray = new TabStop[n2];
                for (int i2 = 1; i2 <= n2; ++i2) {
                    tabStopArray[i2 - 1] = (TabStop)((Dictionary)object).get(i2);
                }
                RTFReader.this.parserState.put("_tabs_immutable", tabStopArray);
            }
            if (tabStopArray != null) {
                simpleAttributeSet.addAttribute("tabs", tabStopArray);
            }
            if ((object = (Style)RTFReader.this.parserState.get("paragraphStyle")) != null) {
                simpleAttributeSet.setResolveParent((AttributeSet)object);
            }
            return simpleAttributeSet;
        }

        public AttributeSet currentSectionAttributes() {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(this.sectionAttributes);
            Style style = (Style)RTFReader.this.parserState.get("sectionStyle");
            if (style != null) {
                simpleAttributeSet.setResolveParent(style);
            }
            return simpleAttributeSet;
        }

        protected void resetCharacterAttributes() {
            this.handleKeyword("f", 0);
            this.handleKeyword("cf", 0);
            this.handleKeyword("fs", 24);
            Enumeration enumeration = straightforwardAttributes.elements();
            while (enumeration.hasMoreElements()) {
                RTFAttribute rTFAttribute = (RTFAttribute)enumeration.nextElement();
                if (rTFAttribute.domain() != 0) continue;
                rTFAttribute.setDefault(this.characterAttributes);
            }
            this.handleKeyword("sl", 1000);
            RTFReader.this.parserState.remove("characterStyle");
        }

        protected void resetParagraphAttributes() {
            RTFReader.this.parserState.remove("_tabs");
            RTFReader.this.parserState.remove("_tabs_immutable");
            RTFReader.this.parserState.remove("paragraphStyle");
            StyleConstants.setAlignment(this.paragraphAttributes, 0);
            Enumeration enumeration = straightforwardAttributes.elements();
            while (enumeration.hasMoreElements()) {
                RTFAttribute rTFAttribute = (RTFAttribute)enumeration.nextElement();
                if (rTFAttribute.domain() != 1) continue;
                rTFAttribute.setDefault(this.characterAttributes);
            }
        }

        protected void resetSectionAttributes() {
            Enumeration enumeration = straightforwardAttributes.elements();
            while (enumeration.hasMoreElements()) {
                RTFAttribute rTFAttribute = (RTFAttribute)enumeration.nextElement();
                if (rTFAttribute.domain() != 2) continue;
                rTFAttribute.setDefault(this.characterAttributes);
            }
            RTFReader.this.parserState.remove("sectionStyle");
        }
    }

    class ColortblDestination
    implements Destination {
        int red = 0;
        int green = 0;
        int blue = 0;
        Vector proTemTable = new Vector();

        public void handleText(String string) {
            int n2 = 0;
            for (n2 = 0; n2 < string.length(); ++n2) {
                if (string.charAt(n2) != ';') continue;
                Color color = new Color(this.red, this.green, this.blue);
                this.proTemTable.addElement(color);
            }
        }

        public void close() {
            int n2 = this.proTemTable.size();
            RTFReader.this.warning("Done reading color table, " + n2 + " entries.");
            RTFReader.this.colorTable = new Color[n2];
            this.proTemTable.copyInto(RTFReader.this.colorTable);
        }

        public boolean handleKeyword(String string, int n2) {
            if (string.equals("red")) {
                this.red = n2;
            } else if (string.equals("green")) {
                this.green = n2;
            } else if (string.equals("blue")) {
                this.blue = n2;
            } else {
                return false;
            }
            return true;
        }

        public boolean handleKeyword(String string) {
            return false;
        }

        public void begingroup() {
        }

        public void endgroup(Dictionary dictionary) {
        }

        public void handleBinaryBlob(byte[] byArray) {
        }
    }

    static interface Destination {
        public void handleBinaryBlob(byte[] var1);

        public void handleText(String var1);

        public boolean handleKeyword(String var1);

        public boolean handleKeyword(String var1, int var2);

        public void begingroup();

        public void endgroup(Dictionary var1);

        public void close();
    }

    class DiscardingDestination
    implements Destination {
        DiscardingDestination() {
        }

        public void handleBinaryBlob(byte[] byArray) {
        }

        public void handleText(String string) {
        }

        public boolean handleKeyword(String string) {
            return true;
        }

        public boolean handleKeyword(String string, int n2) {
            return true;
        }

        public void begingroup() {
        }

        public void endgroup(Dictionary dictionary) {
        }

        public void close() {
        }
    }

    class DocumentDestination
    extends TextHandlingDestination
    implements Destination {
        DocumentDestination() {
        }

        public void deliverText(String string, AttributeSet attributeSet) {
            try {
                RTFReader.this.target.insertString(RTFReader.this.target.getLength(), string, this.currentTextAttributes());
            }
            catch (BadLocationException badLocationException) {
                throw new InternalError(badLocationException.getMessage());
            }
        }

        public void finishParagraph(AttributeSet attributeSet, AttributeSet attributeSet2) {
            int n2 = RTFReader.this.target.getLength();
            try {
                RTFReader.this.target.insertString(n2, "\n", attributeSet2);
                RTFReader.this.target.setParagraphAttributes(n2, 1, attributeSet, true);
            }
            catch (BadLocationException badLocationException) {
                throw new InternalError(badLocationException.getMessage());
            }
        }

        public void endSection() {
        }
    }

    class FonttblDestination
    implements Destination {
        int nextFontNumber;
        Object fontNumberKey = null;
        String nextFontFamily;

        FonttblDestination() {
        }

        public void handleBinaryBlob(byte[] byArray) {
        }

        public void handleText(String string) {
            int n2 = string.indexOf(59);
            String string2 = n2 > -1 ? string.substring(0, n2) : string;
            if (this.nextFontNumber == -1 && this.fontNumberKey != null) {
                string2 = RTFReader.this.fontTable.get(this.fontNumberKey) + string2;
            } else {
                this.fontNumberKey = this.nextFontNumber;
            }
            RTFReader.this.fontTable.put(this.fontNumberKey, string2);
            this.nextFontNumber = -1;
            this.nextFontFamily = null;
        }

        public boolean handleKeyword(String string) {
            if (string.charAt(0) == 'f') {
                this.nextFontFamily = string.substring(1);
                return true;
            }
            return false;
        }

        public boolean handleKeyword(String string, int n2) {
            if (string.equals("f")) {
                this.nextFontNumber = n2;
                return true;
            }
            return false;
        }

        public void begingroup() {
        }

        public void endgroup(Dictionary dictionary) {
        }

        public void close() {
            Enumeration enumeration = RTFReader.this.fontTable.keys();
            RTFReader.this.warning("Done reading font table.");
            while (enumeration.hasMoreElements()) {
                Integer n2 = (Integer)enumeration.nextElement();
                RTFReader.this.warning("Number " + n2 + ": " + RTFReader.this.fontTable.get(n2));
            }
        }
    }

    class InfoDestination
    extends DiscardingDestination
    implements Destination {
        InfoDestination() {
        }
    }

    class StylesheetDestination
    extends DiscardingDestination
    implements Destination {
        Dictionary definedStyles = new Hashtable();

        public void begingroup() {
            RTFReader.this.setRTFDestination(new StyleDefiningDestination());
        }

        public void close() {
            Object[] objectArray;
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            Vector<Style> vector3 = new Vector<Style>();
            Enumeration enumeration = this.definedStyles.elements();
            while (enumeration.hasMoreElements()) {
                objectArray = (Object[])enumeration.nextElement();
                Style style = objectArray.realize();
                RTFReader.this.warning("Style " + objectArray.number + " (" + objectArray.styleName + "): " + style);
                String string = (String)style.getAttribute("style:type");
                Vector<Style> vector4 = string.equals("section") ? vector3 : (string.equals("character") ? vector : vector2);
                if (vector4.size() <= objectArray.number) {
                    vector4.setSize(objectArray.number + 1);
                }
                vector4.setElementAt(style, objectArray.number);
            }
            if (!vector.isEmpty()) {
                objectArray = new Style[vector.size()];
                vector.copyInto(objectArray);
                RTFReader.this.characterStyles = objectArray;
            }
            if (!vector2.isEmpty()) {
                objectArray = new Style[vector2.size()];
                vector2.copyInto(objectArray);
                RTFReader.this.paragraphStyles = objectArray;
            }
            if (!vector3.isEmpty()) {
                objectArray = new Style[vector3.size()];
                vector3.copyInto(objectArray);
                RTFReader.this.sectionStyles = objectArray;
            }
        }

        class StyleDefiningDestination
        extends AttributeTrackingDestination
        implements Destination {
            final int STYLENUMBER_NONE = 222;
            boolean additive = false;
            boolean characterStyle = false;
            boolean sectionStyle = false;
            public String styleName = null;
            public int number = 0;
            int basedOn = 222;
            int nextStyle = 222;
            boolean hidden = false;
            Style realizedStyle;

            public void handleText(String string) {
                this.styleName = this.styleName != null ? this.styleName + string : string;
            }

            public void close() {
                int n2;
                int n3 = n2 = this.styleName == null ? 0 : this.styleName.indexOf(59);
                if (n2 > 0) {
                    this.styleName = this.styleName.substring(0, n2);
                }
                StylesheetDestination.this.definedStyles.put(this.number, this);
                super.close();
            }

            public boolean handleKeyword(String string) {
                if (string.equals("additive")) {
                    this.additive = true;
                    return true;
                }
                if (string.equals("shidden")) {
                    this.hidden = true;
                    return true;
                }
                return super.handleKeyword(string);
            }

            public boolean handleKeyword(String string, int n2) {
                if (string.equals("s")) {
                    this.characterStyle = false;
                    this.sectionStyle = false;
                    this.number = n2;
                } else if (string.equals("cs")) {
                    this.characterStyle = true;
                    this.sectionStyle = false;
                    this.number = n2;
                } else if (string.equals("ds")) {
                    this.characterStyle = false;
                    this.sectionStyle = true;
                    this.number = n2;
                } else if (string.equals("sbasedon")) {
                    this.basedOn = n2;
                } else if (string.equals("snext")) {
                    this.nextStyle = n2;
                } else {
                    return super.handleKeyword(string, n2);
                }
                return true;
            }

            public Style realize() {
                StyleDefiningDestination styleDefiningDestination;
                Style style = null;
                Style style2 = null;
                if (this.realizedStyle != null) {
                    return this.realizedStyle;
                }
                if (this.basedOn != 222 && (styleDefiningDestination = (StyleDefiningDestination)StylesheetDestination.this.definedStyles.get(this.basedOn)) != null && styleDefiningDestination != this) {
                    style = styleDefiningDestination.realize();
                }
                this.realizedStyle = RTFReader.this.target.addStyle(this.styleName, style);
                if (this.characterStyle) {
                    this.realizedStyle.addAttributes(this.currentTextAttributes());
                    this.realizedStyle.addAttribute("style:type", "character");
                } else if (this.sectionStyle) {
                    this.realizedStyle.addAttributes(this.currentSectionAttributes());
                    this.realizedStyle.addAttribute("style:type", "section");
                } else {
                    this.realizedStyle.addAttributes(this.currentParagraphAttributes());
                    this.realizedStyle.addAttribute("style:type", "paragraph");
                }
                if (this.nextStyle != 222 && (styleDefiningDestination = (StyleDefiningDestination)StylesheetDestination.this.definedStyles.get(this.nextStyle)) != null) {
                    style2 = styleDefiningDestination.realize();
                }
                if (style2 != null) {
                    this.realizedStyle.addAttribute("style:nextStyle", style2);
                }
                this.realizedStyle.addAttribute("style:additive", this.additive);
                this.realizedStyle.addAttribute("style:hidden", this.hidden);
                return this.realizedStyle;
            }
        }
    }

    abstract class TextHandlingDestination
    extends AttributeTrackingDestination
    implements Destination {
        boolean inParagraph = false;

        public void handleText(String string) {
            if (!this.inParagraph) {
                this.beginParagraph();
            }
            this.deliverText(string, this.currentTextAttributes());
        }

        abstract void deliverText(String var1, AttributeSet var2);

        public void close() {
            if (this.inParagraph) {
                this.endParagraph();
            }
            super.close();
        }

        public boolean handleKeyword(String string) {
            if (string.equals("\r") || string.equals("\n")) {
                string = "par";
            }
            if (string.equals("par")) {
                this.endParagraph();
                return true;
            }
            if (string.equals("sect")) {
                this.endSection();
                return true;
            }
            return super.handleKeyword(string);
        }

        protected void beginParagraph() {
            this.inParagraph = true;
        }

        protected void endParagraph() {
            MutableAttributeSet mutableAttributeSet = this.currentParagraphAttributes();
            MutableAttributeSet mutableAttributeSet2 = this.currentTextAttributes();
            this.finishParagraph(mutableAttributeSet, mutableAttributeSet2);
            this.inParagraph = false;
        }

        abstract void finishParagraph(AttributeSet var1, AttributeSet var2);

        abstract void endSection();
    }
}

