/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import javax.swing.text.html.BlockView;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.InlineView;
import javax.swing.text.html.StyleSheet;

public class ParagraphView
extends javax.swing.text.ParagraphView {
    private AttributeSet attr;
    private StyleSheet.BoxPainter painter;
    private CSS.LengthValue cssWidth;
    private CSS.LengthValue cssHeight;

    public ParagraphView(Element element) {
        super(element);
    }

    public void setParent(View view) {
        super.setParent(view);
        if (view != null) {
            this.setPropertiesFromAttributes();
        }
    }

    public AttributeSet getAttributes() {
        if (this.attr == null) {
            StyleSheet styleSheet = this.getStyleSheet();
            this.attr = styleSheet.getViewAttributes(this);
        }
        return this.attr;
    }

    protected void setPropertiesFromAttributes() {
        StyleSheet styleSheet = this.getStyleSheet();
        this.attr = styleSheet.getViewAttributes(this);
        this.painter = styleSheet.getBoxPainter(this.attr);
        if (this.attr != null) {
            super.setPropertiesFromAttributes();
            this.setInsets((short)this.painter.getInset(1, this), (short)this.painter.getInset(2, this), (short)this.painter.getInset(3, this), (short)this.painter.getInset(4, this));
            Object object = this.attr.getAttribute(CSS.Attribute.TEXT_ALIGN);
            if (object != null) {
                String string = object.toString();
                if (string.equals("left")) {
                    this.setJustification(0);
                } else if (string.equals("center")) {
                    this.setJustification(1);
                } else if (string.equals("right")) {
                    this.setJustification(2);
                } else if (string.equals("justify")) {
                    this.setJustification(3);
                }
            }
            this.cssWidth = (CSS.LengthValue)this.attr.getAttribute(CSS.Attribute.WIDTH);
            this.cssHeight = (CSS.LengthValue)this.attr.getAttribute(CSS.Attribute.HEIGHT);
        }
    }

    protected StyleSheet getStyleSheet() {
        HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
        return hTMLDocument.getStyleSheet();
    }

    protected SizeRequirements calculateMinorAxisRequirements(int n2, SizeRequirements sizeRequirements) {
        if (!BlockView.spanSetFromAttributes(n2, sizeRequirements = super.calculateMinorAxisRequirements(n2, sizeRequirements), this.cssWidth, this.cssHeight)) {
            float f2 = 0.0f;
            int n3 = this.getLayoutViewCount();
            for (int i2 = 0; i2 < n3; ++i2) {
                View view = this.getLayoutView(i2);
                if (view instanceof InlineView) {
                    float f3 = ((InlineView)view).getLongestWordSpan();
                    f2 = Math.max(f3, f2);
                    continue;
                }
                f2 = Math.max(view.getMinimumSpan(n2), f2);
            }
            sizeRequirements.minimum = Math.max(sizeRequirements.minimum, (int)f2);
            sizeRequirements.preferred = Math.max(sizeRequirements.minimum, sizeRequirements.preferred);
            sizeRequirements.maximum = Math.max(sizeRequirements.preferred, sizeRequirements.maximum);
        } else {
            int n4 = n2 == 0 ? this.getLeftInset() + this.getRightInset() : this.getTopInset() + this.getBottomInset();
            sizeRequirements.minimum -= n4;
            sizeRequirements.preferred -= n4;
            sizeRequirements.maximum -= n4;
        }
        return sizeRequirements;
    }

    public boolean isVisible() {
        View view;
        Object object;
        int n2;
        int n3 = this.getLayoutViewCount() - 1;
        for (n2 = 0; n2 < n3; ++n2) {
            object = this.getLayoutView(n2);
            if (!((View)object).isVisible()) continue;
            return true;
        }
        if (n3 > 0 && (view = this.getLayoutView(n3)).getEndOffset() - view.getStartOffset() == 1) {
            return false;
        }
        if (this.getStartOffset() == this.getDocument().getLength()) {
            n2 = 0;
            object = this.getContainer();
            if (object instanceof JTextComponent) {
                n2 = ((JTextComponent)object).isEditable() ? 1 : 0;
            }
            if (n2 == 0) {
                return false;
            }
        }
        return true;
    }

    public void paint(Graphics graphics, Shape shape) {
        if (shape == null) {
            return;
        }
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        this.painter.paint(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
        super.paint(graphics, shape);
    }

    public float getPreferredSpan(int n2) {
        if (!this.isVisible()) {
            return 0.0f;
        }
        return super.getPreferredSpan(n2);
    }

    public float getMinimumSpan(int n2) {
        if (!this.isVisible()) {
            return 0.0f;
        }
        return super.getMinimumSpan(n2);
    }

    public float getMaximumSpan(int n2) {
        if (!this.isVisible()) {
            return 0.0f;
        }
        return super.getMaximumSpan(n2);
    }
}

