/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import sun.misc.FloatingDecimal;

abstract class AbstractStringBuilder
implements Appendable,
CharSequence {
    char[] value;
    int count;
    static final int[] sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};

    AbstractStringBuilder() {
    }

    AbstractStringBuilder(int n2) {
        this.value = new char[n2];
    }

    public int length() {
        return this.count;
    }

    public int capacity() {
        return this.value.length;
    }

    public void ensureCapacity(int n2) {
        if (n2 > this.value.length) {
            this.expandCapacity(n2);
        }
    }

    void expandCapacity(int n2) {
        int n3 = (this.value.length + 1) * 2;
        if (n3 < 0) {
            n3 = Integer.MAX_VALUE;
        } else if (n2 > n3) {
            n3 = n2;
        }
        char[] cArray = new char[n3];
        System.arraycopy(this.value, 0, cArray, 0, this.count);
        this.value = cArray;
    }

    public void trimToSize() {
        if (this.count < this.value.length) {
            char[] cArray = new char[this.count];
            System.arraycopy(this.value, 0, cArray, 0, this.count);
            this.value = cArray;
        }
    }

    public void setLength(int n2) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n2 > this.value.length) {
            this.expandCapacity(n2);
        }
        if (this.count < n2) {
            while (this.count < n2) {
                this.value[this.count] = '\u0000';
                ++this.count;
            }
        } else {
            this.count = n2;
        }
    }

    public char charAt(int n2) {
        if (n2 < 0 || n2 >= this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        return this.value[n2];
    }

    public int codePointAt(int n2) {
        if (n2 < 0 || n2 >= this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        return Character.codePointAt(this.value, n2);
    }

    public int codePointBefore(int n2) {
        int n3 = n2 - 1;
        if (n3 < 0 || n3 >= this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        return Character.codePointBefore(this.value, n2);
    }

    public int codePointCount(int n2, int n3) {
        if (n2 < 0 || n3 > this.count || n2 > n3) {
            throw new IndexOutOfBoundsException();
        }
        return Character.codePointCountImpl(this.value, n2, n3 - n2);
    }

    public int offsetByCodePoints(int n2, int n3) {
        if (n2 < 0 || n2 > this.count) {
            throw new IndexOutOfBoundsException();
        }
        return Character.offsetByCodePointsImpl(this.value, 0, this.count, n2, n3);
    }

    public void getChars(int n2, int n3, char[] cArray, int n4) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 < 0 || n3 > this.count) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        if (n2 > n3) {
            throw new StringIndexOutOfBoundsException("srcBegin > srcEnd");
        }
        System.arraycopy(this.value, n2, cArray, n4, n3 - n2);
    }

    public void setCharAt(int n2, char c2) {
        if (n2 < 0 || n2 >= this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        this.value[n2] = c2;
    }

    public AbstractStringBuilder append(Object object) {
        return this.append(String.valueOf(object));
    }

    public AbstractStringBuilder append(String string) {
        int n2;
        if (string == null) {
            string = "null";
        }
        if ((n2 = string.length()) == 0) {
            return this;
        }
        int n3 = this.count + n2;
        if (n3 > this.value.length) {
            this.expandCapacity(n3);
        }
        string.getChars(0, n2, this.value, this.count);
        this.count = n3;
        return this;
    }

    public AbstractStringBuilder append(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return this.append("null");
        }
        int n2 = stringBuffer.length();
        int n3 = this.count + n2;
        if (n3 > this.value.length) {
            this.expandCapacity(n3);
        }
        stringBuffer.getChars(0, n2, this.value, this.count);
        this.count = n3;
        return this;
    }

    public AbstractStringBuilder append(CharSequence charSequence) {
        if (charSequence == null) {
            charSequence = "null";
        }
        if (charSequence instanceof String) {
            return this.append((String)charSequence);
        }
        if (charSequence instanceof StringBuffer) {
            return this.append((StringBuffer)charSequence);
        }
        return this.append(charSequence, 0, charSequence.length());
    }

    public AbstractStringBuilder append(CharSequence charSequence, int n2, int n3) {
        if (charSequence == null) {
            charSequence = "null";
        }
        if (n2 < 0 || n3 < 0 || n2 > n3 || n3 > charSequence.length()) {
            throw new IndexOutOfBoundsException("start " + n2 + ", end " + n3 + ", s.length() " + charSequence.length());
        }
        int n4 = n3 - n2;
        if (n4 == 0) {
            return this;
        }
        int n5 = this.count + n4;
        if (n5 > this.value.length) {
            this.expandCapacity(n5);
        }
        for (int i2 = n2; i2 < n3; ++i2) {
            this.value[this.count++] = charSequence.charAt(i2);
        }
        this.count = n5;
        return this;
    }

    public AbstractStringBuilder append(char[] cArray) {
        int n2 = this.count + cArray.length;
        if (n2 > this.value.length) {
            this.expandCapacity(n2);
        }
        System.arraycopy(cArray, 0, this.value, this.count, cArray.length);
        this.count = n2;
        return this;
    }

    public AbstractStringBuilder append(char[] cArray, int n2, int n3) {
        int n4 = this.count + n3;
        if (n4 > this.value.length) {
            this.expandCapacity(n4);
        }
        System.arraycopy(cArray, n2, this.value, this.count, n3);
        this.count = n4;
        return this;
    }

    public AbstractStringBuilder append(boolean bl2) {
        if (bl2) {
            int n2 = this.count + 4;
            if (n2 > this.value.length) {
                this.expandCapacity(n2);
            }
            this.value[this.count++] = 116;
            this.value[this.count++] = 114;
            this.value[this.count++] = 117;
            this.value[this.count++] = 101;
        } else {
            int n3 = this.count + 5;
            if (n3 > this.value.length) {
                this.expandCapacity(n3);
            }
            this.value[this.count++] = 102;
            this.value[this.count++] = 97;
            this.value[this.count++] = 108;
            this.value[this.count++] = 115;
            this.value[this.count++] = 101;
        }
        return this;
    }

    public AbstractStringBuilder append(char c2) {
        int n2 = this.count + 1;
        if (n2 > this.value.length) {
            this.expandCapacity(n2);
        }
        this.value[this.count++] = c2;
        return this;
    }

    public AbstractStringBuilder append(int n2) {
        if (n2 == Integer.MIN_VALUE) {
            this.append("-2147483648");
            return this;
        }
        int n3 = n2 < 0 ? AbstractStringBuilder.stringSizeOfInt(-n2) + 1 : AbstractStringBuilder.stringSizeOfInt(n2);
        int n4 = this.count + n3;
        if (n4 > this.value.length) {
            this.expandCapacity(n4);
        }
        Integer.getChars(n2, n4, this.value);
        this.count = n4;
        return this;
    }

    static int stringSizeOfInt(int n2) {
        int n3 = 0;
        while (n2 > sizeTable[n3]) {
            ++n3;
        }
        return n3 + 1;
    }

    public AbstractStringBuilder append(long l2) {
        if (l2 == Long.MIN_VALUE) {
            this.append("-9223372036854775808");
            return this;
        }
        int n2 = l2 < 0L ? AbstractStringBuilder.stringSizeOfLong(-l2) + 1 : AbstractStringBuilder.stringSizeOfLong(l2);
        int n3 = this.count + n2;
        if (n3 > this.value.length) {
            this.expandCapacity(n3);
        }
        Long.getChars(l2, n3, this.value);
        this.count = n3;
        return this;
    }

    static int stringSizeOfLong(long l2) {
        long l3 = 10L;
        for (int i2 = 1; i2 < 19; ++i2) {
            if (l2 < l3) {
                return i2;
            }
            l3 = 10L * l3;
        }
        return 19;
    }

    public AbstractStringBuilder append(float f2) {
        new FloatingDecimal(f2).appendTo(this);
        return this;
    }

    public AbstractStringBuilder append(double d2) {
        new FloatingDecimal(d2).appendTo(this);
        return this;
    }

    public AbstractStringBuilder delete(int n2, int n3) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 > this.count) {
            n3 = this.count;
        }
        if (n2 > n3) {
            throw new StringIndexOutOfBoundsException();
        }
        int n4 = n3 - n2;
        if (n4 > 0) {
            System.arraycopy(this.value, n2 + n4, this.value, n2, this.count - n3);
            this.count -= n4;
        }
        return this;
    }

    public AbstractStringBuilder appendCodePoint(int n2) {
        int n3;
        if (!Character.isValidCodePoint(n2)) {
            throw new IllegalArgumentException();
        }
        int n4 = 1;
        if (n2 >= 65536) {
            ++n4;
        }
        if ((n3 = this.count + n4) > this.value.length) {
            this.expandCapacity(n3);
        }
        if (n4 == 1) {
            this.value[this.count++] = (char)n2;
        } else {
            Character.toSurrogates(n2, this.value, this.count);
            this.count += n4;
        }
        return this;
    }

    public AbstractStringBuilder deleteCharAt(int n2) {
        if (n2 < 0 || n2 >= this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        System.arraycopy(this.value, n2 + 1, this.value, n2, this.count - n2 - 1);
        --this.count;
        return this;
    }

    public AbstractStringBuilder replace(int n2, int n3, String string) {
        int n4;
        int n5;
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n2 > this.count) {
            throw new StringIndexOutOfBoundsException("start > length()");
        }
        if (n2 > n3) {
            throw new StringIndexOutOfBoundsException("start > end");
        }
        if (n3 > this.count) {
            n3 = this.count;
        }
        if (n3 > this.count) {
            n3 = this.count;
        }
        if ((n5 = this.count + (n4 = string.length()) - (n3 - n2)) > this.value.length) {
            this.expandCapacity(n5);
        }
        System.arraycopy(this.value, n3, this.value, n2 + n4, this.count - n3);
        string.getChars(this.value, n2);
        this.count = n5;
        return this;
    }

    public String substring(int n2) {
        return this.substring(n2, this.count);
    }

    public CharSequence subSequence(int n2, int n3) {
        return this.substring(n2, n3);
    }

    public String substring(int n2, int n3) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 > this.count) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        if (n2 > n3) {
            throw new StringIndexOutOfBoundsException(n3 - n2);
        }
        return new String(this.value, n2, n3 - n2);
    }

    public AbstractStringBuilder insert(int n2, char[] cArray, int n3, int n4) {
        if (n2 < 0 || n2 > this.length()) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 < 0 || n4 < 0 || n3 > cArray.length - n4) {
            throw new StringIndexOutOfBoundsException("offset " + n3 + ", len " + n4 + ", str.length " + cArray.length);
        }
        int n5 = this.count + n4;
        if (n5 > this.value.length) {
            this.expandCapacity(n5);
        }
        System.arraycopy(this.value, n2, this.value, n2 + n4, this.count - n2);
        System.arraycopy(cArray, n3, this.value, n2, n4);
        this.count = n5;
        return this;
    }

    public AbstractStringBuilder insert(int n2, Object object) {
        return this.insert(n2, String.valueOf(object));
    }

    public AbstractStringBuilder insert(int n2, String string) {
        int n3;
        int n4;
        if (n2 < 0 || n2 > this.length()) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (string == null) {
            string = "null";
        }
        if ((n4 = this.count + (n3 = string.length())) > this.value.length) {
            this.expandCapacity(n4);
        }
        System.arraycopy(this.value, n2, this.value, n2 + n3, this.count - n2);
        string.getChars(this.value, n2);
        this.count = n4;
        return this;
    }

    public AbstractStringBuilder insert(int n2, char[] cArray) {
        if (n2 < 0 || n2 > this.length()) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        int n3 = cArray.length;
        int n4 = this.count + n3;
        if (n4 > this.value.length) {
            this.expandCapacity(n4);
        }
        System.arraycopy(this.value, n2, this.value, n2 + n3, this.count - n2);
        System.arraycopy(cArray, 0, this.value, n2, n3);
        this.count = n4;
        return this;
    }

    public AbstractStringBuilder insert(int n2, CharSequence charSequence) {
        if (charSequence == null) {
            charSequence = "null";
        }
        if (charSequence instanceof String) {
            return this.insert(n2, (String)charSequence);
        }
        return this.insert(n2, charSequence, 0, charSequence.length());
    }

    public AbstractStringBuilder insert(int n2, CharSequence charSequence, int n3, int n4) {
        if (charSequence == null) {
            charSequence = "null";
        }
        if (n2 < 0 || n2 > this.length()) {
            throw new IndexOutOfBoundsException("dstOffset " + n2);
        }
        if (n3 < 0 || n4 < 0 || n3 > n4 || n4 > charSequence.length()) {
            throw new IndexOutOfBoundsException("start " + n3 + ", end " + n4 + ", s.length() " + charSequence.length());
        }
        int n5 = n4 - n3;
        if (n5 == 0) {
            return this;
        }
        int n6 = this.count + n5;
        if (n6 > this.value.length) {
            this.expandCapacity(n6);
        }
        System.arraycopy(this.value, n2, this.value, n2 + n5, this.count - n2);
        for (int i2 = n3; i2 < n4; ++i2) {
            this.value[n2++] = charSequence.charAt(i2);
        }
        this.count = n6;
        return this;
    }

    public AbstractStringBuilder insert(int n2, boolean bl2) {
        return this.insert(n2, String.valueOf(bl2));
    }

    public AbstractStringBuilder insert(int n2, char c2) {
        int n3 = this.count + 1;
        if (n3 > this.value.length) {
            this.expandCapacity(n3);
        }
        System.arraycopy(this.value, n2, this.value, n2 + 1, this.count - n2);
        this.value[n2] = c2;
        this.count = n3;
        return this;
    }

    public AbstractStringBuilder insert(int n2, int n3) {
        return this.insert(n2, String.valueOf(n3));
    }

    public AbstractStringBuilder insert(int n2, long l2) {
        return this.insert(n2, String.valueOf(l2));
    }

    public AbstractStringBuilder insert(int n2, float f2) {
        return this.insert(n2, String.valueOf(f2));
    }

    public AbstractStringBuilder insert(int n2, double d2) {
        return this.insert(n2, String.valueOf(d2));
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n2) {
        return String.indexOf(this.value, 0, this.count, string.toCharArray(), 0, string.length(), n2);
    }

    public int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.count);
    }

    public int lastIndexOf(String string, int n2) {
        return String.lastIndexOf(this.value, 0, this.count, string.toCharArray(), 0, string.length(), n2);
    }

    public AbstractStringBuilder reverse() {
        char c2;
        char c3;
        int n2;
        boolean bl2 = false;
        int n3 = this.count - 1;
        for (n2 = n3 - 1 >> 1; n2 >= 0; --n2) {
            c3 = this.value[n2];
            c2 = this.value[n3 - n2];
            if (!bl2) {
                bl2 = c3 >= '\ud800' && c3 <= '\udfff' || c2 >= '\ud800' && c2 <= '\udfff';
            }
            this.value[n2] = c2;
            this.value[n3 - n2] = c3;
        }
        if (bl2) {
            for (n2 = 0; n2 < this.count - 1; ++n2) {
                c3 = this.value[n2];
                if (!Character.isLowSurrogate(c3) || !Character.isHighSurrogate(c2 = this.value[n2 + 1])) continue;
                this.value[n2++] = c2;
                this.value[n2] = c3;
            }
        }
        return this;
    }

    public abstract String toString();

    final char[] getValue() {
        return this.value;
    }
}

