/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.ColorPaintContext;
import java.awt.GraphicsEnvironment;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.io.Serializable;

public class Color
implements Paint,
Serializable {
    public static final Color white;
    public static final Color WHITE;
    public static final Color lightGray;
    public static final Color LIGHT_GRAY;
    public static final Color gray;
    public static final Color GRAY;
    public static final Color darkGray;
    public static final Color DARK_GRAY;
    public static final Color black;
    public static final Color BLACK;
    public static final Color red;
    public static final Color RED;
    public static final Color pink;
    public static final Color PINK;
    public static final Color orange;
    public static final Color ORANGE;
    public static final Color yellow;
    public static final Color YELLOW;
    public static final Color green;
    public static final Color GREEN;
    public static final Color magenta;
    public static final Color MAGENTA;
    public static final Color cyan;
    public static final Color CYAN;
    public static final Color blue;
    public static final Color BLUE;
    private transient long pData;
    int value;
    private float[] frgbvalue = null;
    private float[] fvalue = null;
    private float falpha = 0.0f;
    private ColorSpace cs = null;
    private static final long serialVersionUID = 118526816881161077L;
    private static final double FACTOR = 0.7;
    private transient PaintContext theContext;

    private static native void initIDs();

    private static void testColorValueRange(int n2, int n3, int n4, int n5) {
        boolean bl2 = false;
        String string = "";
        if (n5 < 0 || n5 > 255) {
            bl2 = true;
            string = string + " Alpha";
        }
        if (n2 < 0 || n2 > 255) {
            bl2 = true;
            string = string + " Red";
        }
        if (n3 < 0 || n3 > 255) {
            bl2 = true;
            string = string + " Green";
        }
        if (n4 < 0 || n4 > 255) {
            bl2 = true;
            string = string + " Blue";
        }
        if (bl2) {
            throw new IllegalArgumentException("Color parameter outside of expected range:" + string);
        }
    }

    private static void testColorValueRange(float f2, float f3, float f4, float f5) {
        boolean bl2 = false;
        String string = "";
        if ((double)f5 < 0.0 || (double)f5 > 1.0) {
            bl2 = true;
            string = string + " Alpha";
        }
        if ((double)f2 < 0.0 || (double)f2 > 1.0) {
            bl2 = true;
            string = string + " Red";
        }
        if ((double)f3 < 0.0 || (double)f3 > 1.0) {
            bl2 = true;
            string = string + " Green";
        }
        if ((double)f4 < 0.0 || (double)f4 > 1.0) {
            bl2 = true;
            string = string + " Blue";
        }
        if (bl2) {
            throw new IllegalArgumentException("Color parameter outside of expected range:" + string);
        }
    }

    public Color(int n2, int n3, int n4) {
        this(n2, n3, n4, 255);
    }

    public Color(int n2, int n3, int n4, int n5) {
        this.value = (n5 & 0xFF) << 24 | (n2 & 0xFF) << 16 | (n3 & 0xFF) << 8 | (n4 & 0xFF) << 0;
        Color.testColorValueRange(n2, n3, n4, n5);
    }

    public Color(int n2) {
        this.value = 0xFF000000 | n2;
    }

    public Color(int n2, boolean bl2) {
        this.value = bl2 ? n2 : 0xFF000000 | n2;
    }

    public Color(float f2, float f3, float f4) {
        this((int)((double)(f2 * 255.0f) + 0.5), (int)((double)(f3 * 255.0f) + 0.5), (int)((double)(f4 * 255.0f) + 0.5));
        Color.testColorValueRange(f2, f3, f4, 1.0f);
        this.frgbvalue = new float[3];
        this.frgbvalue[0] = f2;
        this.frgbvalue[1] = f3;
        this.frgbvalue[2] = f4;
        this.falpha = 1.0f;
        this.fvalue = this.frgbvalue;
    }

    public Color(float f2, float f3, float f4, float f5) {
        this((int)((double)(f2 * 255.0f) + 0.5), (int)((double)(f3 * 255.0f) + 0.5), (int)((double)(f4 * 255.0f) + 0.5), (int)((double)(f5 * 255.0f) + 0.5));
        this.frgbvalue = new float[3];
        this.frgbvalue[0] = f2;
        this.frgbvalue[1] = f3;
        this.frgbvalue[2] = f4;
        this.falpha = f5;
        this.fvalue = this.frgbvalue;
    }

    public Color(ColorSpace colorSpace, float[] fArray, float f2) {
        boolean bl2 = false;
        String string = "";
        int n2 = colorSpace.getNumComponents();
        this.fvalue = new float[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            if ((double)fArray[i2] < 0.0 || (double)fArray[i2] > 1.0) {
                bl2 = true;
                string = string + "Component " + i2 + " ";
                continue;
            }
            this.fvalue[i2] = fArray[i2];
        }
        if ((double)f2 < 0.0 || (double)f2 > 1.0) {
            bl2 = true;
            string = string + "Alpha";
        } else {
            this.falpha = f2;
        }
        if (bl2) {
            throw new IllegalArgumentException("Color parameter outside of expected range: " + string);
        }
        this.frgbvalue = colorSpace.toRGB(this.fvalue);
        this.cs = colorSpace;
        this.value = ((int)(this.falpha * 255.0f) & 0xFF) << 24 | ((int)(this.frgbvalue[0] * 255.0f) & 0xFF) << 16 | ((int)(this.frgbvalue[1] * 255.0f) & 0xFF) << 8 | ((int)(this.frgbvalue[2] * 255.0f) & 0xFF) << 0;
    }

    public int getRed() {
        return this.getRGB() >> 16 & 0xFF;
    }

    public int getGreen() {
        return this.getRGB() >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.getRGB() >> 0 & 0xFF;
    }

    public int getAlpha() {
        return this.getRGB() >> 24 & 0xFF;
    }

    public int getRGB() {
        return this.value;
    }

    public Color brighter() {
        int n2 = this.getRed();
        int n3 = this.getGreen();
        int n4 = this.getBlue();
        int n5 = 3;
        if (n2 == 0 && n3 == 0 && n4 == 0) {
            return new Color(n5, n5, n5);
        }
        if (n2 > 0 && n2 < n5) {
            n2 = n5;
        }
        if (n3 > 0 && n3 < n5) {
            n3 = n5;
        }
        if (n4 > 0 && n4 < n5) {
            n4 = n5;
        }
        return new Color(Math.min((int)((double)n2 / 0.7), 255), Math.min((int)((double)n3 / 0.7), 255), Math.min((int)((double)n4 / 0.7), 255));
    }

    public Color darker() {
        return new Color(Math.max((int)((double)this.getRed() * 0.7), 0), Math.max((int)((double)this.getGreen() * 0.7), 0), Math.max((int)((double)this.getBlue() * 0.7), 0));
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        return object instanceof Color && ((Color)object).value == this.value;
    }

    public String toString() {
        return this.getClass().getName() + "[r=" + this.getRed() + ",g=" + this.getGreen() + ",b=" + this.getBlue() + "]";
    }

    public static Color decode(String string) throws NumberFormatException {
        Integer n2 = Integer.decode(string);
        int n3 = n2;
        return new Color(n3 >> 16 & 0xFF, n3 >> 8 & 0xFF, n3 & 0xFF);
    }

    public static Color getColor(String string) {
        return Color.getColor(string, null);
    }

    public static Color getColor(String string, Color color) {
        Integer n2 = Integer.getInteger(string);
        if (n2 == null) {
            return color;
        }
        int n3 = n2;
        return new Color(n3 >> 16 & 0xFF, n3 >> 8 & 0xFF, n3 & 0xFF);
    }

    public static Color getColor(String string, int n2) {
        Integer n3 = Integer.getInteger(string);
        int n4 = n3 != null ? n3 : n2;
        return new Color(n4 >> 16 & 0xFF, n4 >> 8 & 0xFF, n4 >> 0 & 0xFF);
    }

    public static int HSBtoRGB(float f2, float f3, float f4) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (f3 == 0.0f) {
            n3 = n4 = (int)(f4 * 255.0f + 0.5f);
            n2 = n4;
        } else {
            float f5 = (f2 - (float)Math.floor(f2)) * 6.0f;
            float f6 = f5 - (float)Math.floor(f5);
            float f7 = f4 * (1.0f - f3);
            float f8 = f4 * (1.0f - f3 * f6);
            float f9 = f4 * (1.0f - f3 * (1.0f - f6));
            switch ((int)f5) {
                case 0: {
                    n2 = (int)(f4 * 255.0f + 0.5f);
                    n3 = (int)(f9 * 255.0f + 0.5f);
                    n4 = (int)(f7 * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    n2 = (int)(f8 * 255.0f + 0.5f);
                    n3 = (int)(f4 * 255.0f + 0.5f);
                    n4 = (int)(f7 * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    n2 = (int)(f7 * 255.0f + 0.5f);
                    n3 = (int)(f4 * 255.0f + 0.5f);
                    n4 = (int)(f9 * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    n2 = (int)(f7 * 255.0f + 0.5f);
                    n3 = (int)(f8 * 255.0f + 0.5f);
                    n4 = (int)(f4 * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    n2 = (int)(f9 * 255.0f + 0.5f);
                    n3 = (int)(f7 * 255.0f + 0.5f);
                    n4 = (int)(f4 * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    n2 = (int)(f4 * 255.0f + 0.5f);
                    n3 = (int)(f7 * 255.0f + 0.5f);
                    n4 = (int)(f8 * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | n2 << 16 | n3 << 8 | n4 << 0;
    }

    public static float[] RGBtoHSB(int n2, int n3, int n4, float[] fArray) {
        float f2;
        int n5;
        int n6;
        if (fArray == null) {
            fArray = new float[3];
        }
        int n7 = n6 = n2 > n3 ? n2 : n3;
        if (n4 > n6) {
            n6 = n4;
        }
        int n8 = n5 = n2 < n3 ? n2 : n3;
        if (n4 < n5) {
            n5 = n4;
        }
        float f3 = (float)n6 / 255.0f;
        float f4 = n6 != 0 ? (float)(n6 - n5) / (float)n6 : 0.0f;
        if (f4 == 0.0f) {
            f2 = 0.0f;
        } else {
            float f5 = (float)(n6 - n2) / (float)(n6 - n5);
            float f6 = (float)(n6 - n3) / (float)(n6 - n5);
            float f7 = (float)(n6 - n4) / (float)(n6 - n5);
            f2 = n2 == n6 ? f7 - f6 : (n3 == n6 ? 2.0f + f5 - f7 : 4.0f + f6 - f5);
            if ((f2 /= 6.0f) < 0.0f) {
                f2 += 1.0f;
            }
        }
        fArray[0] = f2;
        fArray[1] = f4;
        fArray[2] = f3;
        return fArray;
    }

    public static Color getHSBColor(float f2, float f3, float f4) {
        return new Color(Color.HSBtoRGB(f2, f3, f4));
    }

    public float[] getRGBComponents(float[] fArray) {
        float[] fArray2 = fArray == null ? new float[4] : fArray;
        if (this.frgbvalue == null) {
            fArray2[0] = (float)this.getRed() / 255.0f;
            fArray2[1] = (float)this.getGreen() / 255.0f;
            fArray2[2] = (float)this.getBlue() / 255.0f;
            fArray2[3] = (float)this.getAlpha() / 255.0f;
        } else {
            fArray2[0] = this.frgbvalue[0];
            fArray2[1] = this.frgbvalue[1];
            fArray2[2] = this.frgbvalue[2];
            fArray2[3] = this.falpha;
        }
        return fArray2;
    }

    public float[] getRGBColorComponents(float[] fArray) {
        float[] fArray2 = fArray == null ? new float[3] : fArray;
        if (this.frgbvalue == null) {
            fArray2[0] = (float)this.getRed() / 255.0f;
            fArray2[1] = (float)this.getGreen() / 255.0f;
            fArray2[2] = (float)this.getBlue() / 255.0f;
        } else {
            fArray2[0] = this.frgbvalue[0];
            fArray2[1] = this.frgbvalue[1];
            fArray2[2] = this.frgbvalue[2];
        }
        return fArray2;
    }

    public float[] getComponents(float[] fArray) {
        if (this.fvalue == null) {
            return this.getRGBComponents(fArray);
        }
        int n2 = this.fvalue.length;
        float[] fArray2 = fArray == null ? new float[n2 + 1] : fArray;
        for (int i2 = 0; i2 < n2; ++i2) {
            fArray2[i2] = this.fvalue[i2];
        }
        fArray2[n2] = this.falpha;
        return fArray2;
    }

    public float[] getColorComponents(float[] fArray) {
        if (this.fvalue == null) {
            return this.getRGBColorComponents(fArray);
        }
        int n2 = this.fvalue.length;
        float[] fArray2 = fArray == null ? new float[n2] : fArray;
        for (int i2 = 0; i2 < n2; ++i2) {
            fArray2[i2] = this.fvalue[i2];
        }
        return fArray2;
    }

    public float[] getComponents(ColorSpace colorSpace, float[] fArray) {
        if (this.cs == null) {
            this.cs = ColorSpace.getInstance(1000);
        }
        float[] fArray2 = this.fvalue == null ? new float[]{(float)this.getRed() / 255.0f, (float)this.getGreen() / 255.0f, (float)this.getBlue() / 255.0f} : this.fvalue;
        float[] fArray3 = this.cs.toCIEXYZ(fArray2);
        float[] fArray4 = colorSpace.fromCIEXYZ(fArray3);
        if (fArray == null) {
            fArray = new float[fArray4.length + 1];
        }
        for (int i2 = 0; i2 < fArray4.length; ++i2) {
            fArray[i2] = fArray4[i2];
        }
        fArray[fArray4.length] = this.fvalue == null ? (float)this.getAlpha() / 255.0f : this.falpha;
        return fArray;
    }

    public float[] getColorComponents(ColorSpace colorSpace, float[] fArray) {
        if (this.cs == null) {
            this.cs = ColorSpace.getInstance(1000);
        }
        float[] fArray2 = this.fvalue == null ? new float[]{(float)this.getRed() / 255.0f, (float)this.getGreen() / 255.0f, (float)this.getBlue() / 255.0f} : this.fvalue;
        float[] fArray3 = this.cs.toCIEXYZ(fArray2);
        float[] fArray4 = colorSpace.fromCIEXYZ(fArray3);
        if (fArray == null) {
            return fArray4;
        }
        for (int i2 = 0; i2 < fArray4.length; ++i2) {
            fArray[i2] = fArray4[i2];
        }
        return fArray;
    }

    public ColorSpace getColorSpace() {
        if (this.cs == null) {
            this.cs = ColorSpace.getInstance(1000);
        }
        return this.cs;
    }

    public synchronized PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        PaintContext paintContext = this.theContext;
        if (paintContext == null) {
            this.theContext = paintContext = new ColorPaintContext(this.value, colorModel);
        }
        return paintContext;
    }

    public int getTransparency() {
        int n2 = this.getAlpha();
        if (n2 == 255) {
            return 1;
        }
        if (n2 == 0) {
            return 2;
        }
        return 3;
    }

    static {
        WHITE = white = new Color(255, 255, 255);
        LIGHT_GRAY = lightGray = new Color(192, 192, 192);
        GRAY = gray = new Color(128, 128, 128);
        DARK_GRAY = darkGray = new Color(64, 64, 64);
        BLACK = black = new Color(0, 0, 0);
        RED = red = new Color(255, 0, 0);
        PINK = pink = new Color(255, 175, 175);
        ORANGE = orange = new Color(255, 200, 0);
        YELLOW = yellow = new Color(255, 255, 0);
        GREEN = green = new Color(0, 255, 0);
        MAGENTA = magenta = new Color(255, 0, 255);
        CYAN = cyan = new Color(0, 255, 255);
        BLUE = blue = new Color(0, 0, 255);
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            Color.initIDs();
        }
    }
}

