/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.Constants;
import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.generic.BranchHandle;
import com.sun.org.apache.bcel.internal.generic.BranchInstruction;
import com.sun.org.apache.bcel.internal.generic.CPInstruction;
import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.CodeExceptionGen;
import com.sun.org.apache.bcel.internal.generic.CompoundInstruction;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.Instruction;
import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.InstructionListObserver;
import com.sun.org.apache.bcel.internal.generic.LocalVariableGen;
import com.sun.org.apache.bcel.internal.generic.Select;
import com.sun.org.apache.bcel.internal.generic.TargetLostException;
import com.sun.org.apache.bcel.internal.util.ByteSequence;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class InstructionList
implements Serializable {
    private InstructionHandle start = null;
    private InstructionHandle end = null;
    private int length = 0;
    private int[] byte_positions;
    private ArrayList observers;

    public InstructionList() {
    }

    public InstructionList(Instruction instruction) {
        this.append(instruction);
    }

    public InstructionList(BranchInstruction branchInstruction) {
        this.append(branchInstruction);
    }

    public InstructionList(CompoundInstruction compoundInstruction) {
        this.append(compoundInstruction.getInstructionList());
    }

    public boolean isEmpty() {
        return this.start == null;
    }

    public static InstructionHandle findHandle(InstructionHandle[] instructionHandleArray, int[] nArray, int n2, int n3) {
        int n4 = 0;
        int n5 = n2 - 1;
        do {
            int n6;
            int n7;
            if ((n7 = nArray[n6 = (n4 + n5) / 2]) == n3) {
                return instructionHandleArray[n6];
            }
            if (n3 < n7) {
                n5 = n6 - 1;
                continue;
            }
            n4 = n6 + 1;
        } while (n4 <= n5);
        return null;
    }

    public InstructionHandle findHandle(int n2) {
        InstructionHandle[] instructionHandleArray = this.getInstructionHandles();
        return InstructionList.findHandle(instructionHandleArray, this.byte_positions, this.length, n2);
    }

    public InstructionList(byte[] byArray) {
        Instruction instruction;
        int n2;
        ByteSequence byteSequence = new ByteSequence(byArray);
        InstructionHandle[] instructionHandleArray = new InstructionHandle[byArray.length];
        int[] nArray = new int[byArray.length];
        int n3 = 0;
        try {
            while (byteSequence.available() > 0) {
                nArray[n3] = n2 = byteSequence.getIndex();
                instruction = Instruction.readInstruction(byteSequence);
                InstructionHandle instructionHandle = instruction instanceof BranchInstruction ? this.append((BranchInstruction)instruction) : this.append(instruction);
                instructionHandle.setPosition(n2);
                instructionHandleArray[n3] = instructionHandle;
                ++n3;
            }
        }
        catch (IOException iOException) {
            throw new ClassGenException(iOException.toString());
        }
        this.byte_positions = new int[n3];
        System.arraycopy(nArray, 0, this.byte_positions, 0, n3);
        for (n2 = 0; n2 < n3; ++n2) {
            if (!(instructionHandleArray[n2] instanceof BranchHandle)) continue;
            instruction = (BranchInstruction)instructionHandleArray[n2].instruction;
            int n4 = ((BranchInstruction)instruction).position + ((BranchInstruction)instruction).getIndex();
            InstructionHandle instructionHandle = InstructionList.findHandle(instructionHandleArray, nArray, n3, n4);
            if (instructionHandle == null) {
                throw new ClassGenException("Couldn't find target for branch: " + instruction);
            }
            ((BranchInstruction)instruction).setTarget(instructionHandle);
            if (!(instruction instanceof Select)) continue;
            Select select = (Select)instruction;
            int[] nArray2 = select.getIndices();
            for (int i2 = 0; i2 < nArray2.length; ++i2) {
                n4 = ((BranchInstruction)instruction).position + nArray2[i2];
                instructionHandle = InstructionList.findHandle(instructionHandleArray, nArray, n3, n4);
                if (instructionHandle == null) {
                    throw new ClassGenException("Couldn't find target for switch: " + instruction);
                }
                select.setTarget(i2, instructionHandle);
            }
        }
    }

    public InstructionHandle append(InstructionHandle instructionHandle, InstructionList instructionList) {
        if (instructionList == null) {
            throw new ClassGenException("Appending null InstructionList");
        }
        if (instructionList.isEmpty()) {
            return instructionHandle;
        }
        InstructionHandle instructionHandle2 = instructionHandle.next;
        InstructionHandle instructionHandle3 = instructionList.start;
        instructionHandle.next = instructionList.start;
        instructionList.start.prev = instructionHandle;
        instructionList.end.next = instructionHandle2;
        if (instructionHandle2 != null) {
            instructionHandle2.prev = instructionList.end;
        } else {
            this.end = instructionList.end;
        }
        this.length += instructionList.length;
        instructionList.clear();
        return instructionHandle3;
    }

    public InstructionHandle append(Instruction instruction, InstructionList instructionList) {
        InstructionHandle instructionHandle = this.findInstruction2(instruction);
        if (instructionHandle == null) {
            throw new ClassGenException("Instruction " + instruction + " is not contained in this list.");
        }
        return this.append(instructionHandle, instructionList);
    }

    public InstructionHandle append(InstructionList instructionList) {
        if (instructionList == null) {
            throw new ClassGenException("Appending null InstructionList");
        }
        if (instructionList.isEmpty()) {
            return null;
        }
        if (this.isEmpty()) {
            this.start = instructionList.start;
            this.end = instructionList.end;
            this.length = instructionList.length;
            instructionList.clear();
            return this.start;
        }
        return this.append(this.end, instructionList);
    }

    private void append(InstructionHandle instructionHandle) {
        if (this.isEmpty()) {
            this.start = this.end = instructionHandle;
            instructionHandle.prev = null;
            instructionHandle.next = null;
        } else {
            this.end.next = instructionHandle;
            instructionHandle.prev = this.end;
            instructionHandle.next = null;
            this.end = instructionHandle;
        }
        ++this.length;
    }

    public InstructionHandle append(Instruction instruction) {
        InstructionHandle instructionHandle = InstructionHandle.getInstructionHandle(instruction);
        this.append(instructionHandle);
        return instructionHandle;
    }

    public BranchHandle append(BranchInstruction branchInstruction) {
        BranchHandle branchHandle = BranchHandle.getBranchHandle(branchInstruction);
        this.append(branchHandle);
        return branchHandle;
    }

    public InstructionHandle append(Instruction instruction, Instruction instruction2) {
        return this.append(instruction, new InstructionList(instruction2));
    }

    public InstructionHandle append(Instruction instruction, CompoundInstruction compoundInstruction) {
        return this.append(instruction, compoundInstruction.getInstructionList());
    }

    public InstructionHandle append(CompoundInstruction compoundInstruction) {
        return this.append(compoundInstruction.getInstructionList());
    }

    public InstructionHandle append(InstructionHandle instructionHandle, CompoundInstruction compoundInstruction) {
        return this.append(instructionHandle, compoundInstruction.getInstructionList());
    }

    public InstructionHandle append(InstructionHandle instructionHandle, Instruction instruction) {
        return this.append(instructionHandle, new InstructionList(instruction));
    }

    public BranchHandle append(InstructionHandle instructionHandle, BranchInstruction branchInstruction) {
        BranchHandle branchHandle = BranchHandle.getBranchHandle(branchInstruction);
        InstructionList instructionList = new InstructionList();
        instructionList.append(branchHandle);
        this.append(instructionHandle, instructionList);
        return branchHandle;
    }

    public InstructionHandle insert(InstructionHandle instructionHandle, InstructionList instructionList) {
        if (instructionList == null) {
            throw new ClassGenException("Inserting null InstructionList");
        }
        if (instructionList.isEmpty()) {
            return instructionHandle;
        }
        InstructionHandle instructionHandle2 = instructionHandle.prev;
        InstructionHandle instructionHandle3 = instructionList.start;
        instructionHandle.prev = instructionList.end;
        instructionList.end.next = instructionHandle;
        instructionList.start.prev = instructionHandle2;
        if (instructionHandle2 != null) {
            instructionHandle2.next = instructionList.start;
        } else {
            this.start = instructionList.start;
        }
        this.length += instructionList.length;
        instructionList.clear();
        return instructionHandle3;
    }

    public InstructionHandle insert(InstructionList instructionList) {
        if (this.isEmpty()) {
            this.append(instructionList);
            return this.start;
        }
        return this.insert(this.start, instructionList);
    }

    private void insert(InstructionHandle instructionHandle) {
        if (this.isEmpty()) {
            this.start = this.end = instructionHandle;
            instructionHandle.prev = null;
            instructionHandle.next = null;
        } else {
            this.start.prev = instructionHandle;
            instructionHandle.next = this.start;
            instructionHandle.prev = null;
            this.start = instructionHandle;
        }
        ++this.length;
    }

    public InstructionHandle insert(Instruction instruction, InstructionList instructionList) {
        InstructionHandle instructionHandle = this.findInstruction1(instruction);
        if (instructionHandle == null) {
            throw new ClassGenException("Instruction " + instruction + " is not contained in this list.");
        }
        return this.insert(instructionHandle, instructionList);
    }

    public InstructionHandle insert(Instruction instruction) {
        InstructionHandle instructionHandle = InstructionHandle.getInstructionHandle(instruction);
        this.insert(instructionHandle);
        return instructionHandle;
    }

    public BranchHandle insert(BranchInstruction branchInstruction) {
        BranchHandle branchHandle = BranchHandle.getBranchHandle(branchInstruction);
        this.insert(branchHandle);
        return branchHandle;
    }

    public InstructionHandle insert(Instruction instruction, Instruction instruction2) {
        return this.insert(instruction, new InstructionList(instruction2));
    }

    public InstructionHandle insert(Instruction instruction, CompoundInstruction compoundInstruction) {
        return this.insert(instruction, compoundInstruction.getInstructionList());
    }

    public InstructionHandle insert(CompoundInstruction compoundInstruction) {
        return this.insert(compoundInstruction.getInstructionList());
    }

    public InstructionHandle insert(InstructionHandle instructionHandle, Instruction instruction) {
        return this.insert(instructionHandle, new InstructionList(instruction));
    }

    public InstructionHandle insert(InstructionHandle instructionHandle, CompoundInstruction compoundInstruction) {
        return this.insert(instructionHandle, compoundInstruction.getInstructionList());
    }

    public BranchHandle insert(InstructionHandle instructionHandle, BranchInstruction branchInstruction) {
        BranchHandle branchHandle = BranchHandle.getBranchHandle(branchInstruction);
        InstructionList instructionList = new InstructionList();
        instructionList.append(branchHandle);
        this.insert(instructionHandle, instructionList);
        return branchHandle;
    }

    public void move(InstructionHandle instructionHandle, InstructionHandle instructionHandle2, InstructionHandle instructionHandle3) {
        if (instructionHandle == null || instructionHandle2 == null) {
            throw new ClassGenException("Invalid null handle: From " + instructionHandle + " to " + instructionHandle2);
        }
        if (instructionHandle3 == instructionHandle || instructionHandle3 == instructionHandle2) {
            throw new ClassGenException("Invalid range: From " + instructionHandle + " to " + instructionHandle2 + " contains target " + instructionHandle3);
        }
        InstructionHandle instructionHandle4 = instructionHandle;
        while (instructionHandle4 != instructionHandle2.next) {
            if (instructionHandle4 == null) {
                throw new ClassGenException("Invalid range: From " + instructionHandle + " to " + instructionHandle2);
            }
            if (instructionHandle4 == instructionHandle3) {
                throw new ClassGenException("Invalid range: From " + instructionHandle + " to " + instructionHandle2 + " contains target " + instructionHandle3);
            }
            instructionHandle4 = instructionHandle4.next;
        }
        instructionHandle4 = instructionHandle.prev;
        InstructionHandle instructionHandle5 = instructionHandle2.next;
        if (instructionHandle4 != null) {
            instructionHandle4.next = instructionHandle5;
        } else {
            this.start = instructionHandle5;
        }
        if (instructionHandle5 != null) {
            instructionHandle5.prev = instructionHandle4;
        } else {
            this.end = instructionHandle4;
        }
        instructionHandle2.next = null;
        instructionHandle.prev = null;
        if (instructionHandle3 == null) {
            instructionHandle2.next = this.start;
            this.start = instructionHandle;
        } else {
            instructionHandle5 = instructionHandle3.next;
            instructionHandle3.next = instructionHandle;
            instructionHandle.prev = instructionHandle3;
            instructionHandle2.next = instructionHandle5;
            if (instructionHandle5 != null) {
                instructionHandle5.prev = instructionHandle2;
            }
        }
    }

    public void move(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        this.move(instructionHandle, instructionHandle, instructionHandle2);
    }

    private void remove(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) throws TargetLostException {
        InstructionHandle[] instructionHandleArray;
        InstructionHandle instructionHandle3;
        if (instructionHandle == null && instructionHandle2 == null) {
            instructionHandle3 = this.start;
            instructionHandleArray = instructionHandle3;
            this.end = null;
            this.start = null;
        } else {
            if (instructionHandle == null) {
                instructionHandleArray = this.start;
                this.start = instructionHandle2;
            } else {
                instructionHandleArray = instructionHandle.next;
                instructionHandle.next = instructionHandle2;
            }
            if (instructionHandle2 == null) {
                instructionHandle3 = this.end;
                this.end = instructionHandle;
            } else {
                instructionHandle3 = instructionHandle2.prev;
                instructionHandle2.prev = instructionHandle;
            }
        }
        instructionHandleArray.prev = null;
        instructionHandle3.next = null;
        ArrayList<InstructionHandle[]> arrayList = new ArrayList<InstructionHandle[]>();
        Serializable serializable = instructionHandleArray;
        while (serializable != null) {
            ((InstructionHandle)serializable).getInstruction().dispose();
            serializable = ((InstructionHandle)serializable).next;
        }
        serializable = new StringBuffer("{ ");
        InstructionHandle[] instructionHandleArray2 = instructionHandleArray;
        while (instructionHandleArray2 != null) {
            instructionHandle2 = instructionHandleArray2.next;
            --this.length;
            if (instructionHandleArray2.hasTargeters()) {
                arrayList.add(instructionHandleArray2);
                ((StringBuffer)serializable).append(instructionHandleArray2.toString(true) + " ");
                instructionHandleArray2.prev = null;
                instructionHandleArray2.next = null;
            } else {
                instructionHandleArray2.dispose();
            }
            instructionHandleArray2 = instructionHandle2;
        }
        ((StringBuffer)serializable).append("}");
        if (!arrayList.isEmpty()) {
            instructionHandleArray2 = new InstructionHandle[arrayList.size()];
            arrayList.toArray(instructionHandleArray2);
            throw new TargetLostException(instructionHandleArray2, ((StringBuffer)serializable).toString());
        }
    }

    public void delete(InstructionHandle instructionHandle) throws TargetLostException {
        this.remove(instructionHandle.prev, instructionHandle.next);
    }

    public void delete(Instruction instruction) throws TargetLostException {
        InstructionHandle instructionHandle = this.findInstruction1(instruction);
        if (instructionHandle == null) {
            throw new ClassGenException("Instruction " + instruction + " is not contained in this list.");
        }
        this.delete(instructionHandle);
    }

    public void delete(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) throws TargetLostException {
        this.remove(instructionHandle.prev, instructionHandle2.next);
    }

    public void delete(Instruction instruction, Instruction instruction2) throws TargetLostException {
        InstructionHandle instructionHandle = this.findInstruction1(instruction);
        if (instructionHandle == null) {
            throw new ClassGenException("Instruction " + instruction + " is not contained in this list.");
        }
        InstructionHandle instructionHandle2 = this.findInstruction2(instruction2);
        if (instructionHandle2 == null) {
            throw new ClassGenException("Instruction " + instruction2 + " is not contained in this list.");
        }
        this.delete(instructionHandle, instructionHandle2);
    }

    private InstructionHandle findInstruction1(Instruction instruction) {
        InstructionHandle instructionHandle = this.start;
        while (instructionHandle != null) {
            if (instructionHandle.instruction == instruction) {
                return instructionHandle;
            }
            instructionHandle = instructionHandle.next;
        }
        return null;
    }

    private InstructionHandle findInstruction2(Instruction instruction) {
        InstructionHandle instructionHandle = this.end;
        while (instructionHandle != null) {
            if (instructionHandle.instruction == instruction) {
                return instructionHandle;
            }
            instructionHandle = instructionHandle.prev;
        }
        return null;
    }

    public boolean contains(InstructionHandle instructionHandle) {
        if (instructionHandle == null) {
            return false;
        }
        InstructionHandle instructionHandle2 = this.start;
        while (instructionHandle2 != null) {
            if (instructionHandle2 == instructionHandle) {
                return true;
            }
            instructionHandle2 = instructionHandle2.next;
        }
        return false;
    }

    public boolean contains(Instruction instruction) {
        return this.findInstruction1(instruction) != null;
    }

    public void setPositions() {
        this.setPositions(false);
    }

    public void setPositions(boolean bl2) {
        Instruction instruction;
        InstructionHandle instructionHandle;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int[] nArray = new int[this.length];
        if (bl2) {
            instructionHandle = this.start;
            while (instructionHandle != null) {
                instruction = instructionHandle.instruction;
                if (instruction instanceof BranchInstruction) {
                    Instruction instruction2 = ((BranchInstruction)instruction).getTarget().instruction;
                    if (!this.contains(instruction2)) {
                        throw new ClassGenException("Branch target of " + Constants.OPCODE_NAMES[instruction.opcode] + ":" + instruction2 + " not in instruction list");
                    }
                    if (instruction instanceof Select) {
                        InstructionHandle[] instructionHandleArray = ((Select)instruction).getTargets();
                        for (int i2 = 0; i2 < instructionHandleArray.length; ++i2) {
                            instruction2 = instructionHandleArray[i2].instruction;
                            if (this.contains(instruction2)) continue;
                            throw new ClassGenException("Branch target of " + Constants.OPCODE_NAMES[instruction.opcode] + ":" + instruction2 + " not in instruction list");
                        }
                    }
                    if (!(instructionHandle instanceof BranchHandle)) {
                        throw new ClassGenException("Branch instruction " + Constants.OPCODE_NAMES[instruction.opcode] + ":" + instruction2 + " not contained in BranchHandle.");
                    }
                }
                instructionHandle = instructionHandle.next;
            }
        }
        instructionHandle = this.start;
        while (instructionHandle != null) {
            instruction = instructionHandle.instruction;
            instructionHandle.setPosition(n4);
            nArray[n5++] = n4;
            switch (instruction.getOpcode()) {
                case 167: 
                case 168: {
                    n2 += 2;
                    break;
                }
                case 170: 
                case 171: {
                    n2 += 3;
                }
            }
            n4 += instruction.getLength();
            instructionHandle = instructionHandle.next;
        }
        instructionHandle = this.start;
        while (instructionHandle != null) {
            n3 += instructionHandle.updatePosition(n3, n2);
            instructionHandle = instructionHandle.next;
        }
        n5 = 0;
        n4 = 0;
        instructionHandle = this.start;
        while (instructionHandle != null) {
            instruction = instructionHandle.instruction;
            instructionHandle.setPosition(n4);
            nArray[n5++] = n4;
            n4 += instruction.getLength();
            instructionHandle = instructionHandle.next;
        }
        this.byte_positions = new int[n5];
        System.arraycopy(nArray, 0, this.byte_positions, 0, n5);
    }

    public byte[] getByteCode() {
        this.setPositions();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            InstructionHandle instructionHandle = this.start;
            while (instructionHandle != null) {
                Instruction instruction = instructionHandle.instruction;
                instruction.dump(dataOutputStream);
                instructionHandle = instructionHandle.next;
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public Instruction[] getInstructions() {
        ByteSequence byteSequence = new ByteSequence(this.getByteCode());
        ArrayList<Instruction> arrayList = new ArrayList<Instruction>();
        try {
            while (byteSequence.available() > 0) {
                arrayList.add(Instruction.readInstruction(byteSequence));
            }
        }
        catch (IOException iOException) {
            throw new ClassGenException(iOException.toString());
        }
        Instruction[] instructionArray = new Instruction[arrayList.size()];
        arrayList.toArray(instructionArray);
        return instructionArray;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        InstructionHandle instructionHandle = this.start;
        while (instructionHandle != null) {
            stringBuffer.append(instructionHandle.toString(bl2) + "\n");
            instructionHandle = instructionHandle.next;
        }
        return stringBuffer.toString();
    }

    public Iterator iterator() {
        return new Iterator(){
            private InstructionHandle ih;
            {
                this.ih = InstructionList.this.start;
            }

            public Object next() {
                InstructionHandle instructionHandle = this.ih;
                this.ih = this.ih.next;
                return instructionHandle;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean hasNext() {
                return this.ih != null;
            }
        };
    }

    public InstructionHandle[] getInstructionHandles() {
        InstructionHandle[] instructionHandleArray = new InstructionHandle[this.length];
        InstructionHandle instructionHandle = this.start;
        for (int i2 = 0; i2 < this.length; ++i2) {
            instructionHandleArray[i2] = instructionHandle;
            instructionHandle = instructionHandle.next;
        }
        return instructionHandleArray;
    }

    public int[] getInstructionPositions() {
        return this.byte_positions;
    }

    public InstructionList copy() {
        Instruction instruction;
        Serializable serializable;
        HashMap<InstructionHandle, InstructionHandle> hashMap = new HashMap<InstructionHandle, InstructionHandle>();
        InstructionList instructionList = new InstructionList();
        InstructionHandle instructionHandle = this.start;
        while (instructionHandle != null) {
            serializable = instructionHandle.instruction;
            instruction = serializable.copy();
            if (instruction instanceof BranchInstruction) {
                hashMap.put(instructionHandle, instructionList.append((BranchInstruction)instruction));
            } else {
                hashMap.put(instructionHandle, instructionList.append(instruction));
            }
            instructionHandle = instructionHandle.next;
        }
        instructionHandle = this.start;
        serializable = instructionList.start;
        while (instructionHandle != null) {
            instruction = instructionHandle.instruction;
            Instruction instruction2 = ((InstructionHandle)serializable).instruction;
            if (instruction instanceof BranchInstruction) {
                BranchInstruction branchInstruction = (BranchInstruction)instruction;
                BranchInstruction branchInstruction2 = (BranchInstruction)instruction2;
                InstructionHandle instructionHandle2 = branchInstruction.getTarget();
                branchInstruction2.setTarget((InstructionHandle)hashMap.get(instructionHandle2));
                if (branchInstruction instanceof Select) {
                    InstructionHandle[] instructionHandleArray = ((Select)branchInstruction).getTargets();
                    InstructionHandle[] instructionHandleArray2 = ((Select)branchInstruction2).getTargets();
                    for (int i2 = 0; i2 < instructionHandleArray.length; ++i2) {
                        instructionHandleArray2[i2] = (InstructionHandle)hashMap.get(instructionHandleArray[i2]);
                    }
                }
            }
            instructionHandle = instructionHandle.next;
            serializable = ((InstructionHandle)serializable).next;
        }
        return instructionList;
    }

    public void replaceConstantPool(ConstantPoolGen constantPoolGen, ConstantPoolGen constantPoolGen2) {
        InstructionHandle instructionHandle = this.start;
        while (instructionHandle != null) {
            Instruction instruction = instructionHandle.instruction;
            if (instruction instanceof CPInstruction) {
                CPInstruction cPInstruction = (CPInstruction)instruction;
                Constant constant = constantPoolGen.getConstant(cPInstruction.getIndex());
                cPInstruction.setIndex(constantPoolGen2.addConstant(constant, constantPoolGen));
            }
            instructionHandle = instructionHandle.next;
        }
    }

    private void clear() {
        this.end = null;
        this.start = null;
        this.length = 0;
    }

    public void dispose() {
        InstructionHandle instructionHandle = this.end;
        while (instructionHandle != null) {
            instructionHandle.dispose();
            instructionHandle = instructionHandle.prev;
        }
        this.clear();
    }

    public InstructionHandle getStart() {
        return this.start;
    }

    public InstructionHandle getEnd() {
        return this.end;
    }

    public int getLength() {
        return this.length;
    }

    public int size() {
        return this.length;
    }

    public void redirectBranches(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        InstructionHandle instructionHandle3 = this.start;
        while (instructionHandle3 != null) {
            Instruction instruction = instructionHandle3.getInstruction();
            if (instruction instanceof BranchInstruction) {
                BranchInstruction branchInstruction = (BranchInstruction)instruction;
                InstructionHandle instructionHandle4 = branchInstruction.getTarget();
                if (instructionHandle4 == instructionHandle) {
                    branchInstruction.setTarget(instructionHandle2);
                }
                if (branchInstruction instanceof Select) {
                    InstructionHandle[] instructionHandleArray = ((Select)branchInstruction).getTargets();
                    for (int i2 = 0; i2 < instructionHandleArray.length; ++i2) {
                        if (instructionHandleArray[i2] != instructionHandle) continue;
                        ((Select)branchInstruction).setTarget(i2, instructionHandle2);
                    }
                }
            }
            instructionHandle3 = instructionHandle3.next;
        }
    }

    public void redirectLocalVariables(LocalVariableGen[] localVariableGenArray, InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        for (int i2 = 0; i2 < localVariableGenArray.length; ++i2) {
            InstructionHandle instructionHandle3 = localVariableGenArray[i2].getStart();
            InstructionHandle instructionHandle4 = localVariableGenArray[i2].getEnd();
            if (instructionHandle3 == instructionHandle) {
                localVariableGenArray[i2].setStart(instructionHandle2);
            }
            if (instructionHandle4 != instructionHandle) continue;
            localVariableGenArray[i2].setEnd(instructionHandle2);
        }
    }

    public void redirectExceptionHandlers(CodeExceptionGen[] codeExceptionGenArray, InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        for (int i2 = 0; i2 < codeExceptionGenArray.length; ++i2) {
            if (codeExceptionGenArray[i2].getStartPC() == instructionHandle) {
                codeExceptionGenArray[i2].setStartPC(instructionHandle2);
            }
            if (codeExceptionGenArray[i2].getEndPC() == instructionHandle) {
                codeExceptionGenArray[i2].setEndPC(instructionHandle2);
            }
            if (codeExceptionGenArray[i2].getHandlerPC() != instructionHandle) continue;
            codeExceptionGenArray[i2].setHandlerPC(instructionHandle2);
        }
    }

    public void addObserver(InstructionListObserver instructionListObserver) {
        if (this.observers == null) {
            this.observers = new ArrayList();
        }
        this.observers.add(instructionListObserver);
    }

    public void removeObserver(InstructionListObserver instructionListObserver) {
        if (this.observers != null) {
            this.observers.remove(instructionListObserver);
        }
    }

    public void update() {
        if (this.observers != null) {
            Iterator iterator = this.observers.iterator();
            while (iterator.hasNext()) {
                ((InstructionListObserver)iterator.next()).notify(this);
            }
        }
    }
}

