/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.LocalVariableInstruction;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.generic.Visitor;
import com.sun.org.apache.bcel.internal.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public class IINC
extends LocalVariableInstruction {
    private boolean wide;
    private int c;

    IINC() {
    }

    public IINC(int n2, int n3) {
        this.opcode = (short)132;
        this.length = (short)3;
        this.setIndex(n2);
        this.setIncrement(n3);
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        if (this.wide) {
            dataOutputStream.writeByte(196);
        }
        dataOutputStream.writeByte(this.opcode);
        if (this.wide) {
            dataOutputStream.writeShort(this.n);
            dataOutputStream.writeShort(this.c);
        } else {
            dataOutputStream.writeByte(this.n);
            dataOutputStream.writeByte(this.c);
        }
    }

    private final void setWide() {
        this.wide = this.n > 65535 || Math.abs(this.c) > 127;
        this.length = this.wide ? (short)6 : (short)3;
    }

    protected void initFromFile(ByteSequence byteSequence, boolean bl2) throws IOException {
        this.wide = bl2;
        if (bl2) {
            this.length = (short)6;
            this.n = byteSequence.readUnsignedShort();
            this.c = byteSequence.readShort();
        } else {
            this.length = (short)3;
            this.n = byteSequence.readUnsignedByte();
            this.c = byteSequence.readByte();
        }
    }

    public String toString(boolean bl2) {
        return super.toString(bl2) + " " + this.c;
    }

    public final void setIndex(int n2) {
        if (n2 < 0) {
            throw new ClassGenException("Negative index value: " + n2);
        }
        this.n = n2;
        this.setWide();
    }

    public final int getIncrement() {
        return this.c;
    }

    public final void setIncrement(int n2) {
        this.c = n2;
        this.setWide();
    }

    public Type getType(ConstantPoolGen constantPoolGen) {
        return Type.INT;
    }

    public void accept(Visitor visitor) {
        visitor.visitLocalVariableInstruction(this);
        visitor.visitIINC(this);
    }
}

