/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap.sasl;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;

final class DefaultCallbackHandler
implements CallbackHandler {
    private char[] passwd;
    private String authenticationID;
    private String authRealm;

    DefaultCallbackHandler(String string, Object object, String string2) throws IOException {
        this.authenticationID = string;
        this.authRealm = string2;
        if (object instanceof String) {
            this.passwd = ((String)object).toCharArray();
        } else if (object instanceof char[]) {
            this.passwd = (char[])((char[])object).clone();
        } else if (object != null) {
            String string3 = new String((byte[])object, "UTF8");
            this.passwd = string3.toCharArray();
        }
    }

    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        for (int i2 = 0; i2 < callbackArray.length; ++i2) {
            Object object;
            if (callbackArray[i2] instanceof NameCallback) {
                ((NameCallback)callbackArray[i2]).setName(this.authenticationID);
                continue;
            }
            if (callbackArray[i2] instanceof PasswordCallback) {
                ((PasswordCallback)callbackArray[i2]).setPassword(this.passwd);
                continue;
            }
            if (callbackArray[i2] instanceof RealmChoiceCallback) {
                object = ((RealmChoiceCallback)callbackArray[i2]).getChoices();
                int n2 = 0;
                if (this.authRealm != null && this.authRealm.length() > 0) {
                    n2 = -1;
                    for (int i3 = 0; i3 < ((Object)object).length; ++i3) {
                        if (!((String)object[i3]).equals(this.authRealm)) continue;
                        n2 = i3;
                    }
                    if (n2 == -1) {
                        StringBuffer stringBuffer = new StringBuffer();
                        for (int i4 = 0; i4 < ((Object)object).length; ++i4) {
                            stringBuffer.append((String)object[i4] + ",");
                        }
                        throw new IOException("Cannot match 'java.naming.security.sasl.realm' property value, '" + this.authRealm + "' with choices " + stringBuffer + "in RealmChoiceCallback");
                    }
                }
                ((RealmChoiceCallback)callbackArray[i2]).setSelectedIndex(n2);
                continue;
            }
            if (callbackArray[i2] instanceof RealmCallback) {
                object = (RealmCallback)callbackArray[i2];
                if (this.authRealm != null) {
                    ((TextInputCallback)object).setText(this.authRealm);
                    continue;
                }
                String string = ((TextInputCallback)object).getDefaultText();
                if (string != null) {
                    ((TextInputCallback)object).setText(string);
                    continue;
                }
                ((TextInputCallback)object).setText("");
                continue;
            }
            throw new UnsupportedCallbackException(callbackArray[i2]);
        }
    }

    void clearPassword() {
        if (this.passwd != null) {
            for (int i2 = 0; i2 < this.passwd.length; ++i2) {
                this.passwd[i2] = '\u0000';
            }
            this.passwd = null;
        }
    }

    protected void finalize() throws Throwable {
        this.clearPassword();
    }
}

