/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.Constants;
import com.sun.java.util.jar.pack.Utils;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Set;

abstract class ConstantPool
implements Constants {
    private static final HashMap utf8Entries = new HashMap();
    private static final HashMap classEntries = new HashMap();
    private static final HashMap literalEntries = new HashMap();
    private static final HashMap signatureEntries = new HashMap();
    private static final HashMap descriptorEntries = new HashMap();
    private static final HashMap memberEntries = new HashMap();
    protected static final Entry[] noRefs = new Entry[0];
    protected static final ClassEntry[] noClassRefs = new ClassEntry[0];
    static final byte[] TAGS_IN_ORDER = new byte[]{1, 3, 4, 5, 6, 8, 7, 13, 12, 9, 10, 11};
    static final byte[] TAG_ORDER = new byte[14];

    private ConstantPool() {
    }

    static int verbose() {
        return Utils.currentPropMap().getInteger("com.sun.java.util.jar.pack.verbose");
    }

    public static synchronized Utf8Entry getUtf8Entry(String string) {
        Utf8Entry utf8Entry = (Utf8Entry)utf8Entries.get(string);
        if (utf8Entry == null) {
            utf8Entry = new Utf8Entry(string);
            utf8Entries.put(utf8Entry.stringValue(), utf8Entry);
        }
        return utf8Entry;
    }

    public static synchronized ClassEntry getClassEntry(String string) {
        ClassEntry classEntry = (ClassEntry)classEntries.get(string);
        if (classEntry == null) {
            classEntry = new ClassEntry(ConstantPool.getUtf8Entry(string));
            assert (string.equals(classEntry.stringValue()));
            classEntries.put(classEntry.stringValue(), classEntry);
        }
        return classEntry;
    }

    public static synchronized LiteralEntry getLiteralEntry(Comparable comparable) {
        LiteralEntry literalEntry = (LiteralEntry)literalEntries.get(comparable);
        if (literalEntry == null) {
            literalEntry = comparable instanceof String ? new StringEntry(ConstantPool.getUtf8Entry((String)((Object)comparable))) : new NumberEntry((Number)((Object)comparable));
            literalEntries.put(comparable, literalEntry);
        }
        return literalEntry;
    }

    public static synchronized StringEntry getStringEntry(String string) {
        return (StringEntry)ConstantPool.getLiteralEntry((Comparable)((Object)string));
    }

    public static synchronized SignatureEntry getSignatureEntry(String string) {
        SignatureEntry signatureEntry = (SignatureEntry)signatureEntries.get(string);
        if (signatureEntry == null) {
            signatureEntry = new SignatureEntry(string);
            assert (signatureEntry.stringValue().equals(string));
            signatureEntries.put(string, signatureEntry);
        }
        return signatureEntry;
    }

    public static SignatureEntry getSignatureEntry(Utf8Entry utf8Entry, ClassEntry[] classEntryArray) {
        return ConstantPool.getSignatureEntry(SignatureEntry.stringValueOf(utf8Entry, classEntryArray));
    }

    public static synchronized DescriptorEntry getDescriptorEntry(Utf8Entry utf8Entry, SignatureEntry signatureEntry) {
        String string = DescriptorEntry.stringValueOf(utf8Entry, signatureEntry);
        DescriptorEntry descriptorEntry = (DescriptorEntry)descriptorEntries.get(string);
        if (descriptorEntry == null) {
            descriptorEntry = new DescriptorEntry(utf8Entry, signatureEntry);
            assert (descriptorEntry.stringValue().equals(string)) : descriptorEntry.stringValue() + " != " + string;
            descriptorEntries.put(string, descriptorEntry);
        }
        return descriptorEntry;
    }

    public static DescriptorEntry getDescriptorEntry(Utf8Entry utf8Entry, Utf8Entry utf8Entry2) {
        return ConstantPool.getDescriptorEntry(utf8Entry, ConstantPool.getSignatureEntry(utf8Entry2.stringValue()));
    }

    public static synchronized MemberEntry getMemberEntry(byte by, ClassEntry classEntry, DescriptorEntry descriptorEntry) {
        String string = MemberEntry.stringValueOf(by, classEntry, descriptorEntry);
        MemberEntry memberEntry = (MemberEntry)memberEntries.get(string);
        if (memberEntry == null) {
            memberEntry = new MemberEntry(by, classEntry, descriptorEntry);
            assert (memberEntry.stringValue().equals(string)) : memberEntry.stringValue() + " != " + string;
            memberEntries.put(string, memberEntry);
        }
        return memberEntry;
    }

    static boolean isMemberTag(byte by) {
        switch (by) {
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    static byte numberTagOf(Number number) {
        if (number instanceof Integer) {
            return 3;
        }
        if (number instanceof Float) {
            return 4;
        }
        if (number instanceof Long) {
            return 5;
        }
        if (number instanceof Double) {
            return 6;
        }
        throw new RuntimeException("bad literal value " + number);
    }

    static int compareSignatures(String string, String string2) {
        return ConstantPool.compareSignatures(string, string2, null, null);
    }

    static int compareSignatures(String string, String string2, String[] stringArray, String[] stringArray2) {
        int n2;
        char c2 = string.charAt(0);
        char c3 = string2.charAt(0);
        if (c2 != '(' && c3 == '(') {
            return -1;
        }
        if (c3 != '(' && c2 == '(') {
            return 1;
        }
        if (stringArray == null) {
            stringArray = ConstantPool.structureSignature(string);
        }
        if (stringArray2 == null) {
            stringArray2 = ConstantPool.structureSignature(string2);
        }
        if (stringArray.length != stringArray2.length) {
            return stringArray.length - stringArray2.length;
        }
        int n3 = n2 = stringArray.length;
        while (--n3 >= 0) {
            int n4 = stringArray[n3].compareTo(stringArray2[n3]);
            if (n4 == 0) continue;
            return n4;
        }
        assert (string.equals(string2));
        return 0;
    }

    static int countClassParts(Utf8Entry utf8Entry) {
        int n2 = 0;
        String string = utf8Entry.stringValue();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2) != 'L') continue;
            ++n2;
        }
        return n2;
    }

    static String flattenSignature(String[] stringArray) {
        String string = stringArray[0];
        if (stringArray.length == 1) {
            return string;
        }
        int n2 = string.length();
        for (int i2 = 1; i2 < stringArray.length; ++i2) {
            n2 += stringArray[i2].length();
        }
        char[] cArray = new char[n2];
        int n3 = 0;
        int n4 = 1;
        for (int i3 = 0; i3 < string.length(); ++i3) {
            char c2 = string.charAt(i3);
            cArray[n3++] = c2;
            if (c2 != 'L') continue;
            String string2 = stringArray[n4++];
            string2.getChars(0, string2.length(), cArray, n3);
            n3 += string2.length();
        }
        assert (n3 == n2);
        assert (n4 == stringArray.length);
        return new String(cArray);
    }

    private static int skipClassNameChars(String string, int n2) {
        char c2;
        int n3 = string.length();
        while (n2 < n3 && (c2 = string.charAt(n2)) > ' ' && (c2 < ';' || c2 > '@')) {
            ++n2;
        }
        return n2;
    }

    static String[] structureSignature(String string) {
        int n2;
        int n3;
        string = string.intern();
        int n4 = 0;
        int n5 = 1;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            ++n4;
            if (c2 != 'L') continue;
            ++n5;
            n3 = ConstantPool.skipClassNameChars(string, i2 + 1);
            n2 = string.indexOf(60, (i2 = n3 - 1) + 1);
            if (n2 <= 0 || n2 >= n3) continue;
            i2 = n2 - 1;
        }
        char[] cArray = new char[n4];
        if (n5 == 1) {
            String[] stringArray = new String[]{string};
            return stringArray;
        }
        String[] stringArray = new String[n5];
        n3 = 0;
        n2 = 1;
        for (int i3 = 0; i3 < string.length(); ++i3) {
            char c3 = string.charAt(i3);
            cArray[n3++] = c3;
            if (c3 != 'L') continue;
            int n6 = ConstantPool.skipClassNameChars(string, i3 + 1);
            stringArray[n2++] = string.substring(i3 + 1, n6);
            i3 = n6;
            --i3;
        }
        assert (n3 == n4);
        assert (n2 == stringArray.length);
        stringArray[0] = new String(cArray);
        return stringArray;
    }

    public static Index makeIndex(String string, Entry[] entryArray) {
        return new Index(string, entryArray);
    }

    public static Index makeIndex(String string, Collection collection) {
        return new Index(string, collection);
    }

    public static void sort(Index index) {
        index.clearIndex();
        Arrays.sort(index.cpMap);
        if (ConstantPool.verbose() > 2) {
            System.out.println("sorted " + index.dumpString());
        }
    }

    public static Index[] partition(Index index, int[] nArray) {
        ArrayList arrayList;
        int n2;
        ArrayList<ArrayList<Entry>> arrayList2 = new ArrayList<ArrayList<Entry>>();
        Entry[] entryArray = index.cpMap;
        assert (nArray.length == entryArray.length);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            n2 = nArray[i2];
            if (n2 < 0) continue;
            while (n2 >= arrayList2.size()) {
                arrayList2.add(null);
            }
            arrayList = (ArrayList)arrayList2.get(n2);
            if (arrayList == null) {
                arrayList = new ArrayList();
                arrayList2.set(n2, arrayList);
            }
            arrayList.add(entryArray[i2]);
        }
        Index[] indexArray = new Index[arrayList2.size()];
        for (n2 = 0; n2 < indexArray.length; ++n2) {
            arrayList = (ArrayList)arrayList2.get(n2);
            if (arrayList == null) continue;
            indexArray[n2] = new Index(index.debugName + "/part#" + n2, arrayList);
            assert (indexArray[n2].indexOf(arrayList.get(0)) == 0);
        }
        return indexArray;
    }

    public static Index[] partitionByTag(Index index) {
        Entry[] entryArray = index.cpMap;
        int[] nArray = new int[entryArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            Entry entry = entryArray[i2];
            nArray[i2] = entry == null ? -1 : (int)entry.tag;
        }
        Index[] indexArray = ConstantPool.partition(index, nArray);
        for (int i3 = 0; i3 < indexArray.length; ++i3) {
            if (indexArray[i3] == null) continue;
            indexArray[i3].debugName = ConstantPool.tagName(i3);
        }
        if (indexArray.length < 14) {
            Index[] indexArray2 = new Index[14];
            System.arraycopy(indexArray, 0, indexArray2, 0, indexArray.length);
            indexArray = indexArray2;
        }
        return indexArray;
    }

    public static void completeReferencesIn(Set set, boolean bl2) {
        set.remove(null);
        ListIterator<Entry> listIterator = new ArrayList(set).listIterator(set.size());
        while (listIterator.hasPrevious()) {
            Entry entry;
            Entry entry2 = (Entry)listIterator.previous();
            listIterator.remove();
            assert (entry2 != null);
            if (bl2 && entry2.tag == 13) {
                SignatureEntry signatureEntry = (SignatureEntry)entry2;
                entry = signatureEntry.asUtf8Entry();
                set.remove(signatureEntry);
                set.add(entry);
                entry2 = entry;
            }
            int n2 = 0;
            while ((entry = entry2.getRef(n2)) != null) {
                if (set.add(entry)) {
                    listIterator.add(entry);
                }
                ++n2;
            }
        }
    }

    static double percent(int n2, int n3) {
        return (double)((int)(10000.0 * (double)n2 / (double)n3 + 0.5)) / 100.0;
    }

    public static String tagName(int n2) {
        switch (n2) {
            case 1: {
                return "Utf8";
            }
            case 3: {
                return "Integer";
            }
            case 4: {
                return "Float";
            }
            case 5: {
                return "Long";
            }
            case 6: {
                return "Double";
            }
            case 7: {
                return "Class";
            }
            case 8: {
                return "String";
            }
            case 9: {
                return "Fieldref";
            }
            case 10: {
                return "Methodref";
            }
            case 11: {
                return "InterfaceMethodref";
            }
            case 12: {
                return "NameandType";
            }
            case 19: {
                return "*All";
            }
            case 0: {
                return "*None";
            }
            case 13: {
                return "*Signature";
            }
        }
        return "tag#" + n2;
    }

    static {
        for (int i2 = 0; i2 < TAGS_IN_ORDER.length; ++i2) {
            ConstantPool.TAG_ORDER[ConstantPool.TAGS_IN_ORDER[i2]] = (byte)(i2 + 1);
        }
    }

    public static class ClassEntry
    extends Entry {
        final Utf8Entry ref;

        public Entry getRef(int n2) {
            return n2 == 0 ? this.ref : null;
        }

        protected int computeValueHash() {
            return this.ref.hashCode() + this.tag;
        }

        ClassEntry(Entry entry) {
            super((byte)7);
            this.ref = (Utf8Entry)entry;
            this.hashCode();
        }

        public boolean equals(Object object) {
            if (!this.sameTagAs(object)) {
                return false;
            }
            return ((ClassEntry)object).ref.eq(this.ref);
        }

        public int compareTo(Object object) {
            int n2 = this.superCompareTo(object);
            if (n2 == 0) {
                n2 = this.ref.compareTo(((ClassEntry)object).ref);
            }
            return n2;
        }

        public String stringValue() {
            return this.ref.stringValue();
        }
    }

    public static class DescriptorEntry
    extends Entry {
        final Utf8Entry nameRef;
        final SignatureEntry typeRef;

        public Entry getRef(int n2) {
            if (n2 == 0) {
                return this.nameRef;
            }
            if (n2 == 1) {
                return this.typeRef;
            }
            return null;
        }

        DescriptorEntry(Entry entry, Entry entry2) {
            super((byte)12);
            if (entry2 instanceof Utf8Entry) {
                entry2 = ConstantPool.getSignatureEntry(entry2.stringValue());
            }
            this.nameRef = (Utf8Entry)entry;
            this.typeRef = (SignatureEntry)entry2;
            this.hashCode();
        }

        protected int computeValueHash() {
            int n2 = this.typeRef.hashCode();
            return this.nameRef.hashCode() + (n2 << 8) ^ n2;
        }

        public boolean equals(Object object) {
            if (!this.sameTagAs(object)) {
                return false;
            }
            DescriptorEntry descriptorEntry = (DescriptorEntry)object;
            return this.nameRef.eq(descriptorEntry.nameRef) && this.typeRef.eq(descriptorEntry.typeRef);
        }

        public int compareTo(Object object) {
            int n2 = this.superCompareTo(object);
            if (n2 == 0) {
                DescriptorEntry descriptorEntry = (DescriptorEntry)object;
                n2 = this.typeRef.compareTo(descriptorEntry.typeRef);
                if (n2 == 0) {
                    n2 = this.nameRef.compareTo(descriptorEntry.nameRef);
                }
            }
            return n2;
        }

        public String stringValue() {
            return DescriptorEntry.stringValueOf(this.nameRef, this.typeRef);
        }

        static String stringValueOf(Entry entry, Entry entry2) {
            return entry2.stringValue() + "," + entry.stringValue();
        }

        public String prettyString() {
            return this.nameRef.stringValue() + this.typeRef.prettyString();
        }

        public boolean isMethod() {
            return this.typeRef.isMethod();
        }

        public byte getLiteralTag() {
            return this.typeRef.getLiteralTag();
        }
    }

    public static abstract class Entry
    implements Comparable {
        protected final byte tag;
        protected int valueHash;

        protected Entry(byte by) {
            this.tag = by;
        }

        public final byte getTag() {
            return this.tag;
        }

        public Entry getRef(int n2) {
            return null;
        }

        public boolean sameTagAs(Object object) {
            return object instanceof Entry && ((Entry)object).tag == this.tag;
        }

        public boolean eq(Entry entry) {
            assert (entry != null);
            return this == entry || this.equals(entry);
        }

        public abstract boolean equals(Object var1);

        public final int hashCode() {
            if (this.valueHash == 0) {
                this.valueHash = this.computeValueHash();
                if (this.valueHash == 0) {
                    this.valueHash = 1;
                }
            }
            return this.valueHash;
        }

        protected abstract int computeValueHash();

        public abstract int compareTo(Object var1);

        protected int superCompareTo(Object object) {
            Entry entry = (Entry)object;
            if (this.tag != entry.tag) {
                return TAG_ORDER[this.tag] - TAG_ORDER[entry.tag];
            }
            return 0;
        }

        public final boolean isDoubleWord() {
            return this.tag == 6 || this.tag == 5;
        }

        public final boolean tagMatches(int n2) {
            return this.tag == n2;
        }

        public String toString() {
            String string = this.stringValue();
            if (ConstantPool.verbose() > 4) {
                if (this.valueHash != 0) {
                    string = string + " hash=" + this.valueHash;
                }
                string = string + " id=" + System.identityHashCode(this);
            }
            return ConstantPool.tagName(this.tag) + "=" + string;
        }

        public abstract String stringValue();
    }

    public static class Index
    extends AbstractList {
        protected String debugName;
        protected Entry[] cpMap;
        protected boolean flattenSigs;
        protected Entry[] indexKey;
        protected int[] indexValue;

        protected Entry[] getMap() {
            return this.cpMap;
        }

        protected Index(String string) {
            this.debugName = string;
        }

        protected Index(String string, Entry[] entryArray) {
            this(string);
            this.setMap(entryArray);
        }

        protected void setMap(Entry[] entryArray) {
            this.clearIndex();
            this.cpMap = entryArray;
        }

        protected Index(String string, Collection collection) {
            this(string);
            this.setMap(collection);
        }

        protected void setMap(Collection collection) {
            this.cpMap = new Entry[collection.size()];
            collection.toArray(this.cpMap);
            this.setMap(this.cpMap);
        }

        public int size() {
            return this.cpMap.length;
        }

        public Object get(int n2) {
            return this.cpMap[n2];
        }

        public Entry getEntry(int n2) {
            return this.cpMap[n2];
        }

        private int findIndexOf(Entry entry) {
            int n2;
            if (this.indexKey == null) {
                this.initializeIndex();
            }
            if (this.indexKey[n2 = this.findIndexLocation(entry)] != entry) {
                if (this.flattenSigs && entry.tag == 13) {
                    SignatureEntry signatureEntry = (SignatureEntry)entry;
                    return this.findIndexOf(signatureEntry.asUtf8Entry());
                }
                return -1;
            }
            int n3 = this.indexValue[n2];
            assert (entry.equals(this.cpMap[n3]));
            return n3;
        }

        public boolean contains(Entry entry) {
            return this.findIndexOf(entry) >= 0;
        }

        public int indexOf(Entry entry) {
            int n2 = this.findIndexOf(entry);
            if (n2 < 0 && ConstantPool.verbose() > 0) {
                System.out.println("not found: " + entry);
                System.out.println("       in: " + this.dumpString());
                Thread.dumpStack();
            }
            assert (n2 >= 0);
            return n2;
        }

        public boolean contains(Object object) {
            return this.findIndexOf((Entry)object) >= 0;
        }

        public int indexOf(Object object) {
            return this.findIndexOf((Entry)object);
        }

        public int lastIndexOf(Object object) {
            return this.indexOf(object);
        }

        public boolean assertIsSorted() {
            for (int i2 = 1; i2 < this.cpMap.length; ++i2) {
                if (this.cpMap[i2 - 1].compareTo(this.cpMap[i2]) <= 0) continue;
                System.out.println("Not sorted at " + (i2 - 1) + "/" + i2 + ": " + this.dumpString());
                return false;
            }
            return true;
        }

        protected void clearIndex() {
            this.indexKey = null;
            this.indexValue = null;
        }

        private int findIndexLocation(Entry entry) {
            int n2 = this.indexKey.length;
            int n3 = entry.hashCode();
            int n4 = n3 & n2 - 1;
            int n5 = (n3 >>> 8 | 1) & n2 - 1;
            Entry entry2;
            while ((entry2 = this.indexKey[n4]) != entry && entry2 != null) {
                if ((n4 += n5) < n2) continue;
                n4 -= n2;
            }
            return n4;
        }

        private void initializeIndex() {
            int n2;
            if (ConstantPool.verbose() > 2) {
                System.out.println("initialize Index " + this.debugName + " [" + this.size() + "]");
            }
            int n3 = (int)((double)(this.cpMap.length + 10) * 1.5);
            for (n2 = 1; n2 < n3; n2 <<= 1) {
            }
            this.indexKey = new Entry[n2];
            this.indexValue = new int[n2];
            for (int i2 = 0; i2 < this.cpMap.length; ++i2) {
                Entry entry = this.cpMap[i2];
                if (entry == null) continue;
                int n4 = this.findIndexLocation(entry);
                assert (this.indexKey[n4] == null);
                this.indexKey[n4] = entry;
                this.indexValue[n4] = i2;
            }
        }

        public Object[] toArray(Object[] objectArray) {
            int n2 = this.size();
            if (objectArray.length < n2) {
                return super.toArray(objectArray);
            }
            System.arraycopy(this.cpMap, 0, objectArray, 0, n2);
            if (objectArray.length > n2) {
                objectArray[n2] = null;
            }
            return objectArray;
        }

        public Object[] toArray() {
            return this.toArray(new Entry[this.size()]);
        }

        public Object clone() {
            return new Index(this.debugName, (Entry[])this.cpMap.clone());
        }

        public String toString() {
            return "Index " + this.debugName + " [" + this.size() + "]";
        }

        public String dumpString() {
            String string = this.toString();
            string = string + " {\n";
            for (int i2 = 0; i2 < this.cpMap.length; ++i2) {
                string = string + "    " + i2 + ": " + this.cpMap[i2] + "\n";
            }
            string = string + "}";
            return string;
        }
    }

    public static class IndexGroup {
        private Index indexUntyped;
        private Index[] indexByTag = new Index[14];
        private int[] untypedFirstIndexByTag;
        private int totalSize;
        private Index[][] indexByTagAndClass;

        public Index getUntypedIndex() {
            if (this.indexUntyped == null) {
                this.untypedIndexOf(null);
                Entry[] entryArray = new Entry[this.totalSize];
                for (int i2 = 0; i2 < this.indexByTag.length; ++i2) {
                    int n2;
                    Index index = this.indexByTag[i2];
                    if (index == null || (n2 = index.cpMap.length) == 0) continue;
                    int n3 = this.untypedFirstIndexByTag[i2];
                    assert (entryArray[n3] == null);
                    assert (entryArray[n3 + n2 - 1] == null);
                    System.arraycopy(index.cpMap, 0, entryArray, n3, n2);
                }
                this.indexUntyped = new Index("untyped", entryArray);
            }
            return this.indexUntyped;
        }

        public int untypedIndexOf(Entry entry) {
            int n2;
            int n3;
            if (this.untypedFirstIndexByTag == null) {
                this.untypedFirstIndexByTag = new int[14];
                n3 = 0;
                for (int i2 = 0; i2 < TAGS_IN_ORDER.length; ++i2) {
                    n2 = TAGS_IN_ORDER[i2];
                    Index index = this.indexByTag[n2];
                    if (index == null) continue;
                    int n4 = index.cpMap.length;
                    this.untypedFirstIndexByTag[n2] = n3;
                    n3 += n4;
                }
                this.totalSize = n3;
            }
            if (entry == null) {
                return -1;
            }
            n3 = entry.tag;
            Index index = this.indexByTag[n3];
            if (index == null) {
                return -1;
            }
            n2 = index.findIndexOf(entry);
            if (n2 >= 0) {
                n2 += this.untypedFirstIndexByTag[n3];
            }
            return n2;
        }

        public void initIndexByTag(byte by, Index index) {
            assert (this.indexByTag[by] == null);
            Entry[] entryArray = index.cpMap;
            for (int i2 = 0; i2 < entryArray.length; ++i2) {
                assert (entryArray[i2].tag == by);
            }
            if (by == 1) assert (entryArray.length == 0 || entryArray[0].stringValue().equals(""));
            this.indexByTag[by] = index;
            this.untypedFirstIndexByTag = null;
            this.indexUntyped = null;
            if (this.indexByTagAndClass != null) {
                this.indexByTagAndClass[by] = null;
            }
        }

        public Index getIndexByTag(byte by) {
            if (by == 19) {
                return this.getUntypedIndex();
            }
            Index index = this.indexByTag[by];
            if (index == null) {
                this.indexByTag[by] = index = new Index(ConstantPool.tagName(by), new Entry[0]);
            }
            return index;
        }

        public Index getMemberIndex(byte by, ClassEntry classEntry) {
            if (this.indexByTagAndClass == null) {
                this.indexByTagAndClass = new Index[14][];
            }
            Index index = this.getIndexByTag((byte)7);
            Index[] indexArray = this.indexByTagAndClass[by];
            if (indexArray == null) {
                int n2;
                Index index2 = this.getIndexByTag(by);
                int[] nArray = new int[index2.size()];
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    int n3;
                    MemberEntry memberEntry = (MemberEntry)index2.get(n2);
                    nArray[n2] = n3 = index.indexOf(memberEntry.classRef);
                }
                indexArray = ConstantPool.partition(index2, nArray);
                for (n2 = 0; n2 < indexArray.length; ++n2) {
                    assert (indexArray[n2] == null || indexArray[n2].assertIsSorted());
                }
                this.indexByTagAndClass[by] = indexArray;
            }
            int n4 = index.indexOf(classEntry);
            return indexArray[n4];
        }

        public int getOverloadingIndex(MemberEntry memberEntry) {
            Index index = this.getMemberIndex(memberEntry.tag, memberEntry.classRef);
            Utf8Entry utf8Entry = memberEntry.descRef.nameRef;
            int n2 = 0;
            for (int i2 = 0; i2 < index.cpMap.length; ++i2) {
                MemberEntry memberEntry2 = (MemberEntry)index.cpMap[i2];
                if (memberEntry2.equals(memberEntry)) {
                    return n2;
                }
                if (!memberEntry2.descRef.nameRef.equals(utf8Entry)) continue;
                ++n2;
            }
            throw new RuntimeException("should not reach here");
        }

        public MemberEntry getOverloadingForIndex(byte by, ClassEntry classEntry, String string, int n2) {
            assert (string == string.intern());
            Index index = this.getMemberIndex(by, classEntry);
            int n3 = 0;
            for (int i2 = 0; i2 < index.cpMap.length; ++i2) {
                MemberEntry memberEntry = (MemberEntry)index.cpMap[i2];
                if (memberEntry.descRef.nameRef.stringValue() != string) continue;
                if (n3 == n2) {
                    return memberEntry;
                }
                ++n3;
            }
            throw new RuntimeException("should not reach here");
        }

        public boolean haveNumbers() {
            for (byte by = 3; by <= 6; by = (byte)(by + 1)) {
                switch (by) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                if (this.getIndexByTag(by).size() <= 0) continue;
                return true;
            }
            return false;
        }
    }

    public static abstract class LiteralEntry
    extends Entry {
        protected LiteralEntry(byte by) {
            super(by);
        }

        public abstract Comparable literalValue();
    }

    public static class MemberEntry
    extends Entry {
        final ClassEntry classRef;
        final DescriptorEntry descRef;

        public Entry getRef(int n2) {
            if (n2 == 0) {
                return this.classRef;
            }
            if (n2 == 1) {
                return this.descRef;
            }
            return null;
        }

        protected int computeValueHash() {
            int n2 = this.descRef.hashCode();
            return this.classRef.hashCode() + (n2 << 8) ^ n2;
        }

        MemberEntry(byte by, ClassEntry classEntry, DescriptorEntry descriptorEntry) {
            super(by);
            assert (ConstantPool.isMemberTag(by));
            this.classRef = classEntry;
            this.descRef = descriptorEntry;
            this.hashCode();
        }

        public boolean equals(Object object) {
            if (!this.sameTagAs(object)) {
                return false;
            }
            MemberEntry memberEntry = (MemberEntry)object;
            return this.classRef.eq(memberEntry.classRef) && this.descRef.eq(memberEntry.descRef);
        }

        public int compareTo(Object object) {
            int n2 = this.superCompareTo(object);
            if (n2 == 0) {
                MemberEntry memberEntry = (MemberEntry)object;
                n2 = this.classRef.compareTo(memberEntry.classRef);
                if (n2 == 0) {
                    n2 = this.descRef.compareTo(memberEntry.descRef);
                }
            }
            return n2;
        }

        public String stringValue() {
            return MemberEntry.stringValueOf(this.tag, this.classRef, this.descRef);
        }

        static String stringValueOf(byte by, ClassEntry classEntry, DescriptorEntry descriptorEntry) {
            String string;
            assert (ConstantPool.isMemberTag(by));
            switch (by) {
                case 9: {
                    string = "Field:";
                    break;
                }
                case 10: {
                    string = "Method:";
                    break;
                }
                case 11: {
                    string = "IMethod:";
                    break;
                }
                default: {
                    string = by + "???";
                }
            }
            return string + classEntry.stringValue() + "," + descriptorEntry.stringValue();
        }

        public boolean isMethod() {
            return this.descRef.isMethod();
        }
    }

    public static class NumberEntry
    extends LiteralEntry {
        final Number value;

        NumberEntry(Number number) {
            super(ConstantPool.numberTagOf(number));
            this.value = number;
            this.hashCode();
        }

        protected int computeValueHash() {
            return this.value.hashCode();
        }

        public boolean equals(Object object) {
            if (!this.sameTagAs(object)) {
                return false;
            }
            return ((NumberEntry)object).value.equals(this.value);
        }

        public int compareTo(Object object) {
            int n2 = this.superCompareTo(object);
            if (n2 == 0) {
                n2 = ((Comparable)((Object)this.value)).compareTo(((NumberEntry)object).value);
            }
            return n2;
        }

        public Number numberValue() {
            return this.value;
        }

        public Comparable literalValue() {
            return (Comparable)((Object)this.value);
        }

        public String stringValue() {
            return this.value.toString();
        }
    }

    public static class SignatureEntry
    extends Entry {
        final Utf8Entry formRef;
        final ClassEntry[] classRefs;
        String value;
        Utf8Entry asUtf8Entry;

        public Entry getRef(int n2) {
            if (n2 == 0) {
                return this.formRef;
            }
            return n2 - 1 < this.classRefs.length ? this.classRefs[n2 - 1] : null;
        }

        SignatureEntry(String string) {
            super((byte)13);
            this.value = string = string.intern();
            String[] stringArray = ConstantPool.structureSignature(string);
            this.formRef = ConstantPool.getUtf8Entry(stringArray[0]);
            this.classRefs = new ClassEntry[stringArray.length - 1];
            for (int i2 = 1; i2 < stringArray.length; ++i2) {
                this.classRefs[i2 - 1] = ConstantPool.getClassEntry(stringArray[i2]);
            }
            this.hashCode();
        }

        protected int computeValueHash() {
            this.stringValue();
            return this.value.hashCode() + this.tag;
        }

        public Utf8Entry asUtf8Entry() {
            if (this.asUtf8Entry == null) {
                this.asUtf8Entry = ConstantPool.getUtf8Entry(this.stringValue());
            }
            return this.asUtf8Entry;
        }

        public boolean equals(Object object) {
            if (!this.sameTagAs(object)) {
                return false;
            }
            return ((SignatureEntry)object).value == this.value;
        }

        public int compareTo(Object object) {
            int n2 = this.superCompareTo(object);
            if (n2 == 0) {
                SignatureEntry signatureEntry = (SignatureEntry)object;
                n2 = ConstantPool.compareSignatures(this.value, signatureEntry.value);
            }
            return n2;
        }

        public String stringValue() {
            if (this.value == null) {
                this.value = SignatureEntry.stringValueOf(this.formRef, this.classRefs);
            }
            return this.value;
        }

        static String stringValueOf(Utf8Entry utf8Entry, ClassEntry[] classEntryArray) {
            String[] stringArray = new String[1 + classEntryArray.length];
            stringArray[0] = utf8Entry.stringValue();
            for (int i2 = 1; i2 < stringArray.length; ++i2) {
                stringArray[i2] = classEntryArray[i2 - 1].stringValue();
            }
            return ConstantPool.flattenSignature(stringArray).intern();
        }

        public int computeSize(boolean bl2) {
            String string = this.formRef.stringValue();
            int n2 = 0;
            int n3 = 1;
            if (this.isMethod()) {
                n2 = 1;
                n3 = string.indexOf(41);
            }
            int n4 = 0;
            block5: for (int i2 = n2; i2 < n3; ++i2) {
                switch (string.charAt(i2)) {
                    case 'D': 
                    case 'J': {
                        if (!bl2) break;
                        ++n4;
                        break;
                    }
                    case '[': {
                        while (string.charAt(i2) == '[') {
                            ++i2;
                        }
                        break;
                    }
                    case ';': {
                        continue block5;
                    }
                    default: {
                        assert (0 <= "BSCIJFDZLV([".indexOf(string.charAt(i2)));
                        break;
                    }
                }
                ++n4;
            }
            return n4;
        }

        public boolean isMethod() {
            return this.formRef.stringValue().charAt(0) == '(';
        }

        public byte getLiteralTag() {
            switch (this.formRef.stringValue().charAt(0)) {
                case 'L': {
                    return 8;
                }
                case 'I': {
                    return 3;
                }
                case 'J': {
                    return 5;
                }
                case 'F': {
                    return 4;
                }
                case 'D': {
                    return 6;
                }
                case 'B': 
                case 'C': 
                case 'S': 
                case 'Z': {
                    return 3;
                }
            }
            assert (false);
            return 0;
        }

        public String prettyString() {
            int n2;
            String string;
            if (this.isMethod()) {
                string = this.formRef.stringValue();
                string = string.substring(0, 1 + string.indexOf(41));
            } else {
                string = "/" + this.formRef.stringValue();
            }
            while ((n2 = string.indexOf(59)) >= 0) {
                string = string.substring(0, n2) + string.substring(n2 + 1);
            }
            return string;
        }
    }

    public static class StringEntry
    extends LiteralEntry {
        final Utf8Entry ref;

        public Entry getRef(int n2) {
            return n2 == 0 ? this.ref : null;
        }

        StringEntry(Entry entry) {
            super((byte)8);
            this.ref = (Utf8Entry)entry;
            this.hashCode();
        }

        protected int computeValueHash() {
            return this.ref.hashCode() + this.tag;
        }

        public boolean equals(Object object) {
            if (!this.sameTagAs(object)) {
                return false;
            }
            return ((StringEntry)object).ref.eq(this.ref);
        }

        public int compareTo(Object object) {
            int n2 = this.superCompareTo(object);
            if (n2 == 0) {
                n2 = this.ref.compareTo(((StringEntry)object).ref);
            }
            return n2;
        }

        public Comparable literalValue() {
            return this.ref.stringValue();
        }

        public String stringValue() {
            return this.ref.stringValue();
        }
    }

    public static class Utf8Entry
    extends Entry {
        final String value;

        Utf8Entry(String string) {
            super((byte)1);
            this.value = string.intern();
            this.hashCode();
        }

        protected int computeValueHash() {
            return this.value.hashCode();
        }

        public boolean equals(Object object) {
            if (!this.sameTagAs(object)) {
                return false;
            }
            return ((Utf8Entry)object).value == this.value;
        }

        public int compareTo(Object object) {
            int n2 = this.superCompareTo(object);
            if (n2 == 0) {
                n2 = this.value.compareTo(((Utf8Entry)object).value);
            }
            return n2;
        }

        public String stringValue() {
            return this.value;
        }
    }
}

