/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.monitor.port;

import com.clustercontrol.bean.PortRunCountConstant;
import com.clustercontrol.bean.PortRunIntervalConstant;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.port.bean.MonitorPortInfo;
import com.clustercontrol.port.ejb.session.MonitorPortController;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import jp.co.intellilink.hinemos.export.monitor.ExportMonitorNumeric;
import jp.co.intellilink.hinemos.export.util.Config;
import jp.co.intellilink.hinemos.export.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.export.util.Messages;
import jp.co.intellilink.hinemos.export.util.StringListComparator;
import jp.co.intellilink.hinemos.export.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportMonitorPort
extends ExportMonitorNumeric {
    private static Log log = LogFactory.getLog(ExportMonitorPort.class);

    public ExportMonitorPort() {
        super(2);
    }

    public void exportPort() {
        log.info((Object)Messages.getMsg("ExportTool.Port.Start"));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList arrayList2 = this.getPortList();
        if (arrayList2 instanceof ArrayList) {
            for (ArrayList arrayList3 : arrayList2) {
                Object[] objectArray = new Object[]{(String)arrayList3.get(0)};
                log.info((Object)Messages.getMsg("ExportTool.MonitorID", objectArray));
                MonitorInfo monitorInfo = this.getPort((String)arrayList3.get(0));
                arrayList.add(this.createCsvFormat(monitorInfo));
            }
            Collections.sort(arrayList, new StringListComparator(0));
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        WriteCsvFile.writeCsvFile(Config.getConfig("Output.Dir") + "/PORT_" + simpleDateFormat.format(new Date()) + ".csv", arrayList);
        log.info((Object)Messages.getMsg("ExportTool.Port.End"));
    }

    @Override
    public ArrayList<String> createMonitorInfo(MonitorInfo monitorInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        MonitorPortInfo monitorPortInfo = (MonitorPortInfo)monitorInfo.getCheckInfo();
        if (monitorPortInfo == null) {
            monitorPortInfo = new MonitorPortInfo();
        }
        if (monitorPortInfo.getServiceId() == null || monitorPortInfo.getServiceId().equals("001")) {
            arrayList.add(com.clustercontrol.util.Messages.getString((String)"tcp.connect.only"));
        } else {
            arrayList.add("");
        }
        if (monitorPortInfo.getPortNo() != null) {
            arrayList.add(monitorPortInfo.getPortNo().toString());
        } else {
            arrayList.add("");
        }
        if (monitorPortInfo.getRunCount() != null) {
            arrayList.add(PortRunCountConstant.typeToString((int)monitorPortInfo.getRunCount()));
        } else {
            arrayList.add("");
        }
        if (monitorPortInfo.getRunInterval() != null) {
            arrayList.add(PortRunIntervalConstant.typeToString((int)monitorPortInfo.getRunInterval()));
        } else {
            arrayList.add("");
        }
        if (monitorPortInfo.getTimeout() != null) {
            arrayList.add(monitorPortInfo.getTimeout().toString());
        } else {
            arrayList.add("");
        }
        return arrayList;
    }

    protected MonitorInfo getPort(String string) {
        MonitorPortController monitorPortController = EjbConnectionManager.getConnectionManager().getMonitorPortController();
        MonitorInfo monitorInfo = null;
        try {
            monitorInfo = monitorPortController.getPort(string);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ExportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return monitorInfo;
    }

    protected ArrayList getPortList() {
        MonitorPortController monitorPortController = EjbConnectionManager.getConnectionManager().getMonitorPortController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorPortController.getPortList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ExportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

