/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.maintenance;

import com.clustercontrol.bean.DayOfWeekConstant;
import com.clustercontrol.bean.Schedule;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.maintenance.bean.MaintenanceInfoDataImp;
import com.clustercontrol.maintenance.bean.MaintenanceKeepMstConstant;
import com.clustercontrol.maintenance.bean.MaintenanceTypeMstConstant;
import com.clustercontrol.maintenance.ejb.session.MaintenanceController;
import com.clustercontrol.notify.bean.NotifyRelationInfo;
import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import jp.co.intellilink.hinemos.export.util.Config;
import jp.co.intellilink.hinemos.export.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.export.util.Messages;
import jp.co.intellilink.hinemos.export.util.StringListComparator;
import jp.co.intellilink.hinemos.export.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportMaintenamce {
    private static Log log = LogFactory.getLog(ExportMaintenamce.class);

    public void exportMaintenance() {
        log.info((Object)Messages.getMsg("ExportTool.Maintenance.Start"));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList arrayList2 = this.getMaintenanceIdList();
        if (arrayList2 instanceof ArrayList) {
            for (ArrayList arrayList3 : arrayList2) {
                Object[] objectArray = new Object[]{(String)arrayList3.get(0)};
                log.info((Object)Messages.getMsg("ExportTool.MaintenanceID", objectArray));
                MaintenanceInfoDataImp maintenanceInfoDataImp = this.getMaintenance((String)arrayList3.get(0));
                arrayList.add(this.createCsvFormat(maintenanceInfoDataImp));
            }
            Collections.sort(arrayList, new StringListComparator(0));
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        WriteCsvFile.writeCsvFile(Config.getConfig("Output.Dir") + "/MAINTENANCE_" + simpleDateFormat.format(new Date()) + ".csv", arrayList);
        log.info((Object)Messages.getMsg("ExportTool.Maintenance.End"));
    }

    public ArrayList<String> createCsvFormat(MaintenanceInfoDataImp maintenanceInfoDataImp) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(maintenanceInfoDataImp.getMaintenance_id());
        arrayList.add(maintenanceInfoDataImp.getDescription());
        arrayList.add(com.clustercontrol.util.Messages.getString((String)MaintenanceTypeMstConstant.typeIdToNameId((String)maintenanceInfoDataImp.getType_id())));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)MaintenanceKeepMstConstant.keepIdToNameId((String)maintenanceInfoDataImp.getKeep_id())));
        if (maintenanceInfoDataImp.getCalendar_id() != null) {
            arrayList.add(maintenanceInfoDataImp.getCalendar_id());
        } else {
            arrayList.add("");
        }
        arrayList.addAll(this.createSchedule(maintenanceInfoDataImp));
        arrayList.addAll(this.createNotify(maintenanceInfoDataImp));
        if (maintenanceInfoDataImp.getApplication() != null) {
            arrayList.add(maintenanceInfoDataImp.getApplication());
        } else {
            arrayList.add("");
        }
        arrayList.add(ValidConstant.typeToString((int)maintenanceInfoDataImp.getValid_flg()));
        return arrayList;
    }

    protected ArrayList<String> createNotify(MaintenanceInfoDataImp maintenanceInfoDataImp) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (maintenanceInfoDataImp.getNotifyId() != null) {
            Collection collection = maintenanceInfoDataImp.getNotifyId();
            for (int i = 0; i < collection.size(); ++i) {
                NotifyRelationInfo notifyRelationInfo = (NotifyRelationInfo)((ArrayList)collection).get(i);
                if (notifyRelationInfo.getNotifyType() == 0) {
                    string = notifyRelationInfo.getNotifyId();
                    continue;
                }
                if (notifyRelationInfo.getNotifyType() == 1) {
                    string2 = notifyRelationInfo.getNotifyId();
                    continue;
                }
                if (notifyRelationInfo.getNotifyType() == 2) {
                    string3 = notifyRelationInfo.getNotifyId();
                    continue;
                }
                if (notifyRelationInfo.getNotifyType() == 3) {
                    string4 = notifyRelationInfo.getNotifyId();
                    continue;
                }
                if (notifyRelationInfo.getNotifyType() != 4) continue;
                string5 = notifyRelationInfo.getNotifyId();
            }
        }
        arrayList.add(string);
        arrayList.add(string2);
        arrayList.add(string3);
        arrayList.add(string4);
        arrayList.add(string5);
        return arrayList;
    }

    protected ArrayList<String> createSchedule(MaintenanceInfoDataImp maintenanceInfoDataImp) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Schedule schedule = (Schedule)this.getSchedule(maintenanceInfoDataImp.getMaintenance_id()).get(5);
        if (schedule.getType() == 4) {
            arrayList.add(com.clustercontrol.util.Messages.getString((String)"weekday"));
        } else {
            arrayList.add(com.clustercontrol.util.Messages.getString((String)"time"));
        }
        if (schedule.getDate() instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(schedule.getDate());
            DecimalFormat decimalFormat = new DecimalFormat("00");
            if (schedule.getType() == 0) {
                arrayList.add(decimalFormat.format(calendar.get(2) + 1));
                arrayList.add(decimalFormat.format(calendar.get(5)));
                arrayList.add(decimalFormat.format(calendar.get(11)));
                arrayList.add(decimalFormat.format(calendar.get(12)));
            } else if (schedule.getType() == 1) {
                arrayList.add("");
                arrayList.add(decimalFormat.format(calendar.get(5)));
                arrayList.add(decimalFormat.format(calendar.get(11)));
                arrayList.add(decimalFormat.format(calendar.get(12)));
            } else if (schedule.getType() == 2) {
                arrayList.add("");
                arrayList.add("");
                arrayList.add(decimalFormat.format(calendar.get(11)));
                arrayList.add(decimalFormat.format(calendar.get(12)));
            } else if (schedule.getType() == 3) {
                arrayList.add("");
                arrayList.add("");
                arrayList.add("");
                arrayList.add(decimalFormat.format(calendar.get(12)));
            } else {
                arrayList.add("");
                arrayList.add("");
                arrayList.add("");
                arrayList.add("");
            }
            if (schedule.getType() == 4) {
                arrayList.add(DayOfWeekConstant.typeToString((int)schedule.getDayOfWeek()));
                arrayList.add(decimalFormat.format(calendar.get(11)));
                arrayList.add(decimalFormat.format(calendar.get(12)));
            } else {
                arrayList.add("");
                arrayList.add("");
                arrayList.add("");
            }
        } else {
            arrayList.add("");
            arrayList.add("");
            arrayList.add("");
            arrayList.add("");
            arrayList.add("");
            arrayList.add("");
            arrayList.add("");
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected MaintenanceInfoDataImp getMaintenance(String string) {
        MaintenanceController maintenanceController = EjbConnectionManager.getConnectionManager().getMaintenanceController();
        MaintenanceInfoDataImp maintenanceInfoDataImp = null;
        try {
            return maintenanceController.getMaintenanceInfo(string);
        }
        catch (RemoteException remoteException) {
            if (!(remoteException instanceof AccessException)) return maintenanceInfoDataImp;
        }
        catch (FinderException finderException) {
            return maintenanceInfoDataImp;
        }
        catch (NamingException namingException) {
            return maintenanceInfoDataImp;
        }
        catch (CreateException createException) {
            // empty catch block
        }
        return maintenanceInfoDataImp;
    }

    protected ArrayList getSchedule(String string) {
        MaintenanceController maintenanceController = EjbConnectionManager.getConnectionManager().getMaintenanceController();
        ArrayList arrayList = null;
        try {
            arrayList = maintenanceController.getSchedule(string);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ExportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }

    protected ArrayList getMaintenanceIdList() {
        MaintenanceController maintenanceController = EjbConnectionManager.getConnectionManager().getMaintenanceController();
        ArrayList arrayList = null;
        try {
            arrayList = maintenanceController.getMaintenanceList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ExportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

