/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.check;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import javax.naming.NamingException;
import jp.co.intellilink.hinemos.check.conf.CheckMonitor;
import jp.co.intellilink.hinemos.check.conf.CheckMonitorAgent;
import jp.co.intellilink.hinemos.check.conf.CheckMonitorHttp;
import jp.co.intellilink.hinemos.check.conf.CheckMonitorPerformance;
import jp.co.intellilink.hinemos.check.conf.CheckMonitorPing;
import jp.co.intellilink.hinemos.check.conf.CheckMonitorPort;
import jp.co.intellilink.hinemos.check.conf.CheckMonitorProcess;
import jp.co.intellilink.hinemos.check.conf.CheckMonitorSnmp;
import jp.co.intellilink.hinemos.check.conf.CheckMonitorSnmpTrap;
import jp.co.intellilink.hinemos.check.conf.CheckMonitorSql;
import jp.co.intellilink.hinemos.check.conf.CheckMonitorSyslogng;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.LoginManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.StringListComparator;
import jp.co.intellilink.hinemos.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CheckConf {
    private static String mode = "all";
    private static Log log = LogFactory.getLog(CheckConf.class);

    public static void main(String[] stringArray) {
        CheckMonitor checkMonitor;
        log.info((Object)(Messages.getMsg("CheckTool.Exec") + " : " + Arrays.toString(stringArray)));
        if (stringArray.length > 1) {
            log.error((Object)Messages.getMsg("ArgsInvalid"));
            System.exit(11);
        }
        if (stringArray.length == 0 || stringArray[0].equals("")) {
            mode = "all";
        } else if (stringArray.length == 1) {
            mode = stringArray[0];
        }
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        if (mode.equalsIgnoreCase("ping") || mode.equalsIgnoreCase("all")) {
            checkMonitor = new CheckMonitorPing();
            arrayList.add(((CheckMonitorPing)checkMonitor).checkPing());
        }
        if (mode.equalsIgnoreCase("agent") || mode.equalsIgnoreCase("all")) {
            checkMonitor = new CheckMonitorAgent();
            arrayList.add(((CheckMonitorAgent)checkMonitor).checkAgent());
        }
        if (mode.equalsIgnoreCase("process") || mode.equalsIgnoreCase("all")) {
            checkMonitor = new CheckMonitorProcess();
            arrayList.add(((CheckMonitorProcess)checkMonitor).checkProcess());
        }
        if (mode.equalsIgnoreCase("resource") || mode.equalsIgnoreCase("all")) {
            checkMonitor = new CheckMonitorPerformance();
            arrayList.add(((CheckMonitorPerformance)checkMonitor).checkPerformance());
        }
        if (mode.equalsIgnoreCase("syslog") || mode.equalsIgnoreCase("all")) {
            checkMonitor = new CheckMonitorSyslogng();
            arrayList.add(((CheckMonitorSyslogng)checkMonitor).checkSyslogng());
        }
        if (mode.equalsIgnoreCase("snmp") || mode.equalsIgnoreCase("all")) {
            checkMonitor = new CheckMonitorSnmp();
            arrayList.add(((CheckMonitorSnmp)checkMonitor).checkSnmp());
        }
        if (mode.equalsIgnoreCase("trap") || mode.equalsIgnoreCase("all")) {
            checkMonitor = new CheckMonitorSnmpTrap();
            arrayList.add(((CheckMonitorSnmpTrap)checkMonitor).checkSnmpTrap());
        }
        if (mode.equalsIgnoreCase("port") || mode.equalsIgnoreCase("all")) {
            checkMonitor = new CheckMonitorPort();
            arrayList.add(((CheckMonitorPort)checkMonitor).checkPort());
        }
        if (mode.equalsIgnoreCase("http") || mode.equalsIgnoreCase("all")) {
            checkMonitor = new CheckMonitorHttp();
            arrayList.add(((CheckMonitorHttp)checkMonitor).checktHttp());
        }
        if (mode.equalsIgnoreCase("sql") || mode.equalsIgnoreCase("all")) {
            checkMonitor = new CheckMonitorSql();
            arrayList.add(((CheckMonitorSql)checkMonitor).checkSql());
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (ArrayList cloneable2 : arrayList) {
            n += Integer.parseInt((String)cloneable2.get(1));
            n2 += Integer.parseInt((String)cloneable2.get(2));
            n3 += Integer.parseInt((String)cloneable2.get(3));
        }
        ArrayList arrayList2 = new ArrayList();
        arrayList2.add("Total");
        arrayList2.add(String.valueOf(n));
        arrayList2.add(String.valueOf(n2));
        arrayList2.add(String.valueOf(n3));
        Collections.sort(arrayList, new StringListComparator(0));
        arrayList.add(0, CheckMonitor.createOutputHeader());
        arrayList.add(arrayList2);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        WriteCsvFile.writeCsvFile(Config.getConfig("Export.Dir") + "/CHECK_" + simpleDateFormat.format(new Date()) + ".csv", arrayList);
        try {
            LoginManager.getContextManager().logout();
        }
        catch (NamingException namingException) {
            log.warn((Object)Messages.getMsg("DisconnectManagerFailed"), (Throwable)namingException);
        }
        log.info((Object)Messages.getMsg("CheckTool.Exit"));
        System.exit(0);
    }
}

