/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.importtool.conf.monitor;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapInfo;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapOidInfo;
import com.clustercontrol.snmptrap.bean.SnmpTrapMasterInfo;
import com.clustercontrol.snmptrap.ejb.session.MonitorSnmpTrapController;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ejb.DuplicateKeyException;
import jp.co.intellilink.hinemos.importtool.conf.monitor.ImportMonitor;
import jp.co.intellilink.hinemos.util.CheckString;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.ReadCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportMonitorSnmpTrap
extends ImportMonitor {
    private static Log log = LogFactory.getLog(ImportMonitorSnmpTrap.class);
    private ArrayList monitorList = null;
    private ArrayList<ArrayList<String>> monitorInfos = null;

    public void importSnmpTrap() {
        log.info((Object)Messages.getMsg("SnmpTrap.Start", new String[]{Messages.getMsg("ImportTool.Import")}));
        this.monitorInfos = ReadCsvFile.readCsvFile(Config.getConfig("Import.Dir") + "/TRAP.csv");
        this.monitorList = this.getMonitorList();
        for (ArrayList<String> arrayList : this.monitorInfos) {
            MonitorInfo monitorInfo = this.createMonitorInfo(arrayList);
            this.registerMonitorInfo(monitorInfo);
        }
        log.info((Object)Messages.getMsg("SnmpTrap.End", new String[]{Messages.getMsg("ImportTool.Import")}));
    }

    @Override
    protected MonitorInfo createMonitorInfo(ArrayList<String> arrayList) {
        MonitorSnmpTrapInfo monitorSnmpTrapInfo = new MonitorSnmpTrapInfo();
        this.createMonitorBase(arrayList, (MonitorInfo)monitorSnmpTrapInfo);
        monitorSnmpTrapInfo.setCalendarId(arrayList.get(3));
        this.createMonitorCheck(arrayList.subList(4, 14), (MonitorInfo)monitorSnmpTrapInfo);
        this.createMonitorNotify(arrayList.subList(14, 19), (MonitorInfo)monitorSnmpTrapInfo);
        this.createMonitorApplication(arrayList.subList(19, 20), (MonitorInfo)monitorSnmpTrapInfo);
        this.createMonitorVaild(arrayList.subList(20, 21), (MonitorInfo)monitorSnmpTrapInfo);
        return monitorSnmpTrapInfo;
    }

    @Override
    protected void createMonitorCheck(List<String> list, MonitorInfo monitorInfo) {
        Object object;
        MonitorSnmpTrapInfo monitorSnmpTrapInfo = (MonitorSnmpTrapInfo)monitorInfo;
        String string = CheckString.checkLength(list.get(0), 64);
        if (!string.equals(list.get(0))) {
            object = new String[]{com.clustercontrol.util.Messages.getString((String)"community.name"), "64"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", (Object[])object));
        }
        monitorSnmpTrapInfo.setCommunityName(string);
        if (list.get(1).equals(com.clustercontrol.util.Messages.getString((String)"OidListComposite.SpecificOid"))) {
            monitorSnmpTrapInfo.setCheckMode(0);
        } else if (list.get(1).equals(com.clustercontrol.util.Messages.getString((String)"OidListComposite.AllMaterOid"))) {
            monitorSnmpTrapInfo.setCheckMode(1);
        } else if (list.get(1).equals(com.clustercontrol.util.Messages.getString((String)"OidListComposite.NoMasterOid"))) {
            monitorSnmpTrapInfo.setCheckMode(2);
        }
        if (monitorSnmpTrapInfo.getCheckMode() == 0) {
            object = new ArrayList();
            MonitorSnmpTrapOidInfo monitorSnmpTrapOidInfo = new MonitorSnmpTrapOidInfo();
            monitorSnmpTrapOidInfo.setMonitorId(monitorSnmpTrapInfo.getMonitorId());
            monitorSnmpTrapOidInfo.setTrapName(list.get(2));
            monitorSnmpTrapOidInfo.setTrapOid(list.get(3));
            monitorSnmpTrapOidInfo.setGenericId(Integer.parseInt(list.get(4)));
            monitorSnmpTrapOidInfo.setSpecificId(Integer.parseInt(list.get(5)));
            SnmpTrapMasterInfo snmpTrapMasterInfo = EjbConnectionManager.getConnectionManager().getSnmpTrapMasterInfo(monitorSnmpTrapOidInfo.getTrapOid(), monitorSnmpTrapOidInfo.getGenericId(), monitorSnmpTrapOidInfo.getSpecificId());
            monitorSnmpTrapOidInfo.setMib(snmpTrapMasterInfo.getMib());
            monitorSnmpTrapOidInfo.setValidFlg(ValidConstant.stringToType((String)list.get(6)));
            monitorSnmpTrapOidInfo.setPriority(PriorityConstant.stringToType((String)list.get(7)));
            monitorSnmpTrapOidInfo.setLogmsg(list.get(8));
            monitorSnmpTrapOidInfo.setDescr(list.get(9));
            ((ArrayList)object).add(monitorSnmpTrapOidInfo);
            monitorSnmpTrapInfo.setOidInfos((ArrayList)object);
        }
        super.createMonitorCheck(list, monitorInfo);
    }

    protected void registerMonitorInfo(MonitorInfo monitorInfo) {
        MonitorSnmpTrapController monitorSnmpTrapController = EjbConnectionManager.getConnectionManager().getMonitorSnmpTrapController();
        try {
            ArrayList arrayList = this.checkMonitorList(monitorInfo.getMonitorId(), this.monitorList);
            if (arrayList instanceof ArrayList) {
                Date date = (Date)arrayList.get(8);
                String string = (String)arrayList.get(7);
                monitorInfo.setRegDate(new Timestamp(date.getTime()));
                monitorInfo.setRegUser(string);
                Object[] objectArray = new Object[]{monitorInfo.getMonitorId()};
                log.info((Object)(Messages.getMsg("MonitorID", objectArray) + " (" + Messages.getMsg("modify") + ")"));
                monitorSnmpTrapController.modifyMonitor((MonitorSnmpTrapInfo)monitorInfo);
            } else {
                Object[] objectArray = new Object[]{monitorInfo.getMonitorId()};
                log.info((Object)(Messages.getMsg("MonitorID", objectArray) + " (" + Messages.getMsg("add") + ")"));
                monitorSnmpTrapController.addMonitor((MonitorSnmpTrapInfo)monitorInfo);
            }
        }
        catch (DuplicateKeyException duplicateKeyException) {
            Object[] objectArray = new String[]{monitorInfo.getMonitorId()};
            log.error((Object)Messages.getMsg("ImportTool.Common.1", objectArray));
            System.exit(20);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
    }

    protected ArrayList getMonitorList() {
        MonitorSnmpTrapController monitorSnmpTrapController = EjbConnectionManager.getConnectionManager().getMonitorSnmpTrapController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorSnmpTrapController.getMonitorList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

