/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.browser;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.percederberg.mibble.browser.BrowserFrame;
import net.percederberg.mibble.browser.MibNode;
import net.percederberg.mibble.browser.SnmpAuthentication;
import net.percederberg.mibble.browser.SnmpException;
import net.percederberg.mibble.browser.SnmpManager;
import net.percederberg.mibble.browser.SnmpPrivacy;
import net.percederberg.mibble.browser.SnmpRequest;
import net.percederberg.mibble.browser.SnmpResponse;
import net.percederberg.mibble.snmp.SnmpObjectType;

public class SnmpPanel
extends JPanel {
    private static final Insets DEFAULT_INSETS = new Insets(2, 5, 2, 5);
    private BrowserFrame frame;
    private int version = 1;
    private boolean feedback = true;
    private boolean blocked = false;
    private Operation operation = null;
    private JPanel fieldPanel = new JPanel();
    private JLabel hostLabel = new JLabel("Host IP Address;");
    private JTextField hostField = new JTextField("127.0.0.1");
    private JLabel portLabel = new JLabel("Port Number:");
    private JTextField portField = new JTextField();
    private JLabel readCommunityLabel = new JLabel("Read Community:");
    private JPasswordField readCommunityField = new JPasswordField("public");
    private JLabel writeCommunityLabel = new JLabel("Write Community:");
    private JPasswordField writeCommunityField = new JPasswordField("public");
    private JLabel contextNameLabel = new JLabel("Context Name:");
    private JTextField contextNameField = new JTextField("");
    private JLabel contextEngineLabel = new JLabel("Context Engine:");
    private JTextField contextEngineField = new JTextField("");
    private JLabel userNameLabel = new JLabel("User Name:");
    private JTextField userNameField = new JTextField("initial");
    private JLabel authTypeLabel = new JLabel("Authentication:");
    private JComboBox authTypeCombo = new JComboBox();
    private JLabel authPasswordLabel = new JLabel("Auth. Password:");
    private JPasswordField authPasswordField = new JPasswordField("public");
    private JLabel privacyTypeLabel = new JLabel("Privacy:");
    private JComboBox privacyTypeCombo = new JComboBox();
    private JLabel privacyPasswordLabel = new JLabel("Privacy Password:");
    private JPasswordField privacyPasswordField = new JPasswordField("public");
    private JLabel oidLabel = new JLabel("OID:");
    private JTextField oidField = new JTextField();
    private JLabel valueLabel = new JLabel("Value:");
    private JTextField valueField = new JTextField();
    private JTextArea resultsArea = new JTextArea();
    private JButton getButton = new JButton("Get");
    private JButton getNextButton = new JButton("Get Next");
    private JButton getAllButton = new JButton("Get All");
    private JButton setButton = new JButton("Set");
    private JButton stopButton = new JButton("Stop");
    private JButton clearButton = new JButton("Clear");

    public SnmpPanel(BrowserFrame frame) {
        this.frame = frame;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        this.fieldPanel.setLayout(new GridBagLayout());
        this.portField.setText(String.valueOf(161));
        this.authTypeCombo.addItem("None");
        this.authTypeCombo.addItem("MD5");
        this.authTypeCombo.addItem("SHA-1");
        this.privacyTypeCombo.addItem("None");
        this.privacyTypeCombo.addItem("CBC-DES");
        this.hostLabel.setLabelFor(this.hostField);
        this.portLabel.setLabelFor(this.portField);
        this.readCommunityLabel.setLabelFor(this.readCommunityField);
        this.writeCommunityLabel.setLabelFor(this.writeCommunityField);
        this.contextNameLabel.setLabelFor(this.contextNameField);
        this.contextEngineLabel.setLabelFor(this.contextEngineField);
        this.userNameLabel.setLabelFor(this.userNameField);
        this.authTypeLabel.setLabelFor(this.authTypeCombo);
        this.authPasswordLabel.setLabelFor(this.authPasswordField);
        this.privacyTypeLabel.setLabelFor(this.privacyTypeCombo);
        this.privacyPasswordLabel.setLabelFor(this.privacyPasswordField);
        this.oidLabel.setLabelFor(this.oidField);
        this.valueLabel.setLabelFor(this.valueField);
        this.initializeSnmpV1FieldPanel();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        this.add((Component)this.fieldPanel, c);
        c = new GridBagConstraints();
        c.gridy = 1;
        c.anchor = 17;
        c.fill = 0;
        this.add((Component)this.initializeButtons(), c);
        this.resultsArea.setEditable(false);
        c = new GridBagConstraints();
        c.gridy = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.add((Component)new JScrollPane(this.resultsArea), c);
        this.authTypeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SnmpPanel.this.updateAuthentication();
            }
        });
        this.privacyTypeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SnmpPanel.this.updatePrivacy();
            }
        });
        this.updateAuthentication();
        DocumentListener l = new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                SnmpPanel.this.updateStatus();
            }

            public void insertUpdate(DocumentEvent e) {
                SnmpPanel.this.updateStatus();
            }

            public void removeUpdate(DocumentEvent e) {
                SnmpPanel.this.updateStatus();
            }
        };
        this.hostField.getDocument().addDocumentListener(l);
        this.portField.getDocument().addDocumentListener(l);
        this.oidField.getDocument().addDocumentListener(l);
    }

    private void initializeSnmpV1FieldPanel() {
        this.fieldPanel.removeAll();
        this.fieldPanel.invalidate();
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 1;
        c.fill = 1;
        c.insets = DEFAULT_INSETS;
        this.fieldPanel.add((Component)this.hostLabel, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 0.1;
        c.fill = 2;
        c.insets = DEFAULT_INSETS;
        this.fieldPanel.add((Component)this.hostField, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 1;
        c.fill = 1;
        c.insets = DEFAULT_INSETS;
        this.fieldPanel.add((Component)this.readCommunityLabel, c);
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = 1;
        c.weightx = 0.1;
        c.fill = 2;
        c.insets = DEFAULT_INSETS;
        this.fieldPanel.add((Component)this.readCommunityField, c);
        c = new GridBagConstraints();
        c.gridy = 2;
        c.fill = 1;
        c.insets = DEFAULT_INSETS;
        this.fieldPanel.add((Component)this.portLabel, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.weightx = 0.1;
        c.fill = 2;
        c.insets = DEFAULT_INSETS;
        this.fieldPanel.add((Component)this.portField, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 2;
        c.fill = 1;
        c.insets = DEFAULT_INSETS;
        this.fieldPanel.add((Component)this.writeCommunityLabel, c);
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = 2;
        c.weightx = 0.1;
        c.fill = 2;
        c.insets = DEFAULT_INSETS;
        this.fieldPanel.add((Component)this.writeCommunityField, c);
        c = new GridBagConstraints();
        c.gridy = 3;
        c.gridwidth = 4;
        c.weightx = 0.1;
        c.fill = 2;
        c.insets = DEFAULT_INSETS;
        this.fieldPanel.add((Component)new JSeparator(), c);
        c = new GridBagConstraints();
        c.gridy = 4;
        c.fill = 1;
        c.insets = DEFAULT_INSETS;
        this.fieldPanel.add((Component)this.oidLabel, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 4;
        c.gridwidth = 3;
        c.weightx = 0.1;
        c.fill = 2;
        c.insets = DEFAULT_INSETS;
        this.fieldPanel.add((Component)this.oidField, c);
        c = new GridBagConstraints();
        c.gridy = 5;
        c.fill = 1;
        c.insets = DEFAULT_INSETS;
        this.fieldPanel.add((Component)this.valueLabel, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 5;
        c.gridwidth = 3;
        c.weightx = 0.1;
        c.fill = 2;
        c.insets = DEFAULT_INSETS;
        this.fieldPanel.add((Component)this.valueField, c);
    }

    private void initializeSnmpV3FieldPanel() {
        this.fieldPanel.removeAll();
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 1;
        c.fill = 1;
        c.insets = DEFAULT_INSETS;
        this.fieldPanel.add((Component)this.hostLabel, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 0.1;
        c.fill = 2;
        c.insets = DEFAULT_INSETS;
        this.fieldPanel.add((Component)this.hostField, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 1;
        c.fill = 1;
        c.insets = DEFAULT_INSETS;
        this.fieldPanel.add((Component)this.contextNameLabel, c);
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = 1;
        c.weightx = 0.2;
        c.fill = 2;
        c.insets = DEFAULT_INSETS;
        this.fieldPanel.add((Component)this.contextNameField, c);
        c = new GridBagConstraints();
        c.gridy = 2;
        c.fill = 1;
        c.insets = DEFAULT_INSETS;
        this.fieldPanel.add((Component)this.portLabel, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.weightx = 0.1;
        c.fill = 2;
        c.insets = DEFAULT_INSETS;
        this.fieldPanel.add((Component)this.portField, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 2;
        c.fill = 1;
        c.insets = DEFAULT_INSETS;
        this.fieldPanel.add((Component)this.contextEngineLabel, c);
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = 2;
        c.weightx = 0.2;
        c.fill = 2;
        c.insets = DEFAULT_INSETS;
        this.fieldPanel.add((Component)this.contextEngineField, c);
        c = new GridBagConstraints();
        c.gridy = 3;
        c.fill = 1;
        c.insets = DEFAULT_INSETS;
        this.fieldPanel.add((Component)this.userNameLabel, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 3;
        c.weightx = 0.1;
        c.fill = 2;
        c.insets = DEFAULT_INSETS;
        this.fieldPanel.add((Component)this.userNameField, c);
        c = new GridBagConstraints();
        c.gridy = 4;
        c.fill = 1;
        c.insets = DEFAULT_INSETS;
        this.fieldPanel.add((Component)this.authTypeLabel, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 4;
        c.weightx = 0.1;
        c.fill = 2;
        c.insets = DEFAULT_INSETS;
        this.fieldPanel.add((Component)this.authTypeCombo, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 4;
        c.fill = 1;
        c.insets = DEFAULT_INSETS;
        this.fieldPanel.add((Component)this.authPasswordLabel, c);
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = 4;
        c.weightx = 0.1;
        c.fill = 2;
        c.insets = DEFAULT_INSETS;
        this.fieldPanel.add((Component)this.authPasswordField, c);
        c = new GridBagConstraints();
        c.gridy = 5;
        c.fill = 1;
        c.insets = DEFAULT_INSETS;
        this.fieldPanel.add((Component)this.privacyTypeLabel, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 5;
        c.weightx = 0.1;
        c.fill = 2;
        c.insets = DEFAULT_INSETS;
        this.fieldPanel.add((Component)this.privacyTypeCombo, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 5;
        c.fill = 1;
        c.insets = DEFAULT_INSETS;
        this.fieldPanel.add((Component)this.privacyPasswordLabel, c);
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = 5;
        c.weightx = 0.1;
        c.fill = 2;
        c.insets = DEFAULT_INSETS;
        this.fieldPanel.add((Component)this.privacyPasswordField, c);
        c = new GridBagConstraints();
        c.gridy = 6;
        c.gridwidth = 4;
        c.weightx = 0.1;
        c.fill = 2;
        c.insets = DEFAULT_INSETS;
        this.fieldPanel.add((Component)new JSeparator(), c);
        c = new GridBagConstraints();
        c.gridy = 7;
        c.fill = 1;
        c.insets = DEFAULT_INSETS;
        this.fieldPanel.add((Component)this.oidLabel, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 7;
        c.gridwidth = 3;
        c.weightx = 0.1;
        c.fill = 2;
        c.insets = DEFAULT_INSETS;
        this.fieldPanel.add((Component)this.oidField, c);
        c = new GridBagConstraints();
        c.gridy = 8;
        c.fill = 1;
        c.insets = DEFAULT_INSETS;
        this.fieldPanel.add((Component)this.valueLabel, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 8;
        c.gridwidth = 3;
        c.weightx = 0.1;
        c.fill = 2;
        c.insets = DEFAULT_INSETS;
        this.fieldPanel.add((Component)this.valueField, c);
    }

    private JPanel initializeButtons() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        this.getButton.setToolTipText("Perform SNMP get operation");
        this.getButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SnmpPanel.this.performGet();
            }
        });
        panel.add(this.getButton);
        this.getNextButton.setToolTipText("Perform SNMP get next operation");
        this.getNextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SnmpPanel.this.performGetNext();
            }
        });
        panel.add(this.getNextButton);
        this.getAllButton.setToolTipText("Walk an OID branch and retrieve all values");
        this.getAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SnmpPanel.this.performGetAll();
            }
        });
        panel.add(this.getAllButton);
        this.setButton.setToolTipText("Perform SNMP set operation");
        this.setButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SnmpPanel.this.performSet();
            }
        });
        panel.add(this.setButton);
        this.stopButton.setToolTipText("Stops the SNMP operation");
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SnmpPanel.this.performStop();
            }
        });
        panel.add(this.stopButton);
        this.clearButton.setToolTipText("Clear SNMP result area");
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SnmpPanel.this.clearResults();
            }
        });
        panel.add(this.clearButton);
        this.updateStatus();
        return panel;
    }

    public void setVersion(int version) {
        this.version = version;
        if (version == 1 || version == 2) {
            this.initializeSnmpV1FieldPanel();
        } else if (version == 3) {
            this.initializeSnmpV3FieldPanel();
        }
        this.validate();
    }

    public void setFeedback(boolean feedback) {
        this.feedback = feedback;
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
        this.updateStatus();
    }

    public void updateOid() {
        MibNode node = this.frame.getSelectedNode();
        if (node == null) {
            this.oidField.setText("");
        } else if (node.getSymbol() != null && node.getSymbol().isScalar()) {
            this.oidField.setText(node.getOid() + ".0");
        } else {
            this.oidField.setText(node.getOid());
        }
    }

    public void updateOid(String text) {
        this.frame.setSelectedNode(text);
        this.oidField.setText(text);
    }

    public void updateValue(String value) {
        this.valueField.setText(value);
    }

    public void updateStatus() {
        MibNode node = this.frame.getSelectedNode();
        SnmpObjectType type = null;
        if (node != null) {
            type = node.getSnmpObjectType();
        }
        boolean allowOperation = !this.blocked && this.hostField.getText().length() > 0 && this.portField.getText().length() > 0;
        boolean allowGet = allowOperation && this.oidField.getText().length() > 0;
        boolean allowSet = allowOperation && type != null && type.getAccess().canWrite();
        this.oidLabel.setEnabled(allowOperation);
        this.oidField.setEnabled(allowOperation);
        this.valueLabel.setEnabled(allowSet);
        this.valueField.setEnabled(allowSet);
        this.getButton.setEnabled(allowGet);
        this.getNextButton.setEnabled(allowGet);
        this.getAllButton.setEnabled(allowGet);
        this.setButton.setEnabled(allowSet);
        this.stopButton.setEnabled(this.operation != null);
    }

    protected void updateAuthentication() {
        boolean useAuth = this.authTypeCombo.getSelectedIndex() != 0;
        this.authPasswordLabel.setEnabled(useAuth);
        this.authPasswordField.setEnabled(useAuth);
        this.privacyTypeLabel.setEnabled(useAuth);
        this.privacyTypeCombo.setEnabled(useAuth);
        if (!useAuth) {
            this.privacyTypeCombo.setSelectedIndex(0);
        }
    }

    protected void updatePrivacy() {
        boolean usePrivacy = this.privacyTypeCombo.getSelectedIndex() != 0;
        this.privacyPasswordLabel.setEnabled(usePrivacy);
        this.privacyPasswordField.setEnabled(usePrivacy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setOperationStatus(String text) {
        SnmpPanel snmpPanel = this;
        synchronized (snmpPanel) {
            if (text == null) {
                this.operation = null;
            }
        }
        this.frame.setBlocked(text != null);
        this.frame.setStatus(text);
    }

    protected void performGet() {
        Operation operation = this.createOperation(true);
        if (operation != null) {
            operation.startGet();
        }
    }

    protected void performGetNext() {
        Operation operation = this.createOperation(true);
        if (operation != null) {
            operation.startGetNext();
        }
    }

    protected void performGetAll() {
        this.operation = this.createOperation(true);
        if (this.operation != null) {
            this.operation.startGetAll();
        }
    }

    protected void performSet() {
        Operation operation = this.createOperation(false);
        if (operation != null) {
            operation.startSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performStop() {
        SnmpPanel snmpPanel = this;
        synchronized (snmpPanel) {
            if (this.operation != null) {
                this.operation.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearResults() {
        SnmpPanel snmpPanel = this;
        synchronized (snmpPanel) {
            this.resultsArea.setText("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void appendResults(String text) {
        SnmpPanel snmpPanel = this;
        synchronized (snmpPanel) {
            this.resultsArea.append(text);
            this.resultsArea.setCaretPosition(this.resultsArea.getText().length());
        }
    }

    private Operation createOperation(boolean read) {
        SnmpRequest request;
        SnmpManager manager;
        int port;
        String host = this.hostField.getText();
        String community = null;
        String contextName = null;
        String contextEngine = null;
        String userName = null;
        SnmpAuthentication auth = null;
        SnmpPrivacy privacy = null;
        String oid = this.oidField.getText();
        try {
            port = Integer.parseInt(this.portField.getText());
        }
        catch (NumberFormatException ignore) {
            port = 0;
        }
        if (port <= 0 || port >= 65536) {
            this.portField.requestFocus();
            String message = "Provide valid (numeric) port number in the range [1..65535].";
            JOptionPane.showMessageDialog(this.frame, message, "Port Number Error", 0);
            return null;
        }
        if (this.version < 3) {
            community = read ? new String(this.readCommunityField.getPassword()) : new String(this.writeCommunityField.getPassword());
        } else {
            String password;
            String type;
            contextName = this.contextNameField.getText();
            contextEngine = this.contextEngineField.getText();
            userName = this.userNameField.getText();
            if (this.authTypeCombo.getSelectedIndex() > 0) {
                type = this.authTypeCombo.getSelectedItem().toString();
                password = new String(this.authPasswordField.getPassword());
                auth = new SnmpAuthentication(type, password);
            }
            if (this.privacyTypeCombo.getSelectedIndex() > 0) {
                type = this.privacyTypeCombo.getSelectedItem().toString();
                password = new String(this.privacyPasswordField.getPassword());
                privacy = new SnmpPrivacy(type, password);
            }
        }
        try {
            manager = this.version == 1 ? SnmpManager.createSNMPv1(host, port, community) : (this.version == 2 ? SnmpManager.createSNMPv2c(host, port, community) : SnmpManager.createSNMPv3(host, port, contextName, contextEngine, userName, auth, privacy));
        }
        catch (SnmpException e) {
            JOptionPane.showMessageDialog(this.frame, e.getMessage(), "SNMP Error", 0);
            return null;
        }
        if (read) {
            request = new SnmpRequest(oid);
        } else {
            SnmpObjectType objectType = this.frame.getSelectedNode().getSnmpObjectType();
            String value = this.valueField.getText();
            request = new SnmpRequest(oid, objectType.getSyntax(), value);
        }
        return new Operation(manager, request, this.feedback);
    }

    private class Operation
    implements Runnable {
        private SnmpManager manager;
        private SnmpRequest request;
        private String operation;
        private boolean feedback;
        private boolean stopped = false;

        public Operation(SnmpManager manager, SnmpRequest request, boolean feedback) {
            this.manager = manager;
            this.request = request;
            this.feedback = feedback;
        }

        public void startGet() {
            this.operation = "GET";
            this.start();
        }

        public void startGetNext() {
            this.operation = "GET NEXT";
            this.start();
        }

        public void startGetAll() {
            this.operation = "GET ALL";
            this.start();
        }

        public void startSet() {
            this.operation = "SET";
            this.start();
        }

        private void start() {
            Thread thread = new Thread(this);
            thread.start();
        }

        public void stop() {
            this.stopped = true;
        }

        public void run() {
            SnmpResponse response = null;
            String message = "Performing " + this.operation + " on " + this.request.getOid() + "...";
            SnmpPanel.this.setOperationStatus(message);
            try {
                if (this.operation.equals("GET ALL")) {
                    this.runGetAll();
                } else {
                    SnmpPanel.this.appendResults(this.operation + ": ");
                    if (this.operation.equals("GET")) {
                        response = this.manager.get(this.request.getOid());
                    } else if (this.operation.equals("GET NEXT")) {
                        response = this.manager.getNext(this.request.getOid());
                    } else if (this.operation.equals("SET")) {
                        response = this.manager.set(this.request);
                    } else {
                        throw new SnmpException("Unknown operation: " + this.operation);
                    }
                    SnmpPanel.this.appendResults(response.getOidsAndValues());
                    if (this.feedback) {
                        SnmpPanel.this.updateOid(response.getOid(0));
                        SnmpPanel.this.updateValue(response.getValue(0));
                    }
                }
            }
            catch (SnmpException e) {
                SnmpPanel.this.appendResults("Error: ");
                SnmpPanel.this.appendResults(e.getMessage());
                SnmpPanel.this.appendResults("\n");
            }
            this.manager.destroy();
            SnmpPanel.this.setOperationStatus(null);
        }

        private void runGetAll() throws SnmpException {
            SnmpResponse response = null;
            String oid = this.request.getOid();
            do {
                if ((oid = (response = this.manager.getNext(oid)).getOid(0)).startsWith(this.request.getOid())) {
                    SnmpPanel.this.appendResults("GET NEXT: ");
                    SnmpPanel.this.appendResults(response.getOidsAndValues());
                    if (!this.feedback) continue;
                    SnmpPanel.this.updateOid(response.getOid(0));
                    SnmpPanel.this.updateValue(response.getValue(0));
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                SnmpPanel.this.appendResults("DONE: no more values for " + this.request.getOid() + "\n");
                this.stopped = true;
            } while (!this.stopped);
        }
    }
}

