<?php
require_once "../himmel/Himmel_Himmel.php";

class Xnm_XmlNoteManager {
    private $timezoneOffset = 540;

    public function excute() {
        $queryString = $_SERVER["PATH_INFO"];
        if (preg_match('!^(?:/(\d{4})(?:/(0[1-9]|1[0-2])(?:/(0[1-9]|[12][0-9]|3[01])(?:/([01][0-9]|2[0-3])([0-5][0-9])([0-5][0-9]))?)?)?)?$!', $queryString, $queryFragments)) {
            // The data type of the empty variables in $querryFragments are NULL (not FALSE, 0 or empty string).
            array_shift($queryFragments);
            list($qYear, $qMonth, $qDay, $qHour, $qMinute, $qSecond) = $queryFragments;

            $dm = Xnm_DataManager::getInstance();
            $indexDom = $dm->getIndex();

            $domXsl = new DomDocument();
            if ($qSecond !== NULL) {
                $domXsl->load("IndexToSdfIndividual.xsl");
            } elseif ($qDay !== NULL) {
                $domXsl->load("IndexToSdfDaily.xsl");
            } elseif ($qMonth !== NULL) {
                $domXsl->load("IndexToSdfMonthly.xsl");
            } elseif ($qYear !== NULL) {
                $domXsl->load("IndexToSdfYearly.xsl");
            } else {
                $domXsl->load("IndexToSdfHome.xsl");
            }
            $xsltp = new XsltProcessor();
            $xsltp->registerPhpFunctions();
            $xsltp->setParameter(Hml_Util::getNsUri("idx"), "year", $qYear);
            $xsltp->setParameter(Hml_Util::getNsUri("idx"), "month", $qMonth);
            $xsltp->setParameter(Hml_Util::getNsUri("idx"), "day", $qDay);
            $xsltp->setParameter(Hml_Util::getNsUri("idx"), "hour", $qHour);
            $xsltp->setParameter(Hml_Util::getNsUri("idx"), "minute", $qMinute);
            $xsltp->setParameter(Hml_Util::getNsUri("idx"), "second", $qSecond);
            $xsltp->importStyleSheet($domXsl);
            $sdfDom = $xsltp->transformToDoc($indexDom);
//            header("Content-Type: text/plain");
//            print "<pre>";
//            print $sdfDom->saveXml();

            $hml = new Himmel_Himmel("XmlNoteManager");
            $dc = $hml->getDataContainer();
            $dc->setData($sdfDom);
            $hml->excute($dc);
        } elseif ($queryString == '/latest') {
            $dm = Xnm_DataManager::getInstance();
            $indexDom = $dm->getIndex();

            $domXsl = new DomDocument();
            $domXsl->load("IndexToSdfLatest.xsl");
            $xsltp = new XsltProcessor();
            $xsltp->registerPhpFunctions();
            $xsltp->importStyleSheet($domXsl);
            $sdfDom = $xsltp->transformToDoc($indexDom);

            $hml = new Himmel_Himmel("XmlNoteManager");
            $dc = $hml->getDataContainer();
            $dc->setData($sdfDom);
            $hml->excute($dc);
        } else {
            print "error";
            // error
        }
    }
}

/*
** URI Format
(?:
    /
    [0-9a-zA-Z_-]+#category
)?
(?:
    /
    [0-9a-zA-Z_-]+#writer
)?
(?:
    /
    (\d{4})#year
    (?:
        /
        (0[1-9]|1[0-2])#month
        (?:
            /
            (0[1-9]|[12][0-9]|3[01])#day
            (?:
                /
                ([01][0-9]|2[0-3])#hour
                ([0-5][0-9])#minute
                ([0-5][0-9])#second
            )?
        )?
    )?
)?
**/
?>