<?php
class Xnm_DataControllerFileSystem extends Xnm_DataController {
    protected $dataDirectory = "./Data";
    protected $fileList = NULL;

    protected function getItratorToBuildIndex() {
        return new Xnm_ItratorToBuildIndexFileSystem($this->getFileList()); 
    }

    protected function ifDataChanged($number, $latestTimestamp) {
        $fileList = $this->getFileList();
        if (count($fileList) != $number) {
            return TRUE;
        } else {
            $tList = array();
            clearstatcache();
            foreach ($fileList as $filePath) {
                $tList[] = filemtime($filePath);
            }
            if ($latestTimestamp != max($tList)) {
                return TRUE;
            } else {
                return FALSE;
            }
        }
    }

    public function loadData($internalId) {
        $targetDom = new DomDocument();
        $targetDom->load($internalId);
        return $targetDom;
    }

    protected function getFileList() {
        if ($this->fileList === NULL) {
            $this->fileList = $this->makeFileList($this->dataDirectory);
            return $this->fileList;
        } else {
            return $this->fileList;
        }
    
    }

    protected function makeFileList($targetDir) {
        $fileList = array();
        if ($dir = opendir($targetDir)) {
            while (FALSE !== ($currentTgt = readdir($dir))) {
                if ($currentTgt != "." && $currentTgt != "..") {
                    if (is_dir($targetDir . "/" . $currentTgt)) {
                        $fileList = array_merge($fileList, $this->makeFileList($targetDir . "/" . $currentTgt));
                    } elseif (preg_match('/\.xnm(?:\.xml)?/', $currentTgt)) {
                        $filePath = realpath(dirname(__FILE__) . "/" . $targetDir . "/" . $currentTgt);
                        $fileList[] = $filePath;
                    }
                }
            }
            closedir($dir);
        } else {
            throw new Exception("Directory open Error: " . $targetDir);
        }
        return $fileList;
    }
}

class Xnm_ItratorToBuildIndexFileSystem {
    private $fileList = array();
    private $pointer = 0;

    public function __construct($newFileList) {
        $this->fileList = $newFileList;
    }

    public function next() {
        $internalId = $this->fileList[$this->pointer];
        $internalTimestamp = filemtime($internalId);
        $dom = new DomDocument();
        $dom->load($internalId);
        $this->pointer++;
        $result = array(
            "internalId" => $internalId,
            "internalTimestamp" => $internalTimestamp,
            "dom" => $dom
        );
        return $result;
    }

    public function hasNext() {
        if ($this->pointer < count($this->fileList)) {
            return TRUE;
        } else {
            return FALSE;
        }
    }


}
?>