<?php
function __autoload($className) {
    $incPath = array("/OutputDefinitions");
    foreach ($incPath as $anIncPath) ini_set("include_path", ini_get("include_path") . ";" . dirname(__FILE__) . $anIncPath);
    require_once $className . ".php";
}
/**
 * Main class of HIMMEL
 * 
 * @author Arielworks
 * @access public
 * @version 0.8.1
 * @license Public Domain
 */
class Himmel_Himmel {
    /**
     * @access private
     */
    private $outputManager = NULL;

    private $backEndName = NULL;

    /**
     * Constractor
     * 
     * @return void
     * @access public
     */
    public function __construct($newBackEndName) {
        $this->outputManager = new Himmel_OutputManager();
        $this->backEndName = $newBackEndName;
    }

    /**
     * @return DataContainer
     * @access public
     */
    public function getDataContainer() {
        return new Himmel_DataContainer();
    }

    /**
     * @return void
     * @param DataContainer $dataContainer DataContainer to excute
     * @param int $statusCode default code is 200
     * @access public
     */
    public function excute($dataContainer, $statusCode = NULL) {
        $dataContainer->setBackEndName($this->backEndName);
        $this->outputManager->output($dataContainer);
    }
}
?>