<?php
// +----------------------------------------------------------------------+
// | MakeMap 0.5                                            For PHP 5.0.0 |
// +----------------------------------------------------------------------+
// | Distributed at http://www.arielworks.net/works/codeyard/sdf/s3     |
// +----------------------------------------------------------------------+

/* Settings ============================================================ */
define("DIR_ROOT", $_SERVER['DOCUMENT_ROOT']);
define("TARGET_NAME", "index.xml");
/* ===================================================================== */


require_once(DIR_ROOT . "/himmel/lemmih.inc");

main();

function main()
{
    /* Make the directory tree */
    $tree = make_dirtree(DIR_ROOT, 2);

    /* Translate into XML SiteMap */
    $dd_sitemap = makeSiteMap($tree);
    $dd_sitemap->formatOutput = TRUE;
    $dd_sitemap->encoding = "UTF-8";
    $data_sitemap = $dd_sitemap->saveXML();

    /* Save if changed */
    compSave($data_sitemap, "sitemap.xml");

    print "Complete";
}

function makeSiteMap($tree)
{

    $ns_sitemap = "http://www.arielworks.net/works/codeyard/sitemap";
    $ns_sdf     = "http://www.arielworks.net/works/codeyard/sdf";
    $ns_xh      = "http://www.w3.org/1999/xhtml";

    /* DomDocument for current branch */
    $dd_current = new DomDocument;
    $nd_page = $dd_current->createElementNS($ns_sitemap, "sm:page");
    $dd_current->appendChild($nd_page);

    foreach ($tree as $item) {
        if ($item["name"] == TARGET_NAME) {
            $dd_tgt = new DomDocument;
            $dd_tgt->preserveWhiteSpace = FALSE;
            $dd_tgt->load($item["path"]);

            $xph_tgt = new DOMXPath($dd_tgt);
            $xph_tgt->registerNamespace("sdf", $ns_sdf);
            $xph_tgt->registerNamespace("xh", $ns_xh);

            /* Set page ID */
            $nd_id = $nd_page->appendChild($dd_current->createElementNS($ns_sitemap, "sm:id"));
            if (substr($item["dir"], strlen($_SERVER["DOCUMENT_ROOT"])) == "") {
                $id = "/";
            } else {
                $id = substr($item["dir"], strlen($_SERVER["DOCUMENT_ROOT"]));
            }
            $nd_id->appendChild($dd_current->createTextNode($id));

            /* Copy meta data */
            $nl_meta_contents = $xph_tgt->query("/sdf:document/sdf:meta/node()");
            foreach ($nl_meta_contents as $nd_meta_contents_item) {
                $nd_meta_contents_item_imported = $dd_current->importNode($nd_meta_contents_item, TRUE);
                $nd_page->appendChild($nd_meta_contents_item_imported);
            }

            /* Copy description (first p element) */
            $nd_description = $dd_current->createElementNS($ns_sitemap, "sm:description");
            $nd_page->appendChild($nd_description);
            $nl_description_contents = $xph_tgt->query("/sdf:document/sdf:body/descendant::xh:p[text()][1]/node()");
            foreach ($nl_description_contents as $nd_description_contents_item) {
                $nd_description_contents_item_imported = $dd_current->importNode($nd_description_contents_item, TRUE);
                $nd_description->appendChild($nd_description_contents_item_imported);
            }
        } elseif ($item["type"] == "dir") {
            $dd_sub = makeSiteMap($item["sub"]);
            $xph_sub = new DOMXpath($dd_sub);
            $nl_sub_root = $xph_sub->query("/*");
            if ($nl_sub_root->item(0)->hasChildNodes()) {
                $nd_sub_root_imported = $dd_current->importNode($nl_sub_root->item(0), TRUE); 
                $nd_page->appendChild($nd_sub_root_imported);
            }
        }
    }

    /* Rename root element */
    if ($id == "/") {
        $nd_sitemap = $dd_current->createElementNS($ns_sitemap,"sm:sitemap");
        foreach ($nd_page->childNodes as $nd_page_child_item) {
            $nd_sitemap->appendChild($nd_page_child_item->cloneNode(TRUE));
        }
        $dd_current->removeChild($nd_page);
        $dd_current->appendChild($nd_sitemap);
    }
    return $dd_current;
}

function compSave($data, $path)
{
    $now = @file_get_contents($path);
    if ($data != $now) {
        if ($handle = fopen($path, "w")) {
            flock($handle, LOCK_EX);
            fwrite($handle, $data);
            flock($handle, LOCK_UN);
            fclose($handle);
        }
    }
}

?>