/*
 * $Id: hfstick.h,v 1.4 2006/08/19 02:44:59 afujita Exp $
 *
 *  Copyright (c) 2006 Ariya Fujita <afujita@sourceforge.jp>
 *
 */

/*
 *  HORI USB Flightsticks.
 *  -- a header file
 */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef _FLIGHTSTICK_H_
#define _FLIGHTSTICK_H_
#include <linux/version.h>

#ifndef UCHAR
#define UCHAR unsigned char
#endif


/*
 *
 * derived from hfsd -- HORI Flight Stick driver for MS Windows
 * <http://www.tamanegi.org/prog/hfsd/>
 *
 */

/* usb vendor request */
#ifdef VR00_REQUEST
#  error Why is VR00_REQUEST already defined?
#endif
#define VR00_REQUEST 0x0
#define VR00_REQTYPE 0xa0
#define VR00_VALUE 0x0
#define VR00_INDEX 0x1

#define VR01_REQUEST 0x1
#define VR01_REQTYPE 0xa0
#define VR01_VALUE 0x0
#define VR01_INDEX 0x1

/* input: interrupt */
struct controller_raw_input_ir {
    UCHAR stick_x;              /* stick (left - right, 0x00 - 0xff) */
    UCHAR stick_y;              /* stick (top - bottom, 0x00 - 0xff)  */
    UCHAR rudder;               /* rudder (left - right, 0x00 - 0xff) */
    UCHAR throttle;             /* throttle (top - bottom, 0x00 - 0xff) */
    UCHAR hat_x;                /* hat (left - right, 0x00 - 0xff) */
    UCHAR hat_y;                /* hat (top - bottom, 0x00 - 0xff) */
    UCHAR button_a;             /* button A (press - press, 0x00 - 0xff) */
    UCHAR button_b;             /* button B (press - press, 0x00 - 0xff) */
};

/* input: vendor request 0x00 */
struct controller_raw_input_vr_00 {
    UCHAR fire_c : 1;           /* button fire-c(FS2) select(FS1) */
    UCHAR button_d : 1;         /* button D */
    UCHAR hat : 1;              /* hat press */
    UCHAR button_st : 1;        /* button ST */

    UCHAR dpad1_top : 1;        /* d-pad 1 top */
    UCHAR dpad1_right : 1;      /* d-pad 1 right */
    UCHAR dpad1_bottom : 1;     /* d-pad 1 bottom */
    UCHAR dpad1_left : 1;       /* d-pad 1 left */

    UCHAR reserved4 : 4;

    UCHAR reserved3 : 1;
    UCHAR launch : 1;           /* button lauch */
    UCHAR trigger : 1;          /* trigger */
    UCHAR reserved2 : 1;
};

/* input: vendor request 0x01 */
struct controller_raw_input_vr_01 {
    UCHAR reserved2 : 4;

    UCHAR dpad3_right : 1;      /* d-pad 3 right */
    UCHAR dpad3_middle : 1;     /* d-pad 3 middle */
    UCHAR dpad3_left : 1;       /* d-pad 3 left */
    UCHAR reserved1 : 1;

    UCHAR mode_select : 2;      /* mode select (M1 - M2 - M3, 2 - 1 - 3) */
    UCHAR reserved3 : 1;
    UCHAR button_sw1 : 1;       /* button sw-1 */

    UCHAR dpad2_top : 1;        /* d-pad 2 top */
    UCHAR dpad2_right : 1;      /* d-pad 2 right */
    UCHAR dpad2_bottom : 1;     /* d-pad 2 bottom */
    UCHAR dpad2_left : 1;       /* d-pad 2 left */
};

/* raw input */
struct controller_raw_input {
    struct controller_raw_input_ir ir;
    struct controller_raw_input_vr_00 vr_00;
    struct controller_raw_input_vr_01 vr_01;
};


/*
 *      SET_AVAL(BUTTON_A,   fix_abutton_value(raw_in->ir.button_a,
 *                                           dev_ext->conf.button_a_max));
 */

inline
static unsigned char fix_abutton_value(unsigned char val,
                                       unsigned char max)
{
    int v;

    /* clamp to [0x26 - 0xe8], then scale to [0x00 - 0xff] */
    v = (((int)0xff - val) - 0x26) * 0xff / 0xc2;

    if(max != 0) {
        /* clamp to [0x00 - max], then scale to [0x00 - 0xff] */
        v = v * 0xff / max;
    }

    if(v < 0x00) {
        v = 0;
    } else if(v > 0xff) {
        v = 0xff;
    }

    return v;
}

/* end of devied from hfsd; Thank you, the author at tamanegi.org. */

#define INFO(format, arg...) printk(KERN_INFO __FILE__ ": " format "\n" , ## arg)
#define ERR(format, arg...) printk(KERN_ERR __FILE__ ": " format "\n" , ## arg)
#define DBG(format, arg...) printk(KERN_DEBUG __FILE__ ": " format "\n" , ## arg)

#endif /* _FLIGHTSTICK_H_ */

