#ifndef _HFSTICK_COMPAT_H_
#define _HFSTICK_COMPAT_H_

struct usb_probe_status 
{
    int errnum;
    void *data;
};
    
static struct usb_probe_status fstick_usb_probe_body(struct usb_device *udev,
                                               struct usb_interface *intf,
                                               const struct usb_device_id *id);
static void fstick_usb_disconnect_body(struct usb_device *udev, struct usb_interface *intf, void *ptr);

#if LINUX_VERSION_CODE > KERNEL_VERSION(2,5,0)

/* Linux Kernel 2.6 */

/* usb functions */
# define FILL_CONTROL_URB( _urb_, _dev_, _pipe_, _setup_, _data_, _size_, _complete_, _context_) \
    usb_fill_control_urb( _urb_, _dev_, _pipe_, _setup_, _data_, _size_, _complete_, _context_)

# define FILL_INT_URB( _urb_, _dev_, _pipe_, _data_, _size_, _complete_, _context_, _interval_) \
    usb_fill_int_urb( _urb_, _dev_, _pipe_, _data_, _size_, _complete_, _context_, _interval_)

static int usb_submit_urb_with_atomic(struct urb *urb) { return usb_submit_urb(urb, GFP_ATOMIC); }
static int usb_submit_urb_with_kernel(struct urb *urb) { return usb_submit_urb(urb, GFP_KERNEL); }
static int usb_resubmit_urb(struct urb *urb) { return usb_submit_urb(urb, SLAB_ATOMIC);}

static struct urb *usb_alloc_urb_with_atomic(int iso_packets) { return usb_alloc_urb( iso_packets, GFP_ATOMIC); }
static struct urb *usb_alloc_urb_with_kernel(int iso_packets) { return usb_alloc_urb( iso_packets, GFP_KERNEL); }


#define USB_COMPLETE_FUNC_IN_URB(__func__) static void __func__(struct urb *urb, struct pt_regs *regs)  \
    { __func__##_body(urb); }

static int fstick_usb_probe(struct usb_interface *intf,const struct usb_device_id *id) {
    struct usb_device *udev = interface_to_usbdev(intf);
    struct usb_probe_status ret;
        
    ret = fstick_usb_probe_body( udev, intf, id);
    if (ret.data == NULL) return ret.errnum;
    
    usb_set_intfdata(intf, ret.data);            
    return 0;
}

static void fstick_usb_disconnect(struct usb_interface *intf) 
{
    struct usb_device *udev = interface_to_usbdev(intf);
    void *ptr = usb_get_intfdata(intf);
    
    usb_set_intfdata( intf, NULL);
    return fstick_usb_disconnect_body(udev, intf, ptr);
}

static struct usb_endpoint_descriptor* usb_get_first_ep(struct usb_device *udev, struct usb_interface *intf)     
{
    struct usb_host_interface *interface;
    struct usb_endpoint_descriptor *endpoint;
    interface = intf->cur_altsetting;
    endpoint = &interface->endpoint[0].desc;
    return endpoint;
}

/* input device */
#define INPUTDEV_NUMBER(_devname_) 99
#define INPUTDEV_IDBUSTYPE(_dev_) _dev_->id.bustype
#define INPUTDEV_IDPRODUCT(_dev_) _dev_->id.product
#define INPUTDEV_IDVENDOR(_dev_) _dev_->id.vendor

#else /* Linux Kernel 2.4 */

/* usb functions */
static int usb_submit_urb_with_atomic(struct urb *urb) { return usb_submit_urb(urb); }
static int usb_submit_urb_with_kernel(struct urb *urb) { return usb_submit_urb(urb); }

static struct urb *usb_alloc_urb_with_atomic(int iso_packets) { return usb_alloc_urb( iso_packets); }
static struct urb *usb_alloc_urb_with_kernel(int iso_packets) { return usb_alloc_urb( iso_packets); }


#define USB_COMPLETE_FUNC_IN_URB(__func__) static void __func__(struct urb *urb)\
    { __func__##_body(urb); }

static void* fstick_usb_probe(struct usb_device *udev, unsigned ifnum, const struct usb_device_id *id) {
    struct usb_interface *intf;
    struct usb_probe_status ret;
    
    intf = &udev->config[0].interface[ifnum];
    ret = fstick_usb_probe_body( udev, intf, id);
    if (ret.errnum) {
        ERR("%s - fstick_usb_probe failed with result %d", __FUNCTION__, ret.errnum);
        return NULL;
    }
    return ret.data;
}                                  

static void fstick_usb_disconnect(struct usb_device *udev, void *ptr)
{
    struct usb_interface *intf;
    intf = &udev->config[0].interface[0];
    return fstick_usb_disconnect_body(udev, intf, ptr);
}

static struct usb_endpoint_descriptor* usb_get_first_ep(struct usb_device *udev, struct usb_interface *intf) 
{
    return intf->altsetting[0].endpoint;
}

static inline int usb_resubmit_urb(struct urb *urb) { return 0; }
#define usb_kill_urb(_urb_) usb_unlink_urb(_urb_)

/* input device */
#define INPUTDEV_NUMBER(_dev_) _dev_->number
#define INPUTDEV_IDBUSTYPE(_dev_) _dev_->idbus
#define INPUTDEV_IDPRODUCT(_dev_) _dev_->idproduct
#define INPUTDEV_IDVENDOR(_dev_) _dev_->idvendor

static struct input_dev *input_allocate_device(void)
{
    return kmalloc(sizeof(struct input_dev),GFP_KERNEL);
}

static inline void input_free_device(struct input_dev *dev)
{
	kfree(dev);
}

static inline void *kzalloc( size_t size, int flags)
{
	void *mem = kmalloc( size, flags);
	if (mem)
		memset(mem, 0, size);
	return mem;
}

#endif /* Kernel 2.4/2.6 */


/* common */
static inline void fstick_usb_irq_body(struct urb *urb);
USB_COMPLETE_FUNC_IN_URB(fstick_usb_irq);

static inline void fstick_usb_ctrl_vr00_body(struct urb *urb);
USB_COMPLETE_FUNC_IN_URB(fstick_usb_ctrl_vr00);

static inline void fstick_usb_ctrl_vr01_body(struct urb *urb);
USB_COMPLETE_FUNC_IN_URB(fstick_usb_ctrl_vr01);

#endif /* _HFSTICK_COMPAT_H_ */
