/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.unitarou.lang.ArgumentChecker;

public class SnifferInputStream
extends InputStream {
    private final InputStream is_;
    private final OutputStream out_;

    public SnifferInputStream(InputStream inputStream, OutputStream outputStream) {
        ArgumentChecker.throwIfNull(inputStream, outputStream);
        this.is_ = inputStream;
        this.out_ = outputStream;
    }

    public int available() throws IOException {
        return this.is_.available();
    }

    public void close() throws IOException {
        this.is_.close();
    }

    public void mark(int n) {
        this.is_.mark(n);
    }

    public boolean markSupported() {
        return this.is_.markSupported();
    }

    public int read() throws IOException {
        int n = this.is_.read();
        this.out_.write(n);
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.is_.read(byArray, n, n2);
        if (n3 != -1) {
            this.out_.write(byArray, n, n3);
        }
        return n3;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.is_.read(byArray);
        if (n != -1) {
            this.out_.write(byArray, 0, n);
        }
        return n;
    }

    public void reset() throws IOException {
        this.is_.reset();
    }

    public long skip(long l) throws IOException {
        return this.is_.skip(l);
    }
}

