/*
 * Decompiled with CFR 0.152.
 */
package nom.rb.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Insets;
import nom.rb.common.MosaicConstraints;
import nom.rb.common.MosaicCoordStack;
import nom.rb.common.MosaicInteriorNode;
import nom.rb.common.MosaicLayout;
import nom.rb.common.MosaicNode;

final class MosaicLeafNode
extends MosaicNode {
    protected Component m_comp = null;
    protected MosaicConstraints m_constraints = null;
    protected MosaicCoordStack m_coordStack = null;
    protected int m_compOrgx = 0;
    protected int m_compOrgy = 0;
    protected int m_compWidth = 0;
    protected int m_compHeight = 0;
    protected boolean m_initialized = false;

    protected MosaicLeafNode(MosaicLayout mosaicLayout, Component component, MosaicConstraints mosaicConstraints, MosaicCoordStack mosaicCoordStack) {
        super(mosaicLayout);
        this.m_comp = component;
        this.m_constraints = mosaicConstraints;
        this.m_coordStack = mosaicCoordStack;
    }

    protected void initializeGeometry() {
        if (this.m_initialized) {
            return;
        }
        if (this.m_comp == null) {
            this.m_prefSize = this.m_minSize = new Dimension(0, 0);
        } else {
            this.m_minSize = new Dimension(this.m_comp.getMinimumSize());
            this.m_prefSize = new Dimension(this.m_comp.getPreferredSize());
        }
        this.m_weightx = this.m_constraints.m_weightx;
        this.m_weighty = this.m_constraints.m_weighty;
        if (this.m_constraints.m_insets != null) {
            int n = this.m_constraints.m_insets.left + this.m_constraints.m_insets.right;
            int n2 = this.m_constraints.m_insets.top + this.m_constraints.m_insets.bottom;
            this.m_minSize.width += n;
            this.m_minSize.height += n2;
            this.m_prefSize.width += n;
            this.m_prefSize.height += n2;
        }
        this.m_size = new Dimension(this.m_prefSize);
        this.m_initialized = true;
    }

    protected void finalizeGeometry(int n, int n2, int n3, int n4, boolean bl) {
        this.m_orgx = n;
        this.m_orgy = n2;
        this.m_size.width = n3;
        this.m_size.height = n4;
        if (this.m_comp != null) {
            Insets insets = this.m_constraints.m_insets;
            if (insets != null) {
                this.m_compOrgx = n + insets.left;
                this.m_compOrgy = n2 + insets.top;
                this.m_compWidth = n3 - (insets.right + insets.left);
                this.m_compHeight = n4 - (insets.bottom + insets.top);
            } else {
                this.m_compOrgx = n;
                this.m_compOrgy = n2;
                this.m_compWidth = n3;
                this.m_compHeight = n4;
            }
            this.adjustForGravity();
            if (bl) {
                this.m_comp.setBounds(this.m_compOrgx, this.m_compOrgy, this.m_compWidth, this.m_compHeight);
                this.m_comp.validate();
            }
        }
    }

    protected MosaicInteriorNode ensureCapacity(int n, int n2) {
        MosaicInteriorNode mosaicInteriorNode = new MosaicInteriorNode(this.m_layout);
        mosaicInteriorNode.setParent(this.m_parent, this.m_parentCol, this.m_parentRow);
        mosaicInteriorNode.ensureCapacity(n, n2);
        this.setParent(mosaicInteriorNode, 0, 0);
        return mosaicInteriorNode;
    }

    protected void adjustForGravity() {
        int n;
        int n2;
        if (this.m_constraints.m_fill == 2) {
            return;
        }
        if (this.m_constraints.m_fill == 0) {
            n2 = 0;
        } else {
            n2 = this.m_compWidth - this.m_minSize.width;
            this.m_compWidth = this.m_minSize.width;
        }
        if (this.m_constraints.m_fill == 1) {
            n = 0;
        } else {
            n = this.m_compHeight - this.m_minSize.height;
            this.m_compHeight = this.m_minSize.height;
        }
        switch (this.m_constraints.m_anchor) {
            case 0: {
                this.m_compOrgx += n2 / 2;
                this.m_compOrgy += n / 2;
                break;
            }
            case 1: {
                this.m_compOrgx += n2;
                this.m_compOrgy += n / 2;
                break;
            }
            case 2: {
                this.m_compOrgx += n2 / 2;
                break;
            }
            case 3: {
                this.m_compOrgx += n2;
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.m_compOrgx += n2 / 2;
                this.m_compOrgy += n;
                break;
            }
            case 6: {
                this.m_compOrgx += n2;
                this.m_compOrgy += n;
                break;
            }
            case 7: {
                this.m_compOrgy += n;
                break;
            }
            case 9: {
                this.m_compOrgy += n / 2;
            }
        }
    }

    protected void handleEvent(Event event) {
        this.m_layout.defaultCursor();
    }

    protected void paint(Graphics graphics) {
        graphics.clearRect(this.m_orgx, this.m_orgy, this.m_size.width, this.m_size.height);
    }

    protected void print(String string) {
        System.out.println(string + "leaf node " + this.m_coordStack.toString());
        super.print(string + "o ");
    }
}

