/*
 * Decompiled with CFR 0.152.
 */
package nom.rb.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import nom.rb.common.MosaicConstraints;
import nom.rb.common.MosaicCoord;
import nom.rb.common.MosaicCoordStack;
import nom.rb.common.MosaicInteriorNode;
import nom.rb.common.MosaicLeafNode;
import nom.rb.common.MosaicNode;
import nom.rb.common.MosaicPanel;

public class MosaicLayout
implements LayoutManager {
    protected Hashtable m_name2Constraints = new Hashtable();
    protected Hashtable m_comp2Node = new Hashtable();
    protected MosaicCoordStack m_lastCoordStack = null;
    protected MosaicCoordStack m_nextCoordStack = null;
    protected MosaicNode m_root = null;
    protected MosaicPanel m_panel = null;
    protected Frame m_frame = null;
    protected MosaicInteriorNode m_activeNode = null;
    protected int colSashCursor = 0;
    protected int rowSashCursor = 0;
    protected int crossSashCursor = 0;
    protected int m_topLevelSashSize = 7;
    protected int m_medLevelSashSize = 7;
    protected boolean m_liveDrag = true;
    protected boolean m_initialized = false;
    protected boolean m_finalized = false;

    public MosaicLayout() {
        this.setConstraints("Default", new MosaicConstraints());
        this.setConstraints("Centered", new MosaicConstraints(0, 3));
    }

    public void addLayoutComponent(String string, Component component) {
        if (this.m_comp2Node.containsKey(component)) {
            this.lookupNode((Component)component).m_constraints = this.newConstraints(string);
        } else {
            this.m_comp2Node.put(component, new MosaicLeafNode(this, component, this.newConstraints(string), this.newCoordStack()));
        }
        this.m_finalized = false;
        this.m_initialized = false;
    }

    public void layoutContainer(Container container) {
        this.checkPanel(container);
        this.initializeGeometry(container);
        if (this.m_root != null) {
            Insets insets = container.getInsets();
            Dimension dimension = container.getSize();
            this.m_root.finalizeGeometry(insets.left, insets.top, dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom, true);
        }
        this.m_finalized = true;
    }

    public Dimension minimumLayoutSize(Container container) {
        this.checkPanel(container);
        this.initializeGeometry(container);
        if (this.m_root == null) {
            return new Dimension(0, 0);
        }
        return this.m_root.m_minSize;
    }

    public Dimension preferredLayoutSize(Container container) {
        this.checkPanel(container);
        this.initializeGeometry(container);
        if (this.m_root == null) {
            return new Dimension(0, 0);
        }
        return this.m_root.m_prefSize;
    }

    public void removeLayoutComponent(Component component) {
        if (this.m_comp2Node.containsKey(component)) {
            this.m_comp2Node.remove(component);
            this.m_finalized = false;
            this.m_initialized = false;
        }
    }

    public void setConstraints(MosaicConstraints mosaicConstraints) {
        this.setConstraints("Default", mosaicConstraints);
    }

    public void setConstraints(String string, MosaicConstraints mosaicConstraints) {
        this.m_name2Constraints.put(string, mosaicConstraints.clone());
    }

    public void setConstraints(Component component, MosaicConstraints mosaicConstraints) {
        if (!this.m_comp2Node.containsKey(component)) {
            this.m_comp2Node.put(component, new MosaicLeafNode(this, component, (MosaicConstraints)mosaicConstraints.clone(), this.newCoordStack()));
        } else {
            MosaicLeafNode mosaicLeafNode = this.lookupNode(component);
            mosaicLeafNode.m_constraints = (MosaicConstraints)mosaicConstraints.clone();
            mosaicLeafNode.m_initialized = false;
        }
        this.m_finalized = false;
        this.m_initialized = false;
    }

    public MosaicConstraints getConstraints() {
        return this.getConstraints("Default");
    }

    public MosaicConstraints getConstraints(String string) {
        MosaicConstraints mosaicConstraints = this.lookupConstraints(string);
        if (mosaicConstraints != null) {
            return (MosaicConstraints)mosaicConstraints.clone();
        }
        return null;
    }

    public MosaicConstraints getConstraints(Component component) throws NoSuchElementException {
        MosaicLeafNode mosaicLeafNode = this.lookupNode(component);
        if (mosaicLeafNode == null) {
            throw new NoSuchElementException();
        }
        return (MosaicConstraints)mosaicLeafNode.m_constraints.clone();
    }

    public void setCoordStack(MosaicCoordStack mosaicCoordStack) {
        this.m_nextCoordStack = (MosaicCoordStack)mosaicCoordStack.clone();
    }

    public void setCoordStack(Component component, MosaicCoordStack mosaicCoordStack) {
        this.m_lastCoordStack = (MosaicCoordStack)mosaicCoordStack.clone();
        this.m_nextCoordStack = null;
        if (!this.m_comp2Node.containsKey(component)) {
            this.m_comp2Node.put(component, new MosaicLeafNode(this, component, this.newConstraints("Default"), this.m_lastCoordStack));
        } else {
            this.lookupNode((Component)component).m_coordStack = this.m_lastCoordStack;
        }
        this.m_finalized = false;
        this.m_initialized = false;
    }

    public MosaicCoordStack getCoordStack(Component component) throws NoSuchElementException {
        MosaicLeafNode mosaicLeafNode = this.lookupNode(component);
        if (mosaicLeafNode == null) {
            throw new NoSuchElementException();
        }
        return (MosaicCoordStack)mosaicLeafNode.m_coordStack.clone();
    }

    public void setPos(int n, int n2) {
        this.m_nextCoordStack = new MosaicCoordStack();
        this.m_nextCoordStack.setPos(n, n2);
    }

    public void setPos(int n, int n2, int n3, int n4) {
        this.m_nextCoordStack = new MosaicCoordStack();
        this.m_nextCoordStack.setPos(n, n2, n3, n4);
    }

    public void setPos(int n, int n2, int n3, int n4, int n5, int n6) {
        this.m_nextCoordStack = new MosaicCoordStack();
        this.m_nextCoordStack.setPos(n, n2, n3, n4);
        this.m_nextCoordStack.pushPos(n5, n6);
    }

    public void setPos(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.m_nextCoordStack = new MosaicCoordStack();
        this.m_nextCoordStack.setPos(n, n2, n3, n4);
        this.m_nextCoordStack.pushPos(n5, n6);
        this.m_nextCoordStack.pushPos(n7, n8);
    }

    protected int getSashSize(boolean bl) {
        if (this.m_panel == null) {
            return 0;
        }
        return bl ? this.m_topLevelSashSize : this.m_medLevelSashSize;
    }

    protected void checkPanel(Container container) {
        if (this.m_panel != null) {
            return;
        }
        if (!(container instanceof MosaicPanel)) {
            this.m_panel = null;
            this.m_frame = null;
            return;
        }
        this.m_panel = (MosaicPanel)container;
        while (container != null && !(container instanceof Frame)) {
            container = container.getParent();
        }
        this.m_frame = (Frame)container;
        if (this.m_frame != null) {
            this.colSashCursor = 11;
            this.rowSashCursor = 8;
            this.crossSashCursor = 13;
        }
    }

    protected boolean handleEvent(Event event) {
        if (!this.m_finalized || this.m_root == null) {
            return false;
        }
        switch (event.id) {
            case 505: {
                if (this.m_activeNode != null) break;
                this.defaultCursor();
                break;
            }
            case 501: 
            case 503: 
            case 504: {
                if (this.m_activeNode != null) break;
                this.m_root.handleEvent(event);
                break;
            }
            case 502: {
                if (this.m_activeNode == null) break;
                this.m_activeNode.drag(event.x, event.y);
                this.m_activeNode.releaseSash();
                this.m_root.handleEvent(event);
                this.m_panel.validate();
                break;
            }
            case 506: {
                if (this.m_activeNode == null) break;
                this.m_activeNode.drag(event.x, event.y);
            }
        }
        return true;
    }

    protected void paint(Graphics graphics) {
        if (this.m_finalized && this.m_root != null) {
            this.m_root.paint(graphics);
        }
    }

    protected MosaicConstraints lookupConstraints(String string) {
        return (MosaicConstraints)this.m_name2Constraints.get(string);
    }

    protected MosaicLeafNode lookupNode(Component component) {
        return (MosaicLeafNode)this.m_comp2Node.get(component);
    }

    protected MosaicConstraints newConstraints(String string) {
        MosaicConstraints mosaicConstraints = this.getConstraints(string);
        if (mosaicConstraints == null && (mosaicConstraints = this.getConstraints("Default")) == null) {
            mosaicConstraints = new MosaicConstraints();
        }
        return mosaicConstraints;
    }

    protected MosaicCoordStack newCoordStack() {
        if (this.m_nextCoordStack != null) {
            this.m_lastCoordStack = this.m_nextCoordStack;
            this.m_nextCoordStack = null;
        } else if (this.m_lastCoordStack != null) {
            this.m_lastCoordStack = (MosaicCoordStack)this.m_lastCoordStack.clone();
            this.m_lastCoordStack.nextCol();
        } else {
            this.m_lastCoordStack = new MosaicCoordStack();
        }
        return this.m_lastCoordStack;
    }

    protected void initializeGeometry(Container container) {
        int n;
        Component[] componentArray = container.getComponents();
        for (n = 0; n < componentArray.length; ++n) {
            if (this.m_comp2Node.containsKey(componentArray[n])) continue;
            this.addLayoutComponent("", componentArray[n]);
            this.m_initialized = false;
        }
        if (this.m_initialized) {
            return;
        }
        this.m_root = null;
        for (n = 0; n < componentArray.length; ++n) {
            this.addNode(this.lookupNode(componentArray[n]));
        }
        if (this.m_root != null) {
            this.m_root.initializeGeometry();
        }
        this.m_initialized = true;
    }

    protected void addNode(MosaicLeafNode mosaicLeafNode) {
        MosaicCoord mosaicCoord;
        Enumeration enumeration = mosaicLeafNode.m_coordStack.elements();
        MosaicCoord mosaicCoord2 = mosaicCoord = enumeration.hasMoreElements() ? (MosaicCoord)enumeration.nextElement() : new MosaicCoord(0, 0);
        if (this.m_root == null) {
            if (!enumeration.hasMoreElements() && mosaicCoord.m_col == 0 && mosaicCoord.m_row == 0) {
                mosaicLeafNode.setParent();
                this.m_root = mosaicLeafNode;
                return;
            }
            this.m_root = new MosaicInteriorNode(this);
        }
        MosaicInteriorNode mosaicInteriorNode = this.m_root.ensureCapacity(mosaicCoord.m_col, mosaicCoord.m_row);
        this.m_root = mosaicInteriorNode;
        while (enumeration.hasMoreElements()) {
            MosaicNode mosaicNode = mosaicInteriorNode.m_node[mosaicCoord.m_col][mosaicCoord.m_row];
            MosaicCoord mosaicCoord3 = (MosaicCoord)enumeration.nextElement();
            if (mosaicNode == null && !enumeration.hasMoreElements() && mosaicCoord3.m_col == 0 && mosaicCoord3.m_row == 0) break;
            if (mosaicNode == null) {
                mosaicNode = new MosaicInteriorNode(this);
                mosaicNode.setParent(mosaicInteriorNode, mosaicCoord.m_col, mosaicCoord.m_row);
            }
            mosaicInteriorNode = mosaicNode.ensureCapacity(mosaicCoord3.m_col, mosaicCoord3.m_row);
            mosaicCoord = mosaicCoord3;
        }
        mosaicInteriorNode.m_node[mosaicCoord.m_col][mosaicCoord.m_row] = mosaicLeafNode;
        mosaicLeafNode.setParent(mosaicInteriorNode, mosaicCoord.m_col, mosaicCoord.m_row);
    }

    protected void defaultCursor() {
        if (this.m_frame != null && this.m_frame.getCursor().getType() != 0) {
            this.m_frame.setCursor(Cursor.getDefaultCursor());
        }
    }

    protected void printTree() {
        if (this.m_root != null) {
            this.m_root.print("");
        }
    }
}

